/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;

class DefaultErrorHandler
implements ErrorHandler {
    DefaultErrorHandler() {
    }

    public void jspError(String fname, int line, int column, String errMsg, Exception ex) throws JasperException {
        throw new JasperException(fname + "(" + line + "," + column + ")" + " " + errMsg, (Throwable)ex);
    }

    public void jspError(String errMsg, Exception ex) throws JasperException {
        throw new JasperException(errMsg, (Throwable)ex);
    }

    public void javacError(JavacErrorDetail[] details) throws JasperException {
        if (details == null) {
            return;
        }
        Object[] args = null;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < details.length; ++i) {
            buf.append("\n");
            if (details[i].getJspBeginLineNumber() >= 0) {
                buf.append("JSP FileName:").append(details[i].getJspFileName()).append("\n");
                buf.append("Java FileName:").append(details[i].getJavaFileName()).append("\n");
                args = new Object[]{new Integer(details[i].getJspBeginLineNumber()), details[i].getJspFileName()};
                buf.append("\n");
                buf.append(Localizer.getMessage("jsp.error.single.line.number", args));
                buf.append("\n");
                buf.append(details[i].getErrorMessage());
                buf.append("\n");
                buf.append(details[i].getJspExtract());
                continue;
            }
            buf.append("JSP FileName:").append(details[i].getJspFileName()).append("\n");
            buf.append("Java FileName:").append(details[i].getJavaFileName()).append("\n");
            args = new Object[]{new Integer(details[i].getJavaLineNumber())};
            buf.append("\n\n");
            buf.append(Localizer.getMessage("jsp.error.java.line.number", args));
            buf.append("\n");
            buf.append(details[i].getErrorMessage());
        }
        System.out.println("[COVALENT-DEBUG] JSP Compile Error: " + buf);
        buf.append("\n\nStacktrace:");
        throw new JasperException(Localizer.getMessage("jsp.error.unable.compile") + ": " + buf);
    }

    public void javacError(String errorReport, Exception exception) throws JasperException {
        System.out.println("[COVALENT-DEBUG] JSP Compile Error: " + errorReport);
        exception.printStackTrace();
        throw new JasperException(Localizer.getMessage("jsp.error.unable.compile"), (Throwable)exception);
    }
}

