/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.util.JDBCExceptionReporter;

class ManagedProviderConnectionHelper
implements ConnectionHelper {
    private Properties cfgProperties;
    private ConnectionProvider connectionProvider;
    private Connection connection;

    public ManagedProviderConnectionHelper(Properties cfgProperties) {
        this.cfgProperties = cfgProperties;
    }

    public void prepare(boolean needsAutoCommit) throws SQLException {
        this.connectionProvider = ConnectionProviderFactory.newConnectionProvider(this.cfgProperties);
        this.connection = this.connectionProvider.getConnection();
        if (needsAutoCommit && !this.connection.getAutoCommit()) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws SQLException {
        if (this.connection != null) {
            try {
                JDBCExceptionReporter.logAndClearWarnings(this.connection);
                this.connectionProvider.closeConnection(this.connection);
            }
            finally {
                this.connectionProvider.close();
            }
        }
        this.connection = null;
    }
}

