/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.File;
import java.io.IOException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TempFileProvider {
    public static final String ALFRESCO_TEMP_FILE_DIR = "Alfresco";
    public static final String ALFRESCO_LONG_LIFE_FILE_DIR = "longLife";
    public static final String SYSTEM_KEY_TEMP_DIR = "java.io.tmpdir";
    private static final Log logger = LogFactory.getLog(TempFileProvider.class);
    private static int MAX_RETRIES = 3;

    private TempFileProvider() {
    }

    public static File getSystemTempDir() {
        String systemTempDirPath = System.getProperty(SYSTEM_KEY_TEMP_DIR);
        if (systemTempDirPath == null) {
            throw new AlfrescoRuntimeException("System property not available: java.io.tmpdir");
        }
        File systemTempDir = new File(systemTempDirPath);
        return systemTempDir;
    }

    public static File getTempDir() {
        File systemTempDir = TempFileProvider.getSystemTempDir();
        File tempDir = new File(systemTempDir, ALFRESCO_TEMP_FILE_DIR);
        if (!tempDir.exists()) {
            if (!tempDir.mkdirs()) {
                throw new AlfrescoRuntimeException("Failed to create temp directory: " + tempDir);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created temp directory: " + tempDir));
            }
        }
        return tempDir;
    }

    public static File getLongLifeTempDir(String key) {
        String folderName = "longLife_" + key;
        File tempDir = TempFileProvider.getTempDir();
        File longLifeDir = new File(tempDir, folderName);
        if (longLifeDir.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Already exists: " + longLifeDir));
            }
            return longLifeDir;
        }
        for (int retry = 0; retry < MAX_RETRIES; ++retry) {
            boolean created = longLifeDir.mkdirs();
            if (created) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created long life temp directory: " + longLifeDir));
                }
                return longLifeDir;
            }
            if (!longLifeDir.exists()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Another thread created long life temp directory: " + longLifeDir));
            }
            return longLifeDir;
        }
        throw new AlfrescoRuntimeException("Failed to create temp directory: " + longLifeDir);
    }

    private static boolean isLongLifeTempDir(File file) {
        if (file.isDirectory()) {
            return file.getName().startsWith(ALFRESCO_LONG_LIFE_FILE_DIR);
        }
        return false;
    }

    public static File createTempFile(String prefix, String suffix) {
        File tempDir = TempFileProvider.getTempDir();
        return TempFileProvider.createTempFile(prefix, suffix, tempDir);
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        try {
            File tempFile = File.createTempFile(prefix, suffix, directory);
            return tempFile;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to created temp file: \n   prefix: " + prefix + "\n" + "   suffix: " + suffix + "\n" + "   directory: " + directory, e);
        }
    }

    public static class TempFileCleanerJob
    implements Job {
        public static final String KEY_PROTECT_HOURS = "protectHours";

        public void execute(JobExecutionContext context) throws JobExecutionException {
            String strProtectHours = (String)context.getJobDetail().getJobDataMap().get((Object)KEY_PROTECT_HOURS);
            if (strProtectHours == null) {
                throw new JobExecutionException("Missing job data: protectHours");
            }
            int protectHours = -1;
            try {
                protectHours = Integer.parseInt(strProtectHours);
            }
            catch (NumberFormatException e) {
                throw new JobExecutionException("Invalid job data protectHours: " + strProtectHours);
            }
            if (protectHours < 0 || protectHours > 8760) {
                throw new JobExecutionException("Hours to protect temp files must be 0 <= x <= 8760");
            }
            long now = System.currentTimeMillis();
            long aFewHoursBack = now - 3600000L * (long)protectHours;
            long aLongTimeBack = now - 86400000L;
            File tempDir = TempFileProvider.getTempDir();
            int count = TempFileCleanerJob.removeFiles(tempDir, aFewHoursBack, aLongTimeBack, false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed " + count + " files from temp directory: " + tempDir));
            }
        }

        public static int removeFiles(long removeBefore) {
            File tempDir = TempFileProvider.getTempDir();
            return TempFileCleanerJob.removeFiles(tempDir, removeBefore, removeBefore, false);
        }

        private static int removeFiles(File directory, long removeBefore, long longLifeBefore, boolean removeDir) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException("Expected a directory to clear: " + directory);
            }
            if (!directory.exists()) {
                return 0;
            }
            File[] files = directory.listFiles();
            int count = 0;
            for (File file : files) {
                if (file.isDirectory()) {
                    if (TempFileProvider.isLongLifeTempDir(file)) {
                        TempFileCleanerJob.removeFiles(file, longLifeBefore, longLifeBefore, true);
                        continue;
                    }
                    TempFileCleanerJob.removeFiles(file, removeBefore, longLifeBefore, true);
                    continue;
                }
                if (file.lastModified() > removeBefore) continue;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting temp file: " + file));
                    }
                    file.delete();
                    ++count;
                }
                catch (Throwable e) {
                    logger.info((Object)("Failed to remove temp file: " + file));
                }
            }
            if (removeDir) {
                try {
                    File[] listing = directory.listFiles();
                    if (listing != null && listing.length == 0) {
                        directory.delete();
                    }
                }
                catch (Throwable e) {
                    logger.info((Object)("Failed to remove temp directory: " + directory), e);
                }
            }
            return count;
        }
    }
}

