/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.catalina.cluster.deploy.FileMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileMessageFactory {
    public static Log log = LogFactory.getLog(FileMessageFactory.class);
    public static final int READ_SIZE = 10240;
    protected File file = null;
    protected boolean openForWrite;
    protected boolean closed = false;
    protected FileInputStream in;
    protected FileOutputStream out;
    protected int nrOfMessagesProcessed = 0;
    protected long size = 0L;
    protected long totalNrOfMessages = 0L;
    protected byte[] data = new byte[10240];

    private FileMessageFactory(File f, boolean openForWrite) throws FileNotFoundException, IOException {
        this.file = f;
        this.openForWrite = openForWrite;
        if (log.isDebugEnabled()) {
            log.debug((Object)("open file " + f + " write " + openForWrite));
        }
        if (openForWrite) {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.out = new FileOutputStream(f);
        } else {
            this.size = this.file.length();
            this.totalNrOfMessages = this.size / 10240L + 1L;
            this.in = new FileInputStream(f);
        }
    }

    public static FileMessageFactory getInstance(File f, boolean openForWrite) throws FileNotFoundException, IOException {
        return new FileMessageFactory(f, openForWrite);
    }

    public FileMessage readMessage(FileMessage f) throws IllegalArgumentException, IOException {
        this.checkState(false);
        int length = this.in.read(this.data);
        if (length == -1) {
            this.cleanup();
            return null;
        }
        f.setData(this.data, length);
        f.setTotalLength(this.size);
        f.setTotalNrOfMsgs(this.totalNrOfMessages);
        f.setMessageNumber(++this.nrOfMessagesProcessed);
        return f;
    }

    public boolean writeMessage(FileMessage msg) throws IllegalArgumentException, IOException {
        if (!this.openForWrite) {
            throw new IllegalArgumentException("Can't write message, this factory is reading.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message " + msg + " data " + msg.getData() + " data length " + msg.getDataLength() + " out " + this.out));
        }
        if (this.out != null) {
            this.out.write(msg.getData(), 0, msg.getDataLength());
            ++this.nrOfMessagesProcessed;
            this.out.flush();
            if ((long)msg.getMessageNumber() == msg.getTotalNrOfMsgs()) {
                this.out.close();
                this.cleanup();
                return true;
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Receive Message again -- Sender ActTimeout to short [ path: " + msg.getContextPath() + " war: " + msg.getFileName() + " data: " + msg.getData() + " data length: " + msg.getDataLength() + " ]"));
        }
        return false;
    }

    public void cleanup() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.in = null;
        this.out = null;
        this.size = 0L;
        this.closed = true;
        this.data = null;
        this.nrOfMessagesProcessed = 0;
        this.totalNrOfMessages = 0L;
    }

    protected void checkState(boolean openForWrite) throws IllegalArgumentException {
        if (this.openForWrite != openForWrite) {
            this.cleanup();
            if (openForWrite) {
                throw new IllegalArgumentException("Can't write message, this factory is reading.");
            }
            throw new IllegalArgumentException("Can't read message, this factory is writing.");
        }
        if (this.closed) {
            this.cleanup();
            throw new IllegalArgumentException("Factory has been closed.");
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Usage: FileMessageFactory fileToBeRead fileToBeWritten");
        System.out.println("Usage: This will make a copy of the file on the local file system");
        FileMessageFactory read = FileMessageFactory.getInstance(new File(args[0]), false);
        FileMessageFactory write = FileMessageFactory.getInstance(new File(args[1]), true);
        FileMessage msg = new FileMessage(null, args[0], args[0]);
        msg = read.readMessage(msg);
        System.out.println("Expecting to write " + msg.getTotalNrOfMsgs() + " messages.");
        int cnt = 0;
        while (msg != null) {
            write.writeMessage(msg);
            ++cnt;
            msg = read.readMessage(msg);
        }
        System.out.println("Actually wrote " + cnt + " messages.");
    }

    public File getFile() {
        return this.file;
    }
}

