/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.cluster.mcast.McastMember;

public class McastMembership {
    protected static final McastMember[] EMPTY_MEMBERS = new McastMember[0];
    protected String name;
    protected Map map = new HashMap();
    protected McastMember[] members = EMPTY_MEMBERS;
    protected MemberComparator memberComparator = new MemberComparator();

    public McastMembership(String name) {
        this.name = name;
    }

    public synchronized void reset() {
        this.map.clear();
        this.members = EMPTY_MEMBERS;
    }

    public synchronized boolean memberAlive(McastMember member) {
        boolean result = false;
        if (member.getName().equals(this.name)) {
            return result;
        }
        MbrEntry entry = (MbrEntry)this.map.get(member.getName());
        if (entry == null) {
            entry = new MbrEntry(member);
            this.map.put(member.getName(), entry);
            this.addMcastMember(member);
            result = true;
        } else {
            McastMember updateMember = entry.getMember();
            if (updateMember.getMemberAliveTime() != member.getMemberAliveTime()) {
                updateMember.setMemberAliveTime(member.getMemberAliveTime());
                Arrays.sort(this.members, this.memberComparator);
            }
        }
        entry.accessed();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMcastMember(McastMember member) {
        McastMember[] mcastMemberArray = this.members;
        synchronized (this.members) {
            McastMember[] results = new McastMember[this.members.length + 1];
            for (int i = 0; i < this.members.length; ++i) {
                results[i] = this.members[i];
            }
            results[this.members.length] = member;
            this.members = results;
            Arrays.sort(this.members, this.memberComparator);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMcastMember(McastMember member) {
        McastMember[] mcastMemberArray = this.members;
        synchronized (this.members) {
            int n = -1;
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] != member) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            McastMember[] results = new McastMember[this.members.length - 1];
            int j = 0;
            for (int i = 0; i < this.members.length; ++i) {
                if (i == n) continue;
                results[j++] = this.members[i];
            }
            this.members = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized McastMember[] expire(long maxtime) {
        if (!this.hasMembers()) {
            return EMPTY_MEMBERS;
        }
        ArrayList<McastMember> list = null;
        for (MbrEntry entry : this.map.values()) {
            if (!entry.hasExpired(maxtime)) continue;
            if (list == null) {
                list = new ArrayList<McastMember>();
            }
            list.add(entry.getMember());
        }
        if (list != null) {
            McastMember[] result = new McastMember[list.size()];
            list.toArray(result);
            for (int j = 0; j < result.length; ++j) {
                this.map.remove(result[j].getName());
                this.removeMcastMember(result[j]);
            }
            return result;
        }
        return EMPTY_MEMBERS;
    }

    public synchronized boolean hasMembers() {
        return this.members.length > 0;
    }

    public synchronized McastMember[] getMembers() {
        if (this.hasMembers()) {
            return this.members;
        }
        return EMPTY_MEMBERS;
    }

    protected synchronized MbrEntry[] getMemberEntries() {
        MbrEntry[] result = new MbrEntry[this.map.size()];
        Iterator i = this.map.entrySet().iterator();
        int pos = 0;
        while (i.hasNext()) {
            result[pos++] = (MbrEntry)i.next().getValue();
        }
        return result;
    }

    protected static class MbrEntry {
        protected McastMember mbr;
        protected long lastHeardFrom;

        public MbrEntry(McastMember mbr) {
            this.mbr = mbr;
        }

        public void accessed() {
            this.lastHeardFrom = System.currentTimeMillis();
        }

        public McastMember getMember() {
            return this.mbr;
        }

        public boolean hasExpired(long maxtime) {
            long delta = System.currentTimeMillis() - this.lastHeardFrom;
            return delta > maxtime;
        }
    }

    private class MemberComparator
    implements Comparator {
        private MemberComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                return this.compare((McastMember)o1, (McastMember)o2);
            }
            catch (ClassCastException x) {
                return 0;
            }
        }

        public int compare(McastMember m1, McastMember m2) {
            long result = m2.getMemberAliveTime() - m1.getMemberAliveTime();
            if (result < 0L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

