/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.zip.GZIPInputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.session.ReplicationStream;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.catalina.cluster.tcp.SimpleTcpCluster;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClusterReceiverBase
implements Runnable,
ClusterReceiver,
ListenCallback {
    protected static Log log = LogFactory.getLog(ClusterReceiverBase.class);
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private CatalinaCluster cluster;
    private InetAddress bind;
    private String tcpListenAddress;
    private int tcpListenPort;
    private boolean sendAck;
    protected boolean doListen = false;
    protected long totalReceivedBytes = 0L;
    protected boolean doReceivedProcessingStats = false;
    protected long receivedProcessingTime = 0L;
    protected long minReceivedProcessingTime = Long.MAX_VALUE;
    protected long maxReceivedProcessingTime = 0L;
    private long nrOfMsgsReceived = 0L;
    private long receivedTime = 0L;
    private long lastChecked = System.currentTimeMillis();
    private int rxBufSize = 43800;
    private int txBufSize = 25188;
    private boolean tcpNoDelay = true;
    private boolean soKeepAlive = false;
    private boolean ooBInline = true;
    private boolean soReuseAddress = true;
    private boolean soLingerOn = true;
    private int soLingerTime = 3;
    private int soTrafficClass = 28;
    private int timeout = -1;
    private boolean compress = true;
    private ObjectName objectName;

    public boolean isOoBInline() {
        return this.ooBInline;
    }

    public void setOoBInline(boolean ooBInline) {
        this.ooBInline = ooBInline;
    }

    public int getRxBufSize() {
        return this.rxBufSize;
    }

    public void setRxBufSize(int rxBufSize) {
        this.rxBufSize = rxBufSize;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public void setSoKeepAlive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public boolean isSoLingerOn() {
        return this.soLingerOn;
    }

    public void setSoLingerOn(boolean soLingerOn) {
        this.soLingerOn = soLingerOn;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public void setSoLingerTime(int soLingerTime) {
        this.soLingerTime = soLingerTime;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public void setSoReuseAddress(boolean soReuseAddress) {
        this.soReuseAddress = soReuseAddress;
    }

    public int getSoTrafficClass() {
        return this.soTrafficClass;
    }

    public void setSoTrafficClass(int soTrafficClass) {
        this.soTrafficClass = soTrafficClass;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTxBufSize() {
        return this.txBufSize;
    }

    public void setTxBufSize(int txBufSize) {
        this.txBufSize = txBufSize;
    }

    public boolean isDoListen() {
        return this.doListen;
    }

    public InetAddress getBind() {
        if (this.bind == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starting replication listener on address:" + this.tcpListenAddress));
                }
                this.bind = InetAddress.getByName(this.tcpListenAddress);
            }
            catch (IOException ioe) {
                log.error((Object)("Failed bind replication listener on address:" + this.tcpListenAddress), (Throwable)ioe);
            }
        }
        return this.bind;
    }

    public void setBind(InetAddress bind) {
        this.bind = bind;
    }

    public void setCatalinaCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public CatalinaCluster getCatalinaCluster() {
        return this.cluster;
    }

    public void setObjectName(ObjectName name) {
        this.objectName = name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compressMessageData) {
        this.compress = compressMessageData;
    }

    public boolean isSendAck() {
        return this.sendAck;
    }

    public void setSendAck(boolean sendAck) {
        this.sendAck = sendAck;
    }

    public String getTcpListenAddress() {
        return this.tcpListenAddress;
    }

    public void setTcpListenAddress(String tcpListenAddress) {
        try {
            this.tcpListenAddress = "auto".equals(tcpListenAddress) ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getByName(tcpListenAddress).getHostAddress();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set replication listener on address:" + this.tcpListenAddress));
            }
        }
        catch (IOException ioe) {
            log.error((Object)("Failed get Inet address at replication listener on address:" + tcpListenAddress), (Throwable)ioe);
        }
    }

    public int getTcpListenPort() {
        return this.tcpListenPort;
    }

    public void setTcpListenPort(int tcpListenPort) {
        this.tcpListenPort = tcpListenPort;
    }

    public String getHost() {
        return this.getTcpListenAddress();
    }

    public int getPort() {
        return this.getTcpListenPort();
    }

    public boolean isDoReceivedProcessingStats() {
        return this.doReceivedProcessingStats;
    }

    public void setDoReceivedProcessingStats(boolean doReceiverProcessingStats) {
        this.doReceivedProcessingStats = doReceiverProcessingStats;
    }

    public long getMaxReceivedProcessingTime() {
        return this.maxReceivedProcessingTime;
    }

    public long getMinReceivedProcessingTime() {
        return this.minReceivedProcessingTime;
    }

    public long getReceivedProcessingTime() {
        return this.receivedProcessingTime;
    }

    public long getTotalReceivedBytes() {
        return this.totalReceivedBytes;
    }

    public double getAvgReceivedProcessingTime() {
        if (this.nrOfMsgsReceived > 0L) {
            return (double)this.receivedProcessingTime / (double)this.nrOfMsgsReceived;
        }
        return 0.0;
    }

    public long getAvgTotalReceivedBytes() {
        if (this.nrOfMsgsReceived > 0L) {
            return this.totalReceivedBytes / this.nrOfMsgsReceived;
        }
        return 0L;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public long getNrOfMsgsReceived() {
        return this.nrOfMsgsReceived;
    }

    public void start() {
        try {
            this.getBind();
            Thread t = new Thread((Runnable)this, "ClusterReceiver");
            t.setDaemon(true);
            t.start();
        }
        catch (Exception x) {
            log.fatal((Object)"Unable to start cluster receiver", (Throwable)x);
        }
        this.registerReceiverMBean();
    }

    public void stop() {
        this.stopListening();
        this.unregisterRecevierMBean();
    }

    protected void registerReceiverMBean() {
        if (this.cluster != null && this.cluster instanceof SimpleTcpCluster) {
            SimpleTcpCluster scluster = (SimpleTcpCluster)this.cluster;
            ObjectName clusterName = scluster.getObjectName();
            try {
                ObjectName receiverName;
                MBeanServer mserver = scluster.getMBeanServer();
                Container container = this.cluster.getContainer();
                String name = clusterName.getDomain() + ":type=ClusterReceiver";
                if (container instanceof StandardHost) {
                    name = name + ",host=" + clusterName.getKeyProperty("host");
                }
                if (mserver.isRegistered(receiverName = new ObjectName(name))) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.already", (Object)receiverName));
                    }
                    return;
                }
                this.setObjectName(receiverName);
                mserver.registerMBean(scluster.getManagedBean(this), this.getObjectName());
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    protected void unregisterRecevierMBean() {
        if (this.cluster != null && this.getObjectName() != null && this.cluster instanceof SimpleTcpCluster) {
            SimpleTcpCluster scluster = (SimpleTcpCluster)this.cluster;
            try {
                MBeanServer mserver = scluster.getMBeanServer();
                mserver.unregisterMBean(this.getObjectName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected abstract void stopListening();

    protected abstract void listen() throws Exception;

    public void run() {
        try {
            this.listen();
        }
        catch (Exception x) {
            log.error((Object)"Unable to start cluster listener.", (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageDataReceived(ClusterData data) {
        long timeSent = 0L;
        if (this.doReceivedProcessingStats) {
            timeSent = System.currentTimeMillis();
        }
        try {
            ClusterMessage message = this.deserialize(data);
            this.cluster.receive(message);
        }
        catch (Exception x) {
            log.error((Object)"Unable to deserialize session message or unexpected exception from message listener.", (Throwable)x);
        }
        finally {
            if (this.doReceivedProcessingStats) {
                this.addReceivedProcessingStats(timeSent);
            }
        }
    }

    protected ClusterMessage deserialize(ClusterData data) throws IOException, ClassNotFoundException {
        Object message = null;
        if (data != null) {
            InputStream instream = this.isCompress() || data.getCompress() == 1 ? new GZIPInputStream(new ByteArrayInputStream(data.getMessage())) : new ByteArrayInputStream(data.getMessage());
            ReplicationStream stream = new ReplicationStream(instream, this.getClass().getClassLoader());
            message = stream.readObject();
            this.totalReceivedBytes += (long)data.getMessage().length;
            ++this.nrOfMsgsReceived;
            instream.close();
        }
        if (message instanceof ClusterMessage) {
            return (ClusterMessage)message;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Message " + message.toString() + " from type " + message.getClass().getName() + " transfered but is not a cluster message"));
        }
        return null;
    }

    public synchronized void resetStatistics() {
        this.nrOfMsgsReceived = 0L;
        this.totalReceivedBytes = 0L;
        this.minReceivedProcessingTime = Long.MAX_VALUE;
        this.maxReceivedProcessingTime = 0L;
        this.receivedProcessingTime = 0L;
        this.receivedTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReceivedProcessingStats(long startTime) {
        long current = System.currentTimeMillis();
        long time = current - startTime;
        ClusterReceiverBase clusterReceiverBase = this;
        synchronized (clusterReceiverBase) {
            if (time < this.minReceivedProcessingTime) {
                this.minReceivedProcessingTime = time;
            }
            if (time > this.maxReceivedProcessingTime) {
                this.maxReceivedProcessingTime = time;
            }
            this.receivedProcessingTime += time;
        }
        if (log.isDebugEnabled() && current - this.lastChecked > 5000L) {
            log.debug((Object)("Calc msg send time total=" + this.receivedTime + "ms num request=" + this.nrOfMsgsReceived + " average per msg=" + this.receivedTime / this.nrOfMsgsReceived + "ms."));
            this.lastChecked = current;
        }
    }

    public void sendAck() throws IOException {
    }
}

