/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Properties;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDataSenderFactory {
    private static Log log = LogFactory.getLog(IDataSenderFactory.class);
    private static final String DATASENDERS_PROPERTIES = "org/apache/catalina/cluster/tcp/DataSenders.properties";
    public static final String SYNC_MODE = "synchronous";
    public static final String ASYNC_MODE = "asynchronous";
    public static final String POOLED_SYNC_MODE = "pooled";
    public static final String FAST_ASYNC_QUEUE_MODE = "fastasyncqueue";
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private static final String info = "IDataSenderFactory/2.0";
    private Properties senderModes;
    private static IDataSenderFactory factory = new IDataSenderFactory();

    private IDataSenderFactory() {
    }

    public static String getInfo() {
        return info;
    }

    public static synchronized IDataSender getIDataSender(String mode, Member mbr) throws IOException {
        IDataSender sender = factory.getSender(mode, mbr);
        if (sender == null) {
            throw new IOException("Invalid replication mode=" + mode);
        }
        return sender;
    }

    public static String validateMode(String mode) {
        if (factory.isSenderMode(mode)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("Replication mode has to be '");
        Iterator<Object> iter = IDataSenderFactory.factory.senderModes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            buffer.append(key);
            if (!iter.hasNext()) continue;
            buffer.append("', '");
        }
        return buffer.toString();
    }

    private boolean isSenderMode(String mode) {
        return this.senderModes != null && this.senderModes.containsKey(mode);
    }

    private IDataSender getSender(String mode, Member mbr) {
        IDataSender sender;
        block5: {
            sender = null;
            String senderName = null;
            senderName = this.senderModes.getProperty(mode);
            if (senderName != null) {
                try {
                    Class<?> senderClass = Class.forName(senderName);
                    Class[] paramTypes = new Class[]{Class.forName("java.lang.String"), Class.forName("java.net.InetAddress"), Integer.TYPE};
                    Constructor<?> constructor = senderClass.getConstructor(paramTypes);
                    if (constructor != null) {
                        Object[] paramValues = new Object[]{mbr.getDomain(), InetAddress.getByName(mbr.getHost()), new Integer(mbr.getPort())};
                        sender = (IDataSender)constructor.newInstance(paramValues);
                        break block5;
                    }
                    log.error((Object)sm.getString("IDataSender.senderModes.Instantiate", (Object)senderName));
                }
                catch (Throwable t) {
                    log.error((Object)sm.getString("IDataSender.senderModes.Instantiate", (Object)senderName), t);
                }
            } else {
                log.error((Object)sm.getString("IDataSender.senderModes.Missing", (Object)mode));
            }
        }
        return sender;
    }

    private synchronized void loadSenderModes() {
        if (this.senderModes == null) {
            try {
                InputStream is = IDataSender.class.getClassLoader().getResourceAsStream(DATASENDERS_PROPERTIES);
                if (is == null) {
                    log.error((Object)sm.getString("IDataSender.senderModes.Resources"));
                    return;
                }
                this.senderModes = new Properties();
                this.senderModes.load(is);
            }
            catch (IOException e) {
                log.error((Object)sm.getString("IDataSender.senderModes.Resources"), (Throwable)e);
                return;
            }
        }
    }

    static {
        factory.loadSenderModes();
    }
}

