/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import com.werken.saxpath.XPathReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneAnalyser;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParserException;
import org.alfresco.repo.search.impl.lucene.LuceneXPathHandler;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.repo.search.impl.lucene.query.CaseInsensitiveFieldQuery;
import org.alfresco.repo.search.impl.lucene.query.CaseInsensitiveFieldRangeQuery;
import org.alfresco.repo.search.impl.lucene.query.PathQuery;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardTermEnum;
import org.apache.lucene.search.regex.RegexQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneQueryParser
extends QueryParser {
    public static final String FIELD_NO_LOCALE_SUFFIX = ".no_locale";
    public static final String FIELD_SORT_SUFFIX = ".sort";
    public static final String FIELD_LOCALE_SUFFIX = ".locale";
    public static final String FIELD_SIZE_SUFFIX = ".size";
    public static final String FIELD_MIMETYPE_SUFFIX = ".mimetype";
    public static final String FIELD_FTSSTATUS = "FTSSTATUS";
    public static final String FIELD_ISNOTNULL = "ISNOTNULL";
    public static final String FIELD_ISNULL = "ISNULL";
    public static final String FIELD_ISUNSET = "ISUNSET";
    public static final String FIELD_ALL = "ALL";
    public static final String PROPERTY_FIELD_PREFIX = "@";
    public static final String FIELD_EXACTASPECT = "EXACTASPECT";
    public static final String FIELD_EXACTTYPE = "EXACTTYPE";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_ASPECT = "ASPECT";
    public static final String FIELD_CLASS = "CLASS";
    public static final String FIELD_ASSOCTYPEQNAME = "ASSOCTYPEQNAME";
    public static final String FIELD_PRIMARYASSOCTYPEQNAME = "PRIMARYASSOCTYPEQNAME";
    public static final String FIELD_QNAME = "QNAME";
    public static final String FIELD_PRIMARYPARENT = "PRIMARYPARENT";
    public static final String FIELD_PARENT = "PARENT";
    public static final String FIELD_TX = "TX";
    public static final String FIELD_ISNODE = "ISNODE";
    public static final String FIELD_ISCONTAINER = "ISCONTAINER";
    public static final String FIELD_ISROOT = "ISROOT";
    public static final String FIELD_DBID = "DBID";
    public static final String FIELD_ID = "ID";
    public static final String FIELD_TEXT = "TEXT";
    public static final String FIELD_PATH_WITH_REPEATS = "PATH_WITH_REPEATS";
    public static final String FIELD_PATH = "PATH";
    private static Log s_logger = LogFactory.getLog(LuceneQueryParser.class);
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected DictionaryService dictionaryService;
    private TenantService tenantService;
    private SearchParameters searchParameters;
    private MLAnalysisMode defaultSearchMLAnalysisMode;
    private IndexReader indexReader;
    private int internalSlop = 0;
    private LuceneAnalyser luceneAnalyser;

    public static Query parse(String query, String field, Analyzer analyzer, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, TenantService tenantService, QueryParser.Operator defaultOperator, SearchParameters searchParameters, MLAnalysisMode defaultSearchMLAnalysisMode, IndexReader indexReader) throws ParseException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Using Alfresco Lucene Query Parser for query: " + query));
        }
        LuceneQueryParser parser = new LuceneQueryParser(field, analyzer);
        parser.setDefaultOperator(defaultOperator);
        parser.setNamespacePrefixResolver(namespacePrefixResolver);
        parser.setDictionaryService(dictionaryService);
        parser.setTenantService(tenantService);
        parser.setSearchParameters(searchParameters);
        parser.setDefaultSearchMLAnalysisMode(defaultSearchMLAnalysisMode);
        parser.setIndexReader(indexReader);
        parser.setAllowLeadingWildcard(true);
        Query result = parser.parse(query);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Query " + query + "                             is\n\t" + result.toString()));
        }
        return result;
    }

    public void setDefaultSearchMLAnalysisMode(MLAnalysisMode defaultSearchMLAnalysisMode) {
        this.defaultSearchMLAnalysisMode = defaultSearchMLAnalysisMode;
    }

    public void setIndexReader(IndexReader indexReader) {
        this.indexReader = indexReader;
    }

    public void setSearchParameters(SearchParameters searchParameters) {
        this.searchParameters = searchParameters;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParameters;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public MLAnalysisMode getDefaultSearchMLAnalysisMode() {
        return this.defaultSearchMLAnalysisMode;
    }

    public LuceneQueryParser(String arg0, Analyzer arg1) {
        super(arg0, arg1);
        if (arg1 instanceof LuceneAnalyser) {
            this.luceneAnalyser = (LuceneAnalyser)arg1;
        }
    }

    public LuceneQueryParser(CharStream arg0) {
        super(arg0);
    }

    public LuceneQueryParser(QueryParserTokenManager arg0) {
        super(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        try {
            Query query;
            this.internalSlop = slop;
            Query query2 = query = this.getFieldQuery(field, queryText);
            return query2;
        }
        finally {
            this.internalSlop = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getFieldQuery(String field, String queryText, AnalysisMode analysisMode, int slop, LuceneFunction luceneFunction) throws ParseException {
        try {
            Query query;
            this.internalSlop = slop;
            Query query2 = query = this.getFieldQuery(field, queryText, analysisMode, luceneFunction);
            return query2;
        }
        finally {
            this.internalSlop = 0;
        }
    }

    public Query getLikeQuery(String field, String sqlLikeClause, AnalysisMode analysisMode) throws ParseException {
        String luceneWildCardExpression = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_SQL_LIKE, SearchLanguageConversion.DEF_LUCENE, sqlLikeClause);
        return this.getWildcardQuery(field, luceneWildCardExpression, AnalysisMode.LIKE);
    }

    public Query getDoesNotMatchFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        MatchAllDocsQuery allQuery = new MatchAllDocsQuery();
        Query matchQuery = this.getFieldQuery(field, queryText, analysisMode, luceneFunction);
        if (matchQuery == null) {
            throw new UnsupportedOperationException();
        }
        query.add((Query)allQuery, BooleanClause.Occur.MUST);
        query.add(matchQuery, BooleanClause.Occur.MUST_NOT);
        return query;
    }

    public Query getFieldQuery(String field, String queryText) throws ParseException {
        return this.getFieldQuery(field, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    public Query getSpanQuery(String field, String first, String last, int slop, boolean inOrder) {
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getSpanQuery(PROPERTY_FIELD_PREFIX + qname.toString(), first, last, slop, inOrder);
                    query.add(part, BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getSpanQuery(fieldName, first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            SpanTermQuery firstTerm = new SpanTermQuery(new Term(field, first));
            SpanTermQuery lastTerm = new SpanTermQuery(new Term(field, last));
            return new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
        }
        if (field.equals(FIELD_ALL)) {
            Set<String> all = this.searchParameters.getAllAttributes();
            if (all == null || all.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getSpanQuery(PROPERTY_FIELD_PREFIX + qname.toString(), first, last, slop, inOrder);
                    query.add(part, BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : all) {
                Query part = this.getSpanQuery(fieldName, first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (this.matchDataTypeDefinition(field) != null) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getSpanQuery(PROPERTY_FIELD_PREFIX + qname.toString(), first, last, slop, inOrder);
                query.add(part, BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        SpanTermQuery firstTerm = new SpanTermQuery(new Term(field, first));
        SpanTermQuery lastTerm = new SpanTermQuery(new Term(field, last));
        return new SpanNearQuery(new SpanQuery[]{firstTerm, lastTerm}, slop, inOrder);
    }

    private DataTypeDefinition matchDataTypeDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        DataTypeDefinition dataTypeDefinition = this.dictionaryService.getDataType(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (dataTypeDefinition == null) {
            for (QName definition : this.dictionaryService.getAllDataTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return dataTypeDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getDataType(match);
    }

    private PropertyDefinition matchPropertyDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (propertyDefinition == null) {
            for (QName definition : this.dictionaryService.getAllProperties(null)) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return propertyDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getProperty(match);
    }

    private AspectDefinition matchAspectDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        AspectDefinition aspectDefinition = this.dictionaryService.getAspect(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (aspectDefinition == null) {
            for (QName definition : this.dictionaryService.getAllAspects()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return aspectDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getAspect(match);
    }

    private TypeDefinition matchTypeDefinition(String string) {
        QName search = QName.createQName(this.expandQName(string));
        TypeDefinition typeDefinition = this.dictionaryService.getType(QName.createQName(this.expandQName(string)));
        QName match = null;
        if (typeDefinition == null) {
            for (QName definition : this.dictionaryService.getAllTypes()) {
                if (!definition.getNamespaceURI().equalsIgnoreCase(search.getNamespaceURI()) || !definition.getLocalName().equalsIgnoreCase(search.getLocalName())) continue;
                if (match == null) {
                    match = definition;
                    continue;
                }
                throw new LuceneQueryParserException("Ambiguous data datype " + string);
            }
        } else {
            return typeDefinition;
        }
        if (match == null) {
            return null;
        }
        return this.dictionaryService.getType(match);
    }

    private ClassDefinition matchClassDefinition(String string) {
        TypeDefinition match = this.matchTypeDefinition(string);
        if (match != null) {
            return match;
        }
        return this.matchAspectDefinition(string);
    }

    public Query getFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        try {
            if (field.equals(FIELD_PATH)) {
                return this.createPathQuery(queryText, false);
            }
            if (field.equals(FIELD_PATH_WITH_REPEATS)) {
                return this.createPathQuery(queryText, true);
            }
            if (field.equals(FIELD_TEXT)) {
                return this.createTextQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ID)) {
                return this.createIdQuery(queryText);
            }
            if (field.equals(FIELD_DBID)) {
                return this.createDbidQuery(queryText);
            }
            if (field.equals(FIELD_ISROOT)) {
                return this.createIsRootQuery(queryText);
            }
            if (field.equals(FIELD_ISCONTAINER)) {
                return this.createIsContainerQuery(queryText);
            }
            if (field.equals(FIELD_ISNODE)) {
                return this.createIsNodeQuery(queryText);
            }
            if (field.equals(FIELD_TX)) {
                return this.createTransactionQuery(queryText);
            }
            if (field.equals(FIELD_PARENT)) {
                return this.createParentQuery(queryText);
            }
            if (field.equals(FIELD_PRIMARYPARENT)) {
                return this.createPrimaryParentQuery(queryText);
            }
            if (field.equals(FIELD_QNAME)) {
                return this.createQNameQuery(queryText);
            }
            if (field.equals(FIELD_PRIMARYASSOCTYPEQNAME)) {
                return this.createPrimaryAssocTypeQNameQuery(queryText);
            }
            if (field.equals(FIELD_ASSOCTYPEQNAME)) {
                return this.createAssocTypeQNameQuery(queryText);
            }
            if (field.equals(FIELD_CLASS)) {
                ClassDefinition target = this.matchClassDefinition(queryText);
                if (target == null) {
                    throw new LuceneQueryParserException("Invalid type: " + queryText);
                }
                return this.getFieldQuery(target.isAspect() ? FIELD_ASPECT : FIELD_TYPE, queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_TYPE)) {
                return this.createTypeQuery(queryText, false);
            }
            if (field.equals(FIELD_EXACTTYPE)) {
                return this.createTypeQuery(queryText, true);
            }
            if (field.equals(FIELD_ASPECT)) {
                return this.createAspectQuery(queryText, false);
            }
            if (field.equals(FIELD_EXACTASPECT)) {
                return this.createAspectQuery(queryText, true);
            }
            if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
                Query query = this.attributeQueryBuilder(field, queryText, new FieldQuery(), analysisMode, luceneFunction);
                return query;
            }
            if (field.equals(FIELD_ALL)) {
                return this.createAllQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ISUNSET)) {
                return this.createIsUnsetQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ISNULL)) {
                return this.createIsNullQuery(queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_ISNOTNULL)) {
                return this.createIsNotNull(queryText, analysisMode, luceneFunction);
            }
            if (this.matchDataTypeDefinition(field) != null) {
                return this.createDataTypeDefinitionQuery(field, queryText, analysisMode, luceneFunction);
            }
            if (field.equals(FIELD_FTSSTATUS)) {
                return this.createTermQuery(field, queryText);
            }
            return this.getFieldQueryImpl(field, queryText, analysisMode, luceneFunction);
        }
        catch (SAXPathException e) {
            throw new ParseException("Failed to parse XPath...\n" + e.getMessage());
        }
    }

    private Query createDbidQuery(String queryText) throws ParseException {
        return this.getFieldQueryImpl(FIELD_DBID, queryText, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    protected Query createDataTypeDefinitionQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(this.matchDataTypeDefinition(field).getName());
        BooleanQuery query = new BooleanQuery();
        for (QName qname : contentAttributes) {
            Query part = this.getFieldQuery(PROPERTY_FIELD_PREFIX + qname.toString(), queryText, analysisMode, luceneFunction);
            if (part != null) {
                query.add(part, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    protected Query createIsNotNull(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = this.matchPropertyDefinition(queryText);
        if (pd != null) {
            ClassDefinition containerClass = pd.getContainerClass();
            QName container = containerClass.getName();
            BooleanQuery query = new BooleanQuery();
            String classType = containerClass.isAspect() ? FIELD_ASPECT : FIELD_TYPE;
            Query typeQuery = this.getFieldQuery(classType, container.toString(), analysisMode, luceneFunction);
            Query presenceQuery = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + pd.getName().toString(), "*");
            if (typeQuery != null && presenceQuery != null) {
                query.add(presenceQuery, BooleanClause.Occur.MUST);
            }
            return query;
        }
        return this.getFieldQueryImpl(FIELD_ISNOTNULL, queryText, analysisMode, luceneFunction);
    }

    protected Query createIsNullQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = this.matchPropertyDefinition(queryText);
        if (pd != null) {
            BooleanQuery query = new BooleanQuery();
            Query presenceQuery = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + pd.getName().toString(), "*");
            if (presenceQuery != null) {
                query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
            }
            return query;
        }
        return this.getFieldQueryImpl(FIELD_ISNULL, queryText, analysisMode, luceneFunction);
    }

    protected Query createIsUnsetQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        PropertyDefinition pd = this.matchPropertyDefinition(queryText);
        if (pd != null) {
            ClassDefinition containerClass = pd.getContainerClass();
            QName container = containerClass.getName();
            BooleanQuery query = new BooleanQuery();
            String classType = containerClass.isAspect() ? FIELD_ASPECT : FIELD_TYPE;
            Query typeQuery = this.getFieldQuery(classType, container.toString(), analysisMode, luceneFunction);
            Query presenceQuery = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + pd.getName().toString(), "*");
            if (typeQuery != null && presenceQuery != null) {
                query.add(typeQuery, BooleanClause.Occur.MUST);
                query.add(presenceQuery, BooleanClause.Occur.MUST_NOT);
            }
            return query;
        }
        return this.getFieldQueryImpl(FIELD_ISUNSET, queryText, analysisMode, luceneFunction);
    }

    protected Query createAllQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Set<String> all = this.searchParameters.getAllAttributes();
        if (all == null || all.size() == 0) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(null);
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getFieldQuery(PROPERTY_FIELD_PREFIX + qname.toString(), queryText, analysisMode, luceneFunction);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        BooleanQuery query = new BooleanQuery();
        for (String fieldName : all) {
            Query part = this.getFieldQuery(fieldName, queryText, analysisMode, luceneFunction);
            if (part != null) {
                query.add(part, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    protected Query createAspectQuery(String queryText, boolean exactOnly) {
        AspectDefinition target = this.matchAspectDefinition(queryText);
        if (target == null) {
            throw new AlfrescoRuntimeException("Unknown aspect specified in query: " + queryText);
        }
        if (exactOnly) {
            QName targetQName = target.getName();
            TermQuery termQuery = new TermQuery(new Term(FIELD_ASPECT, targetQName.toString()));
            return termQuery;
        }
        Collection<QName> subclasses = this.dictionaryService.getSubAspects(target.getName(), true);
        BooleanQuery booleanQuery = new BooleanQuery();
        for (QName qname : subclasses) {
            TermQuery termQuery;
            AspectDefinition current = this.dictionaryService.getAspect(qname);
            if (!target.getName().equals(current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (termQuery = new TermQuery(new Term(FIELD_ASPECT, qname.toString()))) == null) continue;
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    protected Query createTypeQuery(String queryText, boolean exactOnly) {
        TypeDefinition target = this.matchTypeDefinition(queryText);
        if (target == null) {
            throw new LuceneQueryParserException("Invalid type: " + queryText);
        }
        if (exactOnly) {
            QName targetQName = target.getName();
            TermQuery termQuery = new TermQuery(new Term(FIELD_TYPE, targetQName.toString()));
            return termQuery;
        }
        Collection<QName> subclasses = this.dictionaryService.getSubTypes(target.getName(), true);
        BooleanQuery booleanQuery = new BooleanQuery();
        for (QName qname : subclasses) {
            TermQuery termQuery;
            TypeDefinition current = this.dictionaryService.getType(qname);
            if (!target.getName().equals(current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (termQuery = new TermQuery(new Term(FIELD_TYPE, qname.toString()))) == null) continue;
            booleanQuery.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    protected Query createAssocTypeQNameQuery(String queryText) throws SAXPathException {
        BooleanQuery booleanQuery = new BooleanQuery();
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        PathQuery query = handler.getQuery();
        query.setPathField(FIELD_PATH);
        query.setQnameField(FIELD_ASSOCTYPEQNAME);
        booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
        booleanQuery.add(this.createPrimaryAssocTypeQNameQuery(queryText), BooleanClause.Occur.SHOULD);
        return booleanQuery;
    }

    protected Query createPrimaryAssocTypeQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        PathQuery query = handler.getQuery();
        query.setPathField(FIELD_PATH);
        query.setQnameField(FIELD_PRIMARYASSOCTYPEQNAME);
        return query;
    }

    protected Query createQNameQuery(String queryText) throws SAXPathException {
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse("//" + queryText);
        return handler.getQuery();
    }

    protected Query createTransactionQuery(String queryText) {
        return this.createTermQuery(FIELD_TX, queryText);
    }

    protected Query createIsNodeQuery(String queryText) {
        return this.createTermQuery(FIELD_ISNODE, queryText);
    }

    protected Query createIsContainerQuery(String queryText) {
        return this.createTermQuery(FIELD_ISCONTAINER, queryText);
    }

    protected Query createIsRootQuery(String queryText) {
        return this.createTermQuery(FIELD_ISROOT, queryText);
    }

    private Query createTermQuery(String field, String queryText) {
        TermQuery termQuery = new TermQuery(new Term(field, queryText));
        return termQuery;
    }

    protected Query createPrimaryParentQuery(String queryText) {
        return this.createNodeRefQuery(FIELD_PRIMARYPARENT, queryText);
    }

    protected Query createParentQuery(String queryText) {
        return this.createNodeRefQuery(FIELD_PARENT, queryText);
    }

    protected Query createIdQuery(String queryText) {
        return this.createNodeRefQuery(FIELD_ID, queryText);
    }

    private Query createNodeRefQuery(String field, String queryText) {
        if (this.tenantService.isTenantUser() && queryText.contains("://")) {
            queryText = this.tenantService.getName(new NodeRef(queryText)).toString();
        }
        return this.createTermQuery(field, queryText);
    }

    protected Query createPathQuery(String queryText, boolean withRepeats) throws SAXPathException {
        XPathReader reader = new XPathReader();
        LuceneXPathHandler handler = new LuceneXPathHandler();
        handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
        handler.setDictionaryService(this.dictionaryService);
        reader.setXPathHandler((XPathHandler)handler);
        reader.parse(queryText);
        PathQuery pathQuery = handler.getQuery();
        pathQuery.setRepeats(withRepeats);
        return pathQuery;
    }

    protected Query createTextQuery(String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        Set<String> text = this.searchParameters.getTextAttributes();
        if (text == null || text.size() == 0) {
            Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT);
            BooleanQuery query = new BooleanQuery();
            for (QName qname : contentAttributes) {
                Query part = this.getFieldQuery(PROPERTY_FIELD_PREFIX + qname.toString(), queryText, analysisMode, luceneFunction);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        BooleanQuery query = new BooleanQuery();
        for (String fieldName : text) {
            Query part = this.getFieldQuery(fieldName, queryText, analysisMode, luceneFunction);
            if (part != null) {
                query.add(part, BooleanClause.Occur.SHOULD);
                continue;
            }
            query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    private Query getFieldQueryImpl(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        int current;
        Token nextToken;
        if (luceneFunction != LuceneFunction.FIELD) {
            throw new UnsupportedOperationException("Field queries are not supported on lucene functions (UPPER, LOWER, etc)");
        }
        boolean requiresMLTokenDuplication = false;
        String testText = queryText;
        String localeString = null;
        if (field.startsWith(PROPERTY_FIELD_PREFIX) && queryText.length() > 0 && queryText.charAt(0) == '\u0000') {
            int position = queryText.indexOf("\u0000", 1);
            testText = queryText.substring(position + 1);
            requiresMLTokenDuplication = true;
            localeString = queryText.substring(1, position);
        }
        TokenStream source = this.getAnalyzer().tokenStream(field, new StringReader(queryText), analysisMode);
        ArrayList<Token> list = new ArrayList<Token>();
        Token reusableToken = new Token();
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        while (true) {
            try {
                nextToken = source.next(reusableToken);
            }
            catch (IOException e) {
                nextToken = null;
            }
            if (nextToken == null) break;
            list.add((Token)nextToken.clone());
            if (nextToken.getPositionIncrement() != 0) {
                positionCount += nextToken.getPositionIncrement();
                continue;
            }
            severalTokensAtSamePosition = true;
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        for (int index = 0; index < testText.length(); ++index) {
            current = testText.charAt(index);
            if (current != 42 && current != 63) continue;
            StringBuilder pre = new StringBuilder(10);
            if (index > 0) {
                for (int i = index - 1; i >= 0; --i) {
                    char c = testText.charAt(i);
                    if (!Character.isLetterOrDigit(c)) continue;
                    boolean found = false;
                    for (int j = 0; j < list.size(); ++j) {
                        Token test = (Token)list.get(j);
                        if (test.startOffset() > i || i > test.endOffset()) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                    pre.insert(0, c);
                }
                if (pre.length() > 0) {
                    Token newToken = new Token(index - pre.length(), index);
                    newToken.setTermBuffer(pre.toString());
                    newToken.setType("ALPHANUM");
                    if (requiresMLTokenDuplication) {
                        MLAnalysisMode mlAnalysisMode;
                        Locale locale = I18NUtil.parseLocale((String)localeString);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode());
                        Iterator<Token> it = duplicator.buildIterator(newToken);
                        if (it != null) {
                            int count = 0;
                            while (it.hasNext()) {
                                list.add(it.next());
                                if (++count <= 1) continue;
                                severalTokensAtSamePosition = true;
                            }
                        }
                    } else {
                        list.add(newToken);
                    }
                }
            }
            StringBuilder post = new StringBuilder(10);
            if (index <= 0) continue;
            for (int i = index + 1; i < testText.length(); ++i) {
                char c = testText.charAt(i);
                if (!Character.isLetterOrDigit(c)) continue;
                boolean found = false;
                for (int j = 0; j < list.size(); ++j) {
                    Token test = (Token)list.get(j);
                    if (test.startOffset() > i || i > test.endOffset()) continue;
                    found = true;
                    break;
                }
                if (found) break;
                post.append(c);
            }
            if (post.length() <= 0) continue;
            Token newToken = new Token(index + 1, index + 1 + post.length());
            newToken.setTermBuffer(post.toString());
            newToken.setType("ALPHANUM");
            if (requiresMLTokenDuplication) {
                MLAnalysisMode mlAnalysisMode;
                Locale locale = I18NUtil.parseLocale((String)localeString);
                MLTokenDuplicator duplicator = new MLTokenDuplicator(locale, mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode());
                Iterator<Token> it = duplicator.buildIterator(newToken);
                if (it == null) continue;
                int count = 0;
                while (it.hasNext()) {
                    list.add(it.next());
                    if (++count <= 1) continue;
                    severalTokensAtSamePosition = true;
                }
                continue;
            }
            list.add(newToken);
        }
        Collections.sort(list, new Comparator<Token>(){

            @Override
            public int compare(Token o1, Token o2) {
                int dif = o1.startOffset() - o2.startOffset();
                if (dif != 0) {
                    return dif;
                }
                return o2.getPositionIncrement() - o1.getPositionIncrement();
            }
        });
        int max = 0;
        current = 0;
        for (Token c : list) {
            if (c.getPositionIncrement() == 0) {
                ++current;
                continue;
            }
            if (current > max) {
                max = current;
            }
            current = 0;
        }
        if (current > max) {
            max = current;
        }
        ArrayList<Token> fixed = new ArrayList<Token>();
        for (int repeat = 0; repeat <= max; ++repeat) {
            Token replace = null;
            current = 0;
            for (Token c : list) {
                String token;
                String language;
                String termText;
                StringBuilder prefix;
                current = c.getPositionIncrement() == 0 ? ++current : 0;
                if (current != repeat) continue;
                if (replace == null) {
                    String termText2;
                    char test;
                    prefix = new StringBuilder();
                    for (int i = c.startOffset() - 1; i >= 0 && ((test = testText.charAt(i)) == '*' || test == '?'); --i) {
                        prefix.insert(0, test);
                    }
                    String pre = prefix.toString();
                    if (requiresMLTokenDuplication) {
                        termText2 = new String(c.termBuffer(), 0, c.termLength());
                        int position = termText2.indexOf("}");
                        String language2 = termText2.substring(0, position + 1);
                        String token2 = termText2.substring(position + 1);
                        replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                        replace.setTermBuffer(language2 + pre + token2);
                        replace.setType(c.type());
                        replace.setPositionIncrement(c.getPositionIncrement());
                        continue;
                    }
                    termText2 = new String(c.termBuffer(), 0, c.termLength());
                    replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                    replace.setTermBuffer(pre + termText2);
                    replace.setType(c.type());
                    replace.setPositionIncrement(c.getPositionIncrement());
                    continue;
                }
                prefix = new StringBuilder();
                StringBuilder postfix = new StringBuilder();
                StringBuilder builder = prefix;
                for (int i = c.startOffset() - 1; i >= replace.endOffset(); --i) {
                    char test = testText.charAt(i);
                    if (test == '*' || test == '?') {
                        builder.insert(0, test);
                        continue;
                    }
                    builder = postfix;
                    postfix.setLength(0);
                }
                String pre = prefix.toString();
                String post = postfix.toString();
                if (pre.length() > 0 && replace.endOffset() + pre.length() == c.startOffset()) {
                    termText = new String(c.termBuffer(), 0, c.termLength());
                    if (requiresMLTokenDuplication) {
                        int position = termText.indexOf("}");
                        language = termText.substring(0, position + 1);
                        token = termText.substring(position + 1);
                        int oldPositionIncrement = replace.getPositionIncrement();
                        String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                        replace = new Token(replace.startOffset(), c.endOffset());
                        replace.setTermBuffer(replaceTermText + pre + token);
                        replace.setType(replace.type());
                        replace.setPositionIncrement(oldPositionIncrement);
                        continue;
                    }
                    int oldPositionIncrement = replace.getPositionIncrement();
                    String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                    replace = new Token(replace.startOffset(), c.endOffset());
                    replace.setTermBuffer(replaceTermText + pre + termText);
                    replace.setType(replace.type());
                    replace.setPositionIncrement(oldPositionIncrement);
                    continue;
                }
                termText = new String(c.termBuffer(), 0, c.termLength());
                if (requiresMLTokenDuplication) {
                    int position = termText.indexOf("}");
                    language = termText.substring(0, position + 1);
                    token = termText.substring(position + 1);
                    String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                    Token last = new Token(replace.startOffset(), replace.endOffset() + post.length());
                    last.setTermBuffer(replaceTermText + post);
                    last.setType(replace.type());
                    last.setPositionIncrement(replace.getPositionIncrement());
                    fixed.add(last);
                    replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                    replace.setTermBuffer(language + pre + token);
                    replace.setType(c.type());
                    replace.setPositionIncrement(c.getPositionIncrement());
                    continue;
                }
                String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
                Token last = new Token(replace.startOffset(), replace.endOffset() + post.length());
                last.setTermBuffer(replaceTermText + post);
                last.setType(replace.type());
                last.setPositionIncrement(replace.getPositionIncrement());
                fixed.add(last);
                replace = new Token(c.startOffset() - pre.length(), c.endOffset());
                replace.setTermBuffer(pre + termText);
                replace.setType(c.type());
                replace.setPositionIncrement(c.getPositionIncrement());
            }
            if (replace == null) continue;
            StringBuilder postfix = new StringBuilder();
            if (replace.endOffset() >= 0 && replace.endOffset() < testText.length()) {
                char test;
                for (int i = replace.endOffset(); i < testText.length() && ((test = testText.charAt(i)) == '*' || test == '?'); ++i) {
                    postfix.append(test);
                }
            }
            String post = postfix.toString();
            int oldPositionIncrement = replace.getPositionIncrement();
            String replaceTermText = new String(replace.termBuffer(), 0, replace.termLength());
            replace = new Token(replace.startOffset(), replace.endOffset() + post.length());
            replace.setTermBuffer(replaceTermText + post);
            replace.setType(replace.type());
            replace.setPositionIncrement(oldPositionIncrement);
            fixed.add(replace);
        }
        Collections.sort(fixed, new Comparator<Token>(){

            @Override
            public int compare(Token o1, Token o2) {
                int dif = o1.startOffset() - o2.startOffset();
                if (dif != 0) {
                    return dif;
                }
                return o2.getPositionIncrement() - o1.getPositionIncrement();
            }
        });
        list = fixed;
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            nextToken = (Token)list.get(0);
            String termText = new String(nextToken.termBuffer(), 0, nextToken.termLength());
            if (termText.contains("*") || termText.contains("?")) {
                return this.newWildcardQuery(new Term(field, termText));
            }
            return this.newTermQuery(new Term(field, termText));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                BooleanQuery q = this.newBooleanQuery(true);
                for (int i = 0; i < list.size(); ++i) {
                    nextToken = (Token)list.get(i);
                    String termText = new String(nextToken.termBuffer(), 0, nextToken.termLength());
                    Query currentQuery = termText.contains("*") || termText.contains("?") ? this.newWildcardQuery(new Term(field, termText)) : this.newTermQuery(new Term(field, termText));
                    q.add(currentQuery, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            MultiPhraseQuery mpq = this.newMultiPhraseQuery();
            mpq.setSlop(this.internalSlop);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < list.size(); ++i) {
                nextToken = (Token)list.get(i);
                String termText = new String(nextToken.termBuffer(), 0, nextToken.termLength());
                if (nextToken.getPositionIncrement() > 0 && multiTerms.size() > 0) {
                    if (this.getEnablePositionIncrements()) {
                        mpq.add(multiTerms.toArray(new Term[0]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[0]));
                    }
                    multiTerms.clear();
                }
                position += nextToken.getPositionIncrement();
                Term term = new Term(field, termText);
                if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                    this.addWildcardTerms(multiTerms, term);
                    continue;
                }
                multiTerms.add(term);
            }
            if (this.getEnablePositionIncrements()) {
                if (multiTerms.size() > 0) {
                    mpq.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpq.add(new Term[]{new Term(field, "\u0000")}, position);
                }
            } else if (multiTerms.size() > 0) {
                mpq.add(multiTerms.toArray(new Term[0]));
            } else {
                mpq.add(new Term[]{new Term(field, "\u0000")});
            }
            return mpq;
        }
        MultiPhraseQuery q = new MultiPhraseQuery();
        q.setSlop(this.internalSlop);
        int position = -1;
        for (int i = 0; i < list.size(); ++i) {
            nextToken = (Token)list.get(i);
            String termText = new String(nextToken.termBuffer(), 0, nextToken.termLength());
            Term term = new Term(field, termText);
            if (this.getEnablePositionIncrements()) {
                position += nextToken.getPositionIncrement();
                if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                    q.add(this.getMatchingTerms(field, term), position);
                    continue;
                }
                q.add(new Term[]{term}, position);
                continue;
            }
            if (termText != null && (termText.contains("*") || termText.contains("?"))) {
                q.add(this.getMatchingTerms(field, term));
                continue;
            }
            q.add(term);
        }
        return q;
    }

    private Term[] getMatchingTerms(String field, Term term) throws ParseException {
        ArrayList<Term> terms = new ArrayList<Term>();
        this.addWildcardTerms(terms, term);
        if (terms.size() == 0) {
            return new Term[]{new Term(field, "\u0000")};
        }
        return terms.toArray(new Term[0]);
    }

    private void addWildcardTerms(ArrayList<Term> terms, Term term) throws ParseException {
        try {
            WildcardTermEnum wcte = new WildcardTermEnum(this.indexReader, term);
            while (!wcte.endEnum()) {
                Term current = wcte.term();
                if (current.text() != null && current.text().length() > 0 && current.text().charAt(0) == '{') {
                    if (term != null && term.text().length() > 0 && term.text().charAt(0) == '{') {
                        terms.add(current);
                    }
                } else {
                    terms.add(current);
                }
                wcte.next();
            }
        }
        catch (IOException e) {
            throw new ParseException("IO error generating phares wildcards " + e.getMessage());
        }
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        return this.getRangeQuery(field, part1, part2, inclusive, inclusive, AnalysisMode.DEFAULT, LuceneFunction.FIELD);
    }

    public Query getRangeQuery(String field, String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getRangeQuery(PROPERTY_FIELD_PREFIX + qname.toString(), part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getRangeQuery(fieldName, part1, part2, includeLower, includeUpper, analysisMode, luceneFunction);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            PropertyDefinition propertyDef = this.matchPropertyDefinition(field.substring(1));
            String fieldName = propertyDef != null ? PROPERTY_FIELD_PREFIX + propertyDef.getName() : this.expandAttributeFieldName(field);
            IndexTokenisationMode tokenisationMode = IndexTokenisationMode.TRUE;
            if (propertyDef != null && (tokenisationMode = propertyDef.getIndexTokenisationMode()) == null) {
                tokenisationMode = IndexTokenisationMode.TRUE;
            }
            if (propertyDef != null) {
                if (luceneFunction != LuceneFunction.FIELD) {
                    if (propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
                        BooleanQuery booleanQuery = new BooleanQuery();
                        MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
                        List<Locale> locales = this.searchParameters.getLocales();
                        ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
                        for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                            expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
                        }
                        for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                            if (locale.toString().length() == 0) continue;
                            String textFieldName = fieldName;
                            if (tokenisationMode == IndexTokenisationMode.BOTH) {
                                textFieldName = textFieldName + "." + locale + FIELD_SORT_SUFFIX;
                            }
                            this.addLocaleSpecificUntokenisedTextRangeFunction(field, part1, part2, includeLower, includeUpper, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
                        }
                        return booleanQuery;
                    }
                    throw new UnsupportedOperationException("Lucene Function");
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
                    throw new UnsupportedOperationException("Range is not supported against ml-text");
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                    throw new UnsupportedOperationException("Range is not supported against content");
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
                    BooleanQuery booleanQuery = new BooleanQuery();
                    MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
                    List<Locale> locales = this.searchParameters.getLocales();
                    ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
                    for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                        expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
                    }
                    for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                        IndexTokenisationMode tm;
                        String textFieldName = fieldName;
                        if ((analysisMode == AnalysisMode.IDENTIFIER || analysisMode == AnalysisMode.LIKE) && (tm = propertyDef.getIndexTokenisationMode()) != null && tm == IndexTokenisationMode.BOTH) {
                            textFieldName = locale.toString().length() == 0 ? textFieldName + FIELD_NO_LOCALE_SUFFIX : textFieldName + "." + locale + FIELD_SORT_SUFFIX;
                        }
                        block4 : switch (tokenisationMode) {
                            case BOTH: {
                                switch (analysisMode) {
                                    case DEFAULT: 
                                    case TOKENISE: {
                                        this.addLocaleSpecificTokenisedTextRange(part1, part2, includeLower, includeUpper, analysisMode, fieldName, booleanQuery, locale, textFieldName);
                                        break block4;
                                    }
                                    case IDENTIFIER: {
                                        this.addLocaleSpecificUntokenisedTextRange(field, part1, part2, includeLower, includeUpper, booleanQuery, mlAnalysisMode, locale, textFieldName);
                                        break block4;
                                    }
                                }
                                throw new UnsupportedOperationException();
                            }
                            case FALSE: {
                                this.addLocaleSpecificUntokenisedTextRange(field, part1, part2, includeLower, includeUpper, booleanQuery, mlAnalysisMode, locale, textFieldName);
                                break;
                            }
                            case TRUE: {
                                this.addLocaleSpecificTokenisedTextRange(part1, part2, includeLower, includeUpper, analysisMode, fieldName, booleanQuery, locale, textFieldName);
                                break;
                            }
                        }
                    }
                    return booleanQuery;
                }
                if (propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                    DataTypeDefinition dataType = propertyDef.getDataType();
                    String analyserClassName = dataType.getAnalyserClassName();
                    boolean usesDateTimeAnalyser = analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName());
                    if (usesDateTimeAnalyser) {
                        Calendar end;
                        Calendar start;
                        block47: {
                            Date date;
                            SimpleDateFormat oldDf;
                            Date date2;
                            block46: {
                                start = Calendar.getInstance();
                                end = Calendar.getInstance();
                                try {
                                    date2 = CachingDateFormat.lenientParse((String)part1);
                                    start.setTime(date2);
                                }
                                catch (java.text.ParseException e) {
                                    oldDf = CachingDateFormat.getDateFormat();
                                    try {
                                        date = oldDf.parse(part1);
                                        start.setTime(date);
                                        start.set(14, 0);
                                    }
                                    catch (java.text.ParseException ee) {
                                        if (part1.equalsIgnoreCase("min")) {
                                            start.set(1, start.getMinimum(1));
                                            start.set(6, start.getMinimum(6));
                                            start.set(11, start.getMinimum(11));
                                            start.set(12, start.getMinimum(12));
                                            start.set(13, start.getMinimum(13));
                                            start.set(14, start.getMinimum(14));
                                            break block46;
                                        }
                                        if (part1.equalsIgnoreCase("now")) {
                                            start.setTime(new Date());
                                            break block46;
                                        }
                                        if (part1.equalsIgnoreCase("today")) {
                                            start.setTime(new Date());
                                            start.set(11, start.getMinimum(11));
                                            start.set(12, start.getMinimum(12));
                                            start.set(13, start.getMinimum(13));
                                            start.set(14, start.getMinimum(14));
                                            break block46;
                                        }
                                        return this.createNoMatchQuery();
                                    }
                                }
                            }
                            try {
                                date2 = CachingDateFormat.lenientParse((String)part2);
                                end.setTime(date2);
                            }
                            catch (java.text.ParseException e) {
                                oldDf = CachingDateFormat.getDateFormat();
                                try {
                                    date = oldDf.parse(part2);
                                    end.setTime(date);
                                    end.set(14, 0);
                                }
                                catch (java.text.ParseException ee) {
                                    if (part2.equalsIgnoreCase("max")) {
                                        end.set(1, end.getMaximum(1));
                                        end.set(6, end.getMaximum(6));
                                        end.set(11, end.getMaximum(11));
                                        end.set(12, end.getMaximum(12));
                                        end.set(13, end.getMaximum(13));
                                        end.set(14, end.getMaximum(14));
                                        break block47;
                                    }
                                    if (part2.equalsIgnoreCase("now")) {
                                        end.setTime(new Date());
                                        break block47;
                                    }
                                    if (part1.equalsIgnoreCase("today")) {
                                        end.setTime(new Date());
                                        end.set(11, end.getMinimum(11));
                                        end.set(12, end.getMinimum(12));
                                        end.set(13, end.getMinimum(13));
                                        end.set(14, end.getMinimum(14));
                                        break block47;
                                    }
                                    return this.createNoMatchQuery();
                                }
                            }
                        }
                        Query rq = this.buildDateTimeRange(fieldName, start, end, includeLower, includeUpper);
                        return rq;
                    }
                    String first = this.getToken(fieldName, part1, AnalysisMode.DEFAULT);
                    String last = this.getToken(fieldName, part2, AnalysisMode.DEFAULT);
                    return new ConstantScoreRangeQuery(fieldName, first, last, includeLower, includeUpper);
                }
                String first = this.getToken(fieldName, part1, AnalysisMode.DEFAULT);
                String last = this.getToken(fieldName, part2, AnalysisMode.DEFAULT);
                return new ConstantScoreRangeQuery(fieldName, first, last, includeLower, includeUpper);
            }
            String first = this.getToken(fieldName, part1, AnalysisMode.DEFAULT);
            String last = this.getToken(fieldName, part2, AnalysisMode.DEFAULT);
            return new ConstantScoreRangeQuery(fieldName, first, last, includeLower, includeUpper);
        }
        if (this.getLowercaseExpandedTerms()) {
            part1 = part1.toLowerCase();
            part2 = part2.toLowerCase();
        }
        return new ConstantScoreRangeQuery(field, part1, part2, includeLower, includeUpper);
    }

    private void addLocaleSpecificUntokenisedTextRangeFunction(String expandedFieldName, String lower, String upper, boolean includeLower, boolean includeUpper, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, String textFieldName) {
        String lowerTermText = lower;
        if (locale.toString().length() > 0) {
            lowerTermText = "{" + locale + "}" + lower;
        }
        String upperTermText = upper;
        if (locale.toString().length() > 0) {
            upperTermText = "{" + locale + "}" + upper;
        }
        Query subQuery = this.buildRangeFunctionQuery(textFieldName, lowerTermText, upperTermText, includeLower, includeUpper, luceneFunction);
        booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private Query buildRangeFunctionQuery(String expandedFieldName, String lowerTermText, String upperTermText, boolean includeLower, boolean includeUpper, LuceneFunction luceneFunction) {
        String testUpperTermText;
        String testLowerTermText = lowerTermText;
        if (testLowerTermText.startsWith("{")) {
            int index = lowerTermText.indexOf("}");
            testLowerTermText = lowerTermText.substring(index + 1);
        }
        if ((testUpperTermText = upperTermText).startsWith("{")) {
            int index = upperTermText.indexOf("}");
            testUpperTermText = upperTermText.substring(index + 1);
        }
        switch (luceneFunction) {
            case LOWER: {
                if (testLowerTermText.equals(testLowerTermText.toLowerCase()) && testUpperTermText.equals(testUpperTermText.toLowerCase())) {
                    return new CaseInsensitiveFieldRangeQuery(expandedFieldName, lowerTermText, upperTermText, includeLower, includeUpper);
                }
                return this.createNoMatchQuery();
            }
            case UPPER: {
                if (testLowerTermText.equals(testLowerTermText.toUpperCase()) && testUpperTermText.equals(testUpperTermText.toUpperCase())) {
                    return new CaseInsensitiveFieldRangeQuery(expandedFieldName, lowerTermText, upperTermText, includeLower, includeUpper);
                }
                return this.createNoMatchQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported Lucene Function " + (Object)((Object)luceneFunction));
    }

    private void addLocaleSpecificTokenisedTextRange(String part1, String part2, boolean includeLower, boolean includeUpper, AnalysisMode analysisMode, String fieldName, BooleanQuery booleanQuery, Locale locale, String textFieldName) throws ParseException {
        StringBuilder builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(part1);
        String first = this.getToken(fieldName, builder.toString(), analysisMode);
        builder = new StringBuilder();
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(part2);
        String last = this.getToken(fieldName, builder.toString(), analysisMode);
        ConstantScoreRangeQuery query = new ConstantScoreRangeQuery(textFieldName, first, last, includeLower, includeUpper);
        booleanQuery.add((Query)query, BooleanClause.Occur.SHOULD);
    }

    private void addLocaleSpecificUntokenisedTextRange(String field, String part1, String part2, boolean includeLower, boolean includeUpper, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, String textFieldName) {
        String lower = part1;
        String upper = part2;
        if (locale.toString().length() > 0) {
            lower = "{" + locale + "}" + part1;
            upper = "{" + locale + "}" + part2;
        }
        ConstantScoreRangeQuery subQuery = new ConstantScoreRangeQuery(textFieldName, lower, upper, includeLower, includeUpper);
        booleanQuery.add((Query)subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Query buildDateTimeRange(String field, Calendar start, Calendar end, boolean includeLower, boolean includeUpper) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        if (start.get(1) == end.get(1)) {
            TermQuery part = new TermQuery(new Term(field, "YE" + start.get(1)));
            query.add((Query)part, BooleanClause.Occur.MUST);
            if (start.get(2) == end.get(2)) {
                part = new TermQuery(new Term(field, this.build2SF("MO", start.get(2))));
                query.add((Query)part, BooleanClause.Occur.MUST);
                if (start.get(5) == end.get(5)) {
                    part = new TermQuery(new Term(field, this.build2SF("DA", start.get(5))));
                    query.add((Query)part, BooleanClause.Occur.MUST);
                    if (start.get(11) == end.get(11)) {
                        part = new TermQuery(new Term(field, this.build2SF("HO", start.get(11))));
                        query.add((Query)part, BooleanClause.Occur.MUST);
                        if (start.get(12) == end.get(12)) {
                            part = new TermQuery(new Term(field, this.build2SF("MI", start.get(12))));
                            query.add((Query)part, BooleanClause.Occur.MUST);
                            if (start.get(13) == end.get(13)) {
                                part = new TermQuery(new Term(field, this.build2SF("SE", start.get(13))));
                                query.add((Query)part, BooleanClause.Occur.MUST);
                                if (start.get(14) == end.get(14)) {
                                    if (!includeLower || !includeUpper) return this.createNoMatchQuery();
                                    part = new TermQuery(new Term(field, this.build3SF("MS", start.get(14))));
                                    query.add((Query)part, BooleanClause.Occur.MUST);
                                    return query;
                                } else {
                                    part = new ConstantScoreRangeQuery(field, this.build3SF("MS", start.get(14)), this.build3SF("MS", end.get(14)), includeLower, includeUpper);
                                    query.add((Query)part, BooleanClause.Occur.MUST);
                                }
                                return query;
                            } else {
                                BooleanQuery subQuery = new BooleanQuery();
                                Query subPart = this.buildStart(field, start, includeLower, 13, 14);
                                if (subPart != null) {
                                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                }
                                if (end.get(13) - start.get(13) > 1) {
                                    subPart = new ConstantScoreRangeQuery(field, this.build2SF("SE", start.get(13)), this.build2SF("SE", end.get(13)), false, false);
                                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                }
                                if ((subPart = this.buildEnd(field, end, includeUpper, 13, 14)) != null) {
                                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                                }
                                if (subQuery.clauses().size() <= 0) return query;
                                query.add((Query)subQuery, BooleanClause.Occur.MUST);
                            }
                            return query;
                        } else {
                            Query subPart;
                            BooleanQuery subQuery = new BooleanQuery();
                            for (int i : new int[]{14, 13}) {
                                subPart = this.buildStart(field, start, includeLower, 12, i);
                                if (subPart == null) continue;
                                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                            }
                            if (end.get(12) - start.get(12) > 1) {
                                subPart = new ConstantScoreRangeQuery(field, this.build2SF("MI", start.get(12)), this.build2SF("MI", end.get(12)), false, false);
                                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                            }
                            for (int i : new int[]{13, 14}) {
                                subPart = this.buildEnd(field, end, includeUpper, 12, i);
                                if (subPart == null) continue;
                                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                            }
                            if (subQuery.clauses().size() <= 0) return query;
                            query.add((Query)subQuery, BooleanClause.Occur.MUST);
                        }
                        return query;
                    } else {
                        Query subPart;
                        BooleanQuery subQuery = new BooleanQuery();
                        for (int i : new int[]{14, 13, 12}) {
                            subPart = this.buildStart(field, start, includeLower, 11, i);
                            if (subPart == null) continue;
                            subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                        }
                        if (end.get(11) - start.get(11) > 1) {
                            subPart = new ConstantScoreRangeQuery(field, this.build2SF("HO", start.get(11)), this.build2SF("HO", end.get(11)), false, false);
                            subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                        }
                        for (int i : new int[]{12, 13, 14}) {
                            subPart = this.buildEnd(field, end, includeUpper, 11, i);
                            if (subPart == null) continue;
                            subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                        }
                        if (subQuery.clauses().size() <= 0) return query;
                        query.add((Query)subQuery, BooleanClause.Occur.MUST);
                    }
                    return query;
                } else {
                    Query subPart;
                    BooleanQuery subQuery = new BooleanQuery();
                    for (int i : new int[]{14, 13, 12, 11}) {
                        subPart = this.buildStart(field, start, includeLower, 5, i);
                        if (subPart == null) continue;
                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                    }
                    if (end.get(5) - start.get(5) > 1) {
                        subPart = new ConstantScoreRangeQuery(field, this.build2SF("DA", start.get(5)), this.build2SF("DA", end.get(5)), false, false);
                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                    }
                    for (int i : new int[]{11, 12, 13, 14}) {
                        subPart = this.buildEnd(field, end, includeUpper, 5, i);
                        if (subPart == null) continue;
                        subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                    }
                    if (subQuery.clauses().size() <= 0) return query;
                    query.add((Query)subQuery, BooleanClause.Occur.MUST);
                }
                return query;
            } else {
                Query subPart;
                BooleanQuery subQuery = new BooleanQuery();
                for (int i : new int[]{14, 13, 12, 11, 5}) {
                    subPart = this.buildStart(field, start, includeLower, 2, i);
                    if (subPart == null) continue;
                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                }
                if (end.get(2) - start.get(2) > 1) {
                    subPart = new ConstantScoreRangeQuery(field, this.build2SF("MO", start.get(2)), this.build2SF("MO", end.get(2)), false, false);
                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                }
                for (int i : new int[]{5, 11, 12, 13, 14}) {
                    subPart = this.buildEnd(field, end, includeUpper, 2, i);
                    if (subPart == null) continue;
                    subQuery.add(subPart, BooleanClause.Occur.SHOULD);
                }
                if (subQuery.clauses().size() <= 0) return query;
                query.add((Query)subQuery, BooleanClause.Occur.MUST);
            }
            return query;
        } else {
            Query subPart;
            BooleanQuery subQuery = new BooleanQuery();
            for (int i : new int[]{14, 13, 12, 11, 5, 2}) {
                subPart = this.buildStart(field, start, includeLower, 1, i);
                if (subPart == null) continue;
                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
            }
            if (end.get(1) - start.get(1) > 1) {
                subPart = new ConstantScoreRangeQuery(field, "YE" + start.get(1), "YE" + end.get(1), false, false);
                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
            }
            for (int i : new int[]{2, 5, 11, 12, 13, 14}) {
                subPart = this.buildEnd(field, end, includeUpper, 1, i);
                if (subPart == null) continue;
                subQuery.add(subPart, BooleanClause.Occur.SHOULD);
            }
            if (subQuery.clauses().size() <= 0) return query;
            query.add((Query)subQuery, BooleanClause.Occur.MUST);
        }
        return query;
    }

    private Query buildStart(String field, Calendar cal, boolean inclusive, int startField, int padField) {
        BooleanQuery range = new BooleanQuery();
        int ms = cal.get(14) + (inclusive ? 0 : 1);
        switch (startField) {
            case 1: {
                TermQuery part = new TermQuery(new Term(field, "YE" + cal.get(1)));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 2: {
                TermQuery part;
                if (cal.get(2) == 0 && cal.get(5) == 1 && cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && ms == 0) {
                    if (padField == 5) break;
                    return null;
                }
                if (padField == 2) {
                    if (cal.get(2) < cal.getMaximum(2)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MO", cal.get(2) + 1), "MO" + cal.getMaximum(2), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("MO", cal.get(2))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 5: {
                TermQuery part;
                if (cal.get(5) == 1 && cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && ms == 0) {
                    if (padField == 11) break;
                    return null;
                }
                if (padField == 5) {
                    if (cal.get(5) < cal.getMaximum(5)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("DA", cal.get(5) + 1), "DA" + cal.getMaximum(5), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("DA", cal.get(5))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 11: {
                TermQuery part;
                if (cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && ms == 0) {
                    if (padField == 12) break;
                    return null;
                }
                if (padField == 11) {
                    if (cal.get(11) < cal.getMaximum(11)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("HO", cal.get(11) + 1), "HO" + cal.getMaximum(11), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("HO", cal.get(11))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 12: {
                TermQuery part;
                if (cal.get(12) == 0 && cal.get(13) == 0 && ms == 0) {
                    if (padField == 13) break;
                    return null;
                }
                if (padField == 12) {
                    if (cal.get(12) < cal.getMaximum(12)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MI", cal.get(12) + 1), "MI" + cal.getMaximum(12), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("MI", cal.get(12))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 13: {
                TermQuery part;
                if (cal.get(13) == 0 && ms == 0) {
                    if (padField == 14) break;
                    return null;
                }
                if (padField == 13) {
                    if (cal.get(13) < cal.getMaximum(13)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("SE", cal.get(13) + 1), "SE" + cal.getMaximum(13), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("SE", cal.get(13))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            default: {
                TermQuery part;
                if (ms > 0 && ms <= cal.getMaximum(14)) {
                    part = new ConstantScoreRangeQuery(field, this.build3SF("MS", ms), "MS" + cal.getMaximum(14), true, true);
                    range.add((Query)part, BooleanClause.Occur.MUST);
                    break;
                }
                return null;
            }
        }
        if (range.clauses().size() > 0) {
            return range;
        }
        return null;
    }

    private Query buildEnd(String field, Calendar cal, boolean inclusive, int startField, int padField) {
        BooleanQuery range = new BooleanQuery();
        int ms = cal.get(14) - (inclusive ? 0 : 1);
        switch (startField) {
            case 1: {
                TermQuery part = new TermQuery(new Term(field, "YE" + cal.get(1)));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 2: {
                TermQuery part;
                if (cal.get(2) == 0 && cal.get(5) == 1 && cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && ms == 0 && padField == 2) {
                    return null;
                }
                if (padField == 2) {
                    if (cal.get(2) > cal.getMinimum(2)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MO", cal.getMinimum(2)), this.build2SF("MO", cal.get(2) - 1), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("MO", cal.get(2))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 5: {
                TermQuery part;
                if (cal.get(5) == 1 && cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && ms == 0 && padField == 5) {
                    return null;
                }
                if (padField == 5) {
                    if (cal.get(5) > cal.getMinimum(5)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("DA", cal.getMinimum(5)), this.build2SF("DA", cal.get(5) - 1), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("DA", cal.get(5))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 11: {
                TermQuery part;
                if (cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && ms == 0 && padField == 11) {
                    return null;
                }
                if (padField == 11) {
                    if (cal.get(11) > cal.getMinimum(11)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("HO", cal.getMinimum(11)), this.build2SF("HO", cal.get(11) - 1), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("HO", cal.get(11))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 12: {
                TermQuery part;
                if (cal.get(12) == 0 && cal.get(13) == 0 && ms == 0 && padField == 12) {
                    return null;
                }
                if (padField == 12) {
                    if (cal.get(12) > cal.getMinimum(12)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("MI", cal.getMinimum(12)), this.build2SF("MI", cal.get(12) - 1), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("MI", cal.get(12))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            case 13: {
                TermQuery part;
                if (cal.get(13) == 0 && ms == 0 && padField == 13) {
                    return null;
                }
                if (padField == 13) {
                    if (cal.get(13) > cal.getMinimum(13)) {
                        part = new ConstantScoreRangeQuery(field, this.build2SF("SE", cal.getMinimum(13)), this.build2SF("SE", cal.get(13) - 1), true, true);
                        range.add((Query)part, BooleanClause.Occur.MUST);
                        break;
                    }
                    return null;
                }
                part = new TermQuery(new Term(field, this.build2SF("SE", cal.get(13))));
                range.add((Query)part, BooleanClause.Occur.MUST);
            }
            default: {
                TermQuery part;
                if (ms >= cal.getMinimum(14) && ms < cal.getMaximum(14)) {
                    part = new ConstantScoreRangeQuery(field, this.build3SF("MS", cal.getMinimum(14)), this.build3SF("MS", ms), true, true);
                    range.add((Query)part, BooleanClause.Occur.MUST);
                    break;
                }
                return null;
            }
        }
        if (range.clauses().size() > 0) {
            return range;
        }
        return null;
    }

    private String build2SF(String prefix, int value) {
        if (value < 10) {
            return prefix + "0" + value;
        }
        return prefix + value;
    }

    private String build3SF(String prefix, int value) {
        if (value < 10) {
            return prefix + "00" + value;
        }
        if (value < 100) {
            return prefix + "0" + value;
        }
        return prefix + value;
    }

    private String expandAttributeFieldName(String field) {
        return PROPERTY_FIELD_PREFIX + this.expandQName(field.substring(1));
    }

    private String expandQName(String qnameString) {
        String fieldName = qnameString;
        if (qnameString.charAt(0) != '{') {
            String prefix;
            String uri;
            int colonPosition = qnameString.indexOf(58);
            fieldName = colonPosition == -1 ? "{" + this.searchParameters.getNamespace() + "}" + qnameString : ((uri = this.matchURI(prefix = qnameString.substring(0, colonPosition))) == null ? "{" + this.searchParameters.getNamespace() + "}" + qnameString : "{" + uri + "}" + qnameString.substring(colonPosition + 1));
        }
        return fieldName;
    }

    private String matchURI(String prefix) {
        HashSet<String> prefixes = new HashSet<String>(this.namespacePrefixResolver.getPrefixes());
        if (prefixes.contains(prefix)) {
            return this.namespacePrefixResolver.getNamespaceURI(prefix);
        }
        String match = null;
        for (String candidate : prefixes) {
            if (!candidate.equalsIgnoreCase(prefix)) continue;
            if (match == null) {
                match = candidate;
                continue;
            }
            throw new LuceneQueryParserException("Ambiguous namespace prefix " + prefix);
        }
        if (match == null) {
            return null;
        }
        return this.namespacePrefixResolver.getNamespaceURI(match);
    }

    private String getToken(String field, String value, AnalysisMode analysisMode) throws ParseException {
        TokenStream source = this.getAnalyzer().tokenStream(field, new StringReader(value), analysisMode);
        Token reusableToken = new Token();
        String tokenised = null;
        while (true) {
            Token nextToken;
            try {
                nextToken = source.next(reusableToken);
            }
            catch (IOException e) {
                nextToken = null;
            }
            if (nextToken == null) break;
            tokenised = new String(nextToken.termBuffer(), 0, nextToken.termLength());
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return tokenised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getPrefixQuery(String field, String termStr) throws ParseException {
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            return this.attributeQueryBuilder(field, termStr, new PrefixQuery(), AnalysisMode.PREFIX, LuceneFunction.FIELD);
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getPrefixQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getPrefixQuery(fieldName, termStr);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ID)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getPrefixQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals(FIELD_PARENT)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getPrefixQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        return super.getPrefixQuery(field, termStr);
    }

    public Query getWildcardQuery(String field, String termStr) throws ParseException {
        return this.getWildcardQuery(field, termStr, AnalysisMode.WILD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query getWildcardQuery(String field, String termStr, AnalysisMode analysisMode) throws ParseException {
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            return this.attributeQueryBuilder(field, termStr, new WildcardQuery(), analysisMode, LuceneFunction.FIELD);
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getWildcardQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getWildcardQuery(fieldName, termStr);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ID)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getWildcardQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals(FIELD_PARENT)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getWildcardQuery(field, termStr);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        return super.getWildcardQuery(field, termStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        if (field.startsWith(PROPERTY_FIELD_PREFIX)) {
            return this.attributeQueryBuilder(field, termStr, new FuzzyQuery(minSimilarity), AnalysisMode.FUZZY, LuceneFunction.FIELD);
        }
        if (field.equals(FIELD_TEXT)) {
            Set<String> text = this.searchParameters.getTextAttributes();
            if (text == null || text.size() == 0) {
                Collection<QName> contentAttributes = this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT);
                BooleanQuery query = new BooleanQuery();
                for (QName qname : contentAttributes) {
                    Query part = this.getFuzzyQuery(PROPERTY_FIELD_PREFIX + qname.toString(), termStr, minSimilarity);
                    if (part != null) {
                        query.add(part, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                }
                return query;
            }
            BooleanQuery query = new BooleanQuery();
            for (String fieldName : text) {
                Query part = this.getFuzzyQuery(fieldName, termStr, minSimilarity);
                if (part != null) {
                    query.add(part, BooleanClause.Occur.SHOULD);
                    continue;
                }
                query.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
            }
            return query;
        }
        if (field.equals(FIELD_ID)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getFuzzyQuery(field, termStr, minSimilarity);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        if (field.equals(FIELD_PARENT)) {
            boolean lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
            try {
                this.setLowercaseExpandedTerms(false);
                Query query = super.getFuzzyQuery(field, termStr, minSimilarity);
                return query;
            }
            finally {
                this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
            }
        }
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Query getSuperFieldQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        return this.getFieldQueryImpl(field, queryText, analysisMode, luceneFunction);
    }

    public Query getSuperFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    public Query getSuperPrefixQuery(String field, String termStr) throws ParseException {
        return super.getPrefixQuery(field, termStr);
    }

    public Query getSuperWildcardQuery(String field, String termStr) throws ParseException {
        return super.getWildcardQuery(field, termStr);
    }

    protected Query newWildcardQuery(Term t) {
        if (t.text().contains("\\")) {
            String regexp = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_LUCENE, SearchLanguageConversion.DEF_REGEX, t.text());
            return new RegexQuery(new Term(t.field(), regexp));
        }
        return super.newWildcardQuery(t);
    }

    protected Query newPrefixQuery(Term prefix) {
        if (prefix.text().contains("\\")) {
            String regexp = SearchLanguageConversion.convert(SearchLanguageConversion.DEF_LUCENE, SearchLanguageConversion.DEF_REGEX, prefix.text());
            return new RegexQuery(new Term(prefix.field(), regexp));
        }
        return super.newPrefixQuery(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Query attributeQueryBuilder(String field, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
        propertyFieldName = null;
        ending = "";
        if (field.endsWith(".mimetype")) {
            propertyFieldName = field.substring(1, field.length() - 9);
            ending = ".mimetype";
        } else if (field.endsWith(".size")) {
            propertyFieldName = field.substring(1, field.length() - 5);
            ending = ".size";
        } else if (field.endsWith(".locale")) {
            propertyFieldName = field.substring(1, field.length() - 7);
            ending = ".locale";
        } else {
            propertyFieldName = field.substring(1);
        }
        propertyDef = this.matchPropertyDefinition(propertyFieldName);
        tokenisationMode = IndexTokenisationMode.TRUE;
        if (propertyDef != null) {
            tokenisationMode = propertyDef.getIndexTokenisationMode();
            if (tokenisationMode == null) {
                tokenisationMode = IndexTokenisationMode.TRUE;
            }
            expandedFieldName = "@" + propertyDef.getName() + ending;
            propertyQName = propertyDef.getName();
        } else {
            expandedFieldName = this.expandAttributeFieldName(field);
            propertyQName = QName.createQName(propertyFieldName);
        }
        if (luceneFunction != LuceneFunction.FIELD && (tokenisationMode == IndexTokenisationMode.FALSE || tokenisationMode == IndexTokenisationMode.BOTH)) {
            return this.functionQueryBuilder(expandedFieldName, propertyQName, propertyDef, tokenisationMode, queryText, luceneFunction);
        }
        if (expandedFieldName.endsWith(".mimetype") != false ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) != false : (expandedFieldName.endsWith(".size") != false ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) != false : expandedFieldName.endsWith(".locale") != false && propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) != false)) {
            return subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
            booleanQuery = new BooleanQuery();
            mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            locales = this.searchParameters.getLocales();
            expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
lbl40:
            // 7 sources

            block28: for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                mlFieldName = expandedFieldName;
                if (tokenisationMode == IndexTokenisationMode.BOTH && (analysisMode == AnalysisMode.IDENTIFIER || analysisMode == AnalysisMode.LIKE) && (tm = propertyDef.getIndexTokenisationMode()) != null && tm == IndexTokenisationMode.BOTH) {
                    mlFieldName = locale.toString().length() == 0 ? mlFieldName + ".no_locale" : mlFieldName + "." + locale + ".sort";
                }
                lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
                try {
                    switch (3.$SwitchMap$org$alfresco$repo$dictionary$IndexTokenisationMode[tokenisationMode.ordinal()]) {
                        case 1: {
                            switch (3.$SwitchMap$org$alfresco$repo$search$impl$lucene$AnalysisMode[analysisMode.ordinal()]) {
                                default: {
                                    this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName);
                                    ** break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                            }
                            this.setLowercaseExpandedTerms(false);
                            this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, mlFieldName);
                            ** break;
                        }
                        case 2: {
                            this.setLowercaseExpandedTerms(false);
                            this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, mlFieldName);
                            ** break;
                        }
                        default: {
                            switch (3.$SwitchMap$org$alfresco$repo$search$impl$lucene$AnalysisMode[analysisMode.ordinal()]) {
                                default: {
                                    this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName);
                                    ** break;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                            }
                            this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, mlFieldName);
                            continue block28;
                        }
                    }
                }
                finally {
                    this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
                }
            }
            return booleanQuery;
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            v0 = mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            if (mlAnalysisMode.includesAll()) {
                return subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
            }
            locales = this.searchParameters.getLocales();
            expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, true));
            }
            if (expandedLocales.size() > 0) {
                booleanQuery = new BooleanQuery();
                contentQuery = subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
                if (contentQuery != null) {
                    booleanQuery.add(contentQuery, BooleanClause.Occur.MUST);
                    subQuery = new BooleanQuery();
                    for (Locale locale : expandedLocales) {
                        builder = new StringBuilder();
                        builder.append(expandedFieldName).append(".locale");
                        localeString = locale.toString();
                        if (localeString.indexOf("*") == -1) {
                            localeQuery = this.getFieldQuery(builder.toString(), localeString);
                            if (localeQuery != null) {
                                subQuery.add(localeQuery, BooleanClause.Occur.SHOULD);
                                continue;
                            }
                            subQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                            continue;
                        }
                        localeQuery = this.getWildcardQuery(builder.toString(), localeString);
                        if (localeQuery != null) {
                            subQuery.add(localeQuery, BooleanClause.Occur.SHOULD);
                            continue;
                        }
                        subQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
                    }
                    booleanQuery.add((Query)subQuery, BooleanClause.Occur.MUST);
                }
                return booleanQuery;
            }
            query = subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
            if (query != null) {
                return query;
            }
            return this.createNoMatchQuery();
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
            if (propertyQName.equals(ContentModel.PROP_USER_USERNAME) || propertyQName.equals(ContentModel.PROP_USERNAME) || propertyQName.equals(ContentModel.PROP_AUTHORITY_NAME)) {
                return subQueryBuilder.getQuery(expandedFieldName, queryText, analysisMode, luceneFunction);
            }
            booleanQuery = new BooleanQuery();
            mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            locales = this.searchParameters.getLocales();
            expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
lbl123:
            // 8 sources

            block32: for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                textFieldName = expandedFieldName;
                if (tokenisationMode == IndexTokenisationMode.BOTH && (analysisMode == AnalysisMode.IDENTIFIER || analysisMode == AnalysisMode.LIKE) && (tm = propertyDef.getIndexTokenisationMode()) != null && tm == IndexTokenisationMode.BOTH) {
                    textFieldName = textFieldName + "." + locale + ".sort";
                }
                lowercaseExpandedTerms = this.getLowercaseExpandedTerms();
                try {
                    switch (3.$SwitchMap$org$alfresco$repo$dictionary$IndexTokenisationMode[tokenisationMode.ordinal()]) {
                        case 1: {
                            switch (3.$SwitchMap$org$alfresco$repo$search$impl$lucene$AnalysisMode[analysisMode.ordinal()]) {
                                default: {
                                    this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, textFieldName);
                                    ** break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                            }
                            this.setLowercaseExpandedTerms(false);
                            this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
                            ** break;
                        }
                        case 2: {
                            this.setLowercaseExpandedTerms(false);
                            this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
                            ** break;
                        }
                        default: {
                            switch (3.$SwitchMap$org$alfresco$repo$search$impl$lucene$AnalysisMode[analysisMode.ordinal()]) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    this.addLocaleSpecificTokenisedMLOrTextAttribute(queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, locale, expandedFieldName);
                                    ** break;
                                }
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: {
                                    this.addLocaleSpecificUntokenisedMLOrTextAttribute(field, queryText, subQueryBuilder, analysisMode, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
                                    continue block32;
                                }
                                ** default:
lbl152:
                                // 1 sources

                                continue block32;
                            }
                        }
                    }
                }
                finally {
                    this.setLowercaseExpandedTerms(lowercaseExpandedTerms);
                }
            }
            return booleanQuery;
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME) && analysisMode == AnalysisMode.LIKE) {
            throw new UnsupportedOperationException("Wild cards are not supported for the datetime type");
        }
        query = subQueryBuilder.getQuery(expandedFieldName, queryText, AnalysisMode.DEFAULT, luceneFunction);
        if (query != null) {
            return query;
        }
        return this.createNoMatchQuery();
    }

    private void addLocaleSpecificUntokenisedMLOrTextAttribute(String sourceField, String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, String actualField) throws ParseException {
        String termText = queryText;
        if (locale.toString().length() > 0) {
            termText = "{" + locale + "}" + queryText;
        }
        Query subQuery = subQueryBuilder.getQuery(actualField, termText, analysisMode, luceneFunction);
        booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private void addLocaleSpecificTokenisedMLOrTextAttribute(String queryText, SubQuery subQueryBuilder, AnalysisMode analysisMode, LuceneFunction luceneFunction, BooleanQuery booleanQuery, Locale locale, String actualField) throws ParseException {
        StringBuilder builder = new StringBuilder(queryText.length() + 10);
        builder.append("\u0000").append(locale.toString()).append("\u0000").append(queryText);
        Query subQuery = subQueryBuilder.getQuery(actualField, builder.toString(), analysisMode, luceneFunction);
        if (subQuery != null) {
            booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        } else {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private Query functionQueryBuilder(String expandedFieldName, QName propertyQName, PropertyDefinition propertyDef, IndexTokenisationMode tokenisationMode, String queryText, LuceneFunction luceneFunction) throws ParseException {
        if (expandedFieldName.endsWith(FIELD_MIMETYPE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : (expandedFieldName.endsWith(FIELD_SIZE_SUFFIX) ? propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT) : expandedFieldName.endsWith(FIELD_LOCALE_SUFFIX) && propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT))) {
            throw new UnsupportedOperationException("Lucene Function");
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                String mlFieldName = expandedFieldName;
                if (tokenisationMode == IndexTokenisationMode.BOTH) {
                    mlFieldName = mlFieldName + "." + locale + FIELD_SORT_SUFFIX;
                }
                this.addLocaleSpecificUntokenisedMLOrTextFunction(expandedFieldName, queryText, luceneFunction, booleanQuery, mlAnalysisMode, locale, mlFieldName);
            }
            return booleanQuery;
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
            throw new UnsupportedOperationException("Lucene functions not supported for content");
        }
        if (propertyDef != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
            if (propertyQName.equals(ContentModel.PROP_USER_USERNAME) || propertyQName.equals(ContentModel.PROP_USERNAME) || propertyQName.equals(ContentModel.PROP_AUTHORITY_NAME)) {
                throw new UnsupportedOperationException("Functions are not supported agaisnt special text fields");
            }
            BooleanQuery booleanQuery = new BooleanQuery();
            MLAnalysisMode mlAnalysisMode = this.searchParameters.getMlAnalaysisMode() == null ? this.defaultSearchMLAnalysisMode : this.searchParameters.getMlAnalaysisMode();
            List<Locale> locales = this.searchParameters.getLocales();
            ArrayList<Locale> expandedLocales = new ArrayList<Locale>();
            for (Locale locale : locales == null || locales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : locales) {
                expandedLocales.addAll(MLAnalysisMode.getLocales(mlAnalysisMode, locale, false));
            }
            for (Locale locale : expandedLocales == null || expandedLocales.size() == 0 ? Collections.singletonList(I18NUtil.getLocale()) : expandedLocales) {
                String textFieldName = expandedFieldName;
                if (tokenisationMode == IndexTokenisationMode.BOTH) {
                    textFieldName = textFieldName + "." + locale + FIELD_SORT_SUFFIX;
                }
                this.addLocaleSpecificUntokenisedMLOrTextFunction(expandedFieldName, queryText, luceneFunction, booleanQuery, mlAnalysisMode, locale, textFieldName);
            }
            return booleanQuery;
        }
        throw new UnsupportedOperationException("Lucene Function");
    }

    private void addLocaleSpecificUntokenisedMLOrTextFunction(String expandedFieldName, String queryText, LuceneFunction luceneFunction, BooleanQuery booleanQuery, MLAnalysisMode mlAnalysisMode, Locale locale, String textFieldName) {
        String termText = queryText;
        if (locale.toString().length() > 0) {
            termText = "{" + locale + "}" + queryText;
        }
        Query subQuery = this.buildFunctionQuery(textFieldName, termText, luceneFunction);
        booleanQuery.add(subQuery, BooleanClause.Occur.SHOULD);
        if (booleanQuery.getClauses().length == 0) {
            booleanQuery.add((Query)this.createNoMatchQuery(), BooleanClause.Occur.SHOULD);
        }
    }

    private Query buildFunctionQuery(String expandedFieldName, String termText, LuceneFunction luceneFunction) {
        String testText = termText;
        if (termText.startsWith("{")) {
            int index = termText.indexOf("}");
            testText = termText.substring(index + 1);
        }
        switch (luceneFunction) {
            case LOWER: {
                if (testText.equals(testText.toLowerCase())) {
                    return new CaseInsensitiveFieldQuery(new Term(expandedFieldName, termText));
                }
                return this.createNoMatchQuery();
            }
            case UPPER: {
                if (testText.equals(testText.toUpperCase())) {
                    return new CaseInsensitiveFieldQuery(new Term(expandedFieldName, termText));
                }
                return this.createNoMatchQuery();
            }
        }
        throw new UnsupportedOperationException("Unsupported Lucene Function " + (Object)((Object)luceneFunction));
    }

    protected TermQuery createNoMatchQuery() {
        return new TermQuery(new Term("NO_TOKENS", "__"));
    }

    public static void main(String[] args) throws ParseException, java.text.ParseException {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)false);
        Date date = df.parse("2007-11-30T22:58:58.998");
        System.out.println(date);
        start.setTime(date);
        System.out.println(start);
        date = df.parse("2008-01-01T03:00:01.002");
        System.out.println(date);
        end.setTime(date);
        System.out.println(end);
        LuceneQueryParser lqp = new LuceneQueryParser(null, null);
        Query query = lqp.buildDateTimeRange("TEST", start, end, false, false);
        System.out.println("Query is " + query);
    }

    public LuceneAnalyser getAnalyzer() {
        return this.luceneAnalyser;
    }

    class WildcardQuery
    implements SubQuery {
        WildcardQuery() {
        }

        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return LuceneQueryParser.this.getSuperWildcardQuery(field, termStr);
        }
    }

    class PrefixQuery
    implements SubQuery {
        PrefixQuery() {
        }

        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return LuceneQueryParser.this.getSuperPrefixQuery(field, termStr);
        }
    }

    class FuzzyQuery
    implements SubQuery {
        float minSimilarity;

        FuzzyQuery(float minSimilarity) {
            this.minSimilarity = minSimilarity;
        }

        public Query getQuery(String field, String termStr, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return LuceneQueryParser.this.getSuperFuzzyQuery(field, termStr, this.minSimilarity);
        }
    }

    class FieldQuery
    implements SubQuery {
        FieldQuery() {
        }

        public Query getQuery(String field, String queryText, AnalysisMode analysisMode, LuceneFunction luceneFunction) throws ParseException {
            return LuceneQueryParser.this.getSuperFieldQuery(field, queryText, analysisMode, luceneFunction);
        }
    }

    static interface SubQuery {
        public Query getQuery(String var1, String var2, AnalysisMode var3, LuceneFunction var4) throws ParseException;
    }
}

