/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.Reader;
import java.util.Set;
import org.alfresco.repo.search.impl.lucene.analysis.AlfrescoStandardFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ISOLatin1AccentFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class AlfrescoStandardAnalyser
extends Analyzer {
    private Set stopSet;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;

    public AlfrescoStandardAnalyser() {
        this(STOP_WORDS);
    }

    public AlfrescoStandardAnalyser(String[] stopWords) {
        this.stopSet = StopFilter.makeStopSet((String[])stopWords);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new AlfrescoStandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopSet);
        result = new ISOLatin1AccentFilter((TokenStream)result);
        return result;
    }
}

