/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.alfresco.util.CachingDateFormat;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;

public class DateTokenFilter
extends Tokenizer {
    Tokenizer baseTokeniser;

    public DateTokenFilter(Reader in) {
        super(in);
        this.baseTokeniser = new WhitespaceTokenizer(in);
    }

    public Token next() throws IOException {
        Token candidate;
        SimpleDateFormat dof = CachingDateFormat.getDateOnlyFormat();
        while ((candidate = this.baseTokeniser.next()) != null) {
            Date date;
            if (candidate.termText().equalsIgnoreCase("now")) {
                date = new Date();
            } else if (candidate.termText().equalsIgnoreCase("today")) {
                date = new Date();
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                cal.set(11, cal.getMinimum(11));
                cal.set(12, cal.getMinimum(12));
                cal.set(13, cal.getMinimum(13));
                cal.set(14, cal.getMinimum(14));
            } else {
                try {
                    date = CachingDateFormat.lenientParse((String)candidate.termText());
                }
                catch (ParseException e) {
                    continue;
                }
            }
            String valueString = dof.format(date);
            Token integerToken = new Token(valueString, candidate.startOffset(), candidate.startOffset(), candidate.type());
            return integerToken;
        }
        return null;
    }
}

