/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;

public class DeltaReader
extends MultiReader {
    int[][] deletions;
    Boolean hasExclusions = null;
    private IndexReader[] subReaders;
    private int maxDoc = 0;
    private int[] starts;

    public DeltaReader(IndexReader[] readers, int[][] deletions) throws IOException {
        super(readers);
        this.deletions = deletions;
        this.initialize(readers);
    }

    private void initialize(IndexReader[] subReaders) throws IOException {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    protected void doCommit() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void doDelete(int arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void doUndeleteAll() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean hasDeletions() {
        return super.hasDeletions() || this.hasSearchExclusions();
    }

    private boolean hasSearchExclusions() {
        if (this.hasExclusions == null) {
            for (int i = 0; i < this.deletions.length; ++i) {
                if (this.deletions[i].length <= 0) continue;
                this.hasExclusions = new Boolean(true);
                break;
            }
            this.hasExclusions = new Boolean(false);
        }
        return this.hasExclusions;
    }

    public boolean isDeleted(int docNumber) {
        int i = this.readerIndex(docNumber);
        return super.isDeleted(docNumber) || Arrays.binarySearch(this.deletions[i], docNumber - this.starts[i]) != -1;
    }

    private int readerIndex(int n) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public TermDocs termDocs() throws IOException {
        return new DeletingTermDocs(super.termDocs());
    }

    public TermPositions termPositions() throws IOException {
        throw new UnsupportedOperationException();
    }

    private class DeletingTermDocs
    implements TermDocs {
        TermDocs delegate;

        DeletingTermDocs(TermDocs delegate) {
            this.delegate = delegate;
        }

        public void seek(Term term) throws IOException {
            this.delegate.seek(term);
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.delegate.seek(termEnum);
        }

        public int doc() {
            return this.delegate.doc();
        }

        public int freq() {
            return this.delegate.freq();
        }

        public boolean next() throws IOException {
            while (this.delegate.next()) {
                if (DeltaReader.this.isDeleted(this.doc())) continue;
                return true;
            }
            return false;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int deletedCount;
            int end;
            do {
                if ((end = this.delegate.read(docs, freqs)) == 0) {
                    return end;
                }
                deletedCount = 0;
                for (int i = 0; i < end; ++i) {
                    if (DeltaReader.this.isDeleted(docs[i])) continue;
                    ++deletedCount;
                }
            } while (end == deletedCount);
            int position = 0;
            for (int i = 0; i < end; ++i) {
                if (DeltaReader.this.isDeleted(i)) continue;
                docs[position] = docs[i];
                freqs[position] = freqs[i];
                ++position;
            }
            return position;
        }

        public boolean skipTo(int docNumber) throws IOException {
            this.delegate.skipTo(docNumber);
            if (!DeltaReader.this.isDeleted(this.doc())) {
                return true;
            }
            return this.next();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

