/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.jsse.JSSE14SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSSE15SocketFactory
extends JSSE14SocketFactory {
    private static Log log = LogFactory.getLog(JSSE15SocketFactory.class);

    @Override
    protected TrustManager[] getTrustManagers(String keystoreType, String algorithm) throws Exception {
        KeyStore trustStore;
        String crlf;
        if (this.attributes.get("truststoreAlgorithm") == null) {
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        if ((crlf = (String)this.attributes.get("crlFile")) == null) {
            return super.getTrustManagers(keystoreType, algorithm);
        }
        TrustManager[] tms = null;
        String truststoreType = (String)this.attributes.get("truststoreType");
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if ((trustStore = this.getTrustStore(truststoreType)) != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
            CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
            tmf.init(mfp);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        PKIXBuilderParameters params = null;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = (String)this.attributes.get("trustMaxCertLength");
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    log.warn((Object)("Bad maxCertLength: " + trustLength));
                }
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        params = xparams;
        return params;
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }
}

