/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class Reaper
extends Thread {
    private static Log log = LogFactory.getLog(Reaper.class);
    private boolean daemon = false;
    private long interval = 60000L;
    ThreadPoolRunnable[] cbacks = new ThreadPoolRunnable[30];
    Object[][] tdata = new Object[30][];
    int count = 0;
    Object lock = new Object();
    static boolean running = true;

    public Reaper() {
        if (this.daemon) {
            this.setDaemon(true);
        }
        this.setName("TomcatReaper");
    }

    public Reaper(String name) {
        if (this.daemon) {
            this.setDaemon(true);
        }
        this.setName(name);
    }

    public void setDefaultInterval(long t) {
        this.interval = t;
    }

    public long getDefaultIntervale() {
        return this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCallback(ThreadPoolRunnable c, int interval) {
        Object object = this.lock;
        synchronized (object) {
            this.cbacks[this.count] = c;
            ++this.count;
            return this.count - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(int idx) {
        Object object = this.lock;
        synchronized (object) {
            --this.count;
            this.cbacks[idx] = this.cbacks[this.count];
            this.cbacks[this.count] = null;
        }
    }

    public void startReaper() {
        running = true;
        this.start();
    }

    public synchronized void stopReaper() {
        running = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stop reaper ");
        }
        this.interrupt();
    }

    public void run() {
        block2: while (running && running) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!running) break;
            for (int i = 0; i < this.count; ++i) {
                ThreadPoolRunnable callB = this.cbacks[i];
                if (callB != null) {
                    callB.runIt(this.tdata[i]);
                }
                if (!running) continue block2;
            }
        }
    }
}

