/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.ssi.SSIProcessor;
import org.apache.catalina.ssi.SSIServletExternalResolver;
import org.apache.catalina.ssi.SSIServletRequestUtil;

public class SSIServlet
extends HttpServlet {
    protected int debug = 0;
    protected boolean buffered = false;
    protected Long expires = null;
    protected boolean isVirtualWebappRelative = false;
    protected String inputEncoding = null;
    protected String outputEncoding = "UTF-8";

    public void init() throws ServletException {
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            if (value != null) {
                this.debug = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            this.log("SSIServlet.init: error reading debug from " + value);
        }
        try {
            value = this.getServletConfig().getInitParameter("isVirtualWebappRelative");
            if (value != null) {
                this.isVirtualWebappRelative = Integer.parseInt(value) > 0;
            }
        }
        catch (Exception e) {
            this.log("SSIServlet.init: error reading isVirtualWebappRelative from" + value);
        }
        try {
            value = this.getServletConfig().getInitParameter("expires");
            if (value != null) {
                this.expires = Long.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            this.expires = null;
            this.log("Invalid format for expires initParam; expected integer (seconds)");
        }
        catch (Exception e) {
            this.log("SSIServlet.init: error reading expires from " + value);
        }
        try {
            value = this.getServletConfig().getInitParameter("buffered");
            if (value != null) {
                this.buffered = Integer.parseInt(value) > 0;
            }
        }
        catch (Exception e) {
            this.log("SSIServlet.init: error reading buffered from " + value);
        }
        try {
            this.inputEncoding = this.getServletConfig().getInitParameter("inputEncoding");
        }
        catch (Exception e) {
            this.log("SSIServlet.init: error reading inputEncoding: " + e.getMessage());
        }
        try {
            value = this.getServletConfig().getInitParameter("outputEncoding");
            if (value != null) {
                this.outputEncoding = value;
            }
        }
        catch (Exception e) {
            this.log("SSIServlet.init: error reading outputEncoding from " + value);
        }
        if (this.debug > 0) {
            this.log("SSIServlet.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SSIServlet.doGet()");
        }
        this.requestHandler(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SSIServlet.doPost()");
        }
        this.requestHandler(req, res);
    }

    protected void requestHandler(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ServletContext servletContext = this.getServletContext();
        String path = SSIServletRequestUtil.getRelativePath(req);
        if (this.debug > 0) {
            this.log("SSIServlet.requestHandler()\nServing " + (this.buffered ? "buffered " : "unbuffered ") + "resource '" + path + "'");
        }
        if (path == null || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            res.sendError(404, path);
            this.log("Can't serve file: " + path);
            return;
        }
        URL resource = servletContext.getResource(path);
        if (resource == null) {
            res.sendError(404, path);
            this.log("Can't find file: " + path);
            return;
        }
        String resourceMimeType = servletContext.getMimeType(path);
        if (resourceMimeType == null) {
            resourceMimeType = "text/html";
        }
        res.setContentType(resourceMimeType + ";charset=" + this.outputEncoding);
        if (this.expires != null) {
            res.setDateHeader("Expires", new Date().getTime() + this.expires * 1000L);
        }
        req.setAttribute("org.apache.catalina.ssi.SSIServlet", (Object)"true");
        this.processSSI(req, res, resource);
    }

    protected void processSSI(HttpServletRequest req, HttpServletResponse res, URL resource) throws IOException {
        InputStreamReader isr;
        BufferedReader bufferedReader;
        long lastModified;
        SSIServletExternalResolver ssiExternalResolver = new SSIServletExternalResolver(this.getServletContext(), req, res, this.isVirtualWebappRelative, this.debug, this.inputEncoding);
        SSIProcessor ssiProcessor = new SSIProcessor(ssiExternalResolver, this.debug);
        PrintWriter printWriter = null;
        StringWriter stringWriter = null;
        if (this.buffered) {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
        } else {
            printWriter = res.getWriter();
        }
        URLConnection resourceInfo = resource.openConnection();
        InputStream resourceInputStream = resourceInfo.getInputStream();
        String encoding = resourceInfo.getContentEncoding();
        if (encoding == null) {
            encoding = this.inputEncoding;
        }
        if ((lastModified = ssiProcessor.process(bufferedReader = new BufferedReader(isr = encoding == null ? new InputStreamReader(resourceInputStream) : new InputStreamReader(resourceInputStream, encoding)), resourceInfo.getLastModified(), printWriter)) > 0L) {
            res.setDateHeader("last-modified", lastModified);
        }
        if (this.buffered) {
            printWriter.flush();
            String text = stringWriter.toString();
            res.getWriter().write(text);
        }
    }
}

