/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import junit.framework.TestCase;
import org.alfresco.cmis.CMISFilterNotValidException;
import org.alfresco.cmis.PropertyFilter;

public class PropertyFilterTest
extends TestCase {
    private static final String NAME_TOKEN = "name";
    private static final String[] FILTER_TOKENS = new String[]{"name", "objectId"};
    private static final String[] TOKENS_THAT_ARE_NOT_ALLOWED = new String[]{"ParentId", "parentId", "ParEnTiD", "IsMajorVersion", "iSmAJORvERSION"};
    private static final String VALID_MATCHE_ALL_FILTER = "*";
    private static final String VALID_FILTER_WITH_NAME = "name";
    private static final String VALID_FILTER_WITH_SEVERAL_TOKENS = "name,objectId";
    private static final String LONG_VALID_FILTER_WITH_SEVERAL_TOKENS = "objectId,name,CreationDate*,Created;By";
    private static final String INVALID_MATCHE_ALL_FILTER = "*,";
    private static final String INVALID_FILTER_WITH_NAME = "*name,";
    private static final String INVALID_FILTER_WITH_SEVERAL_TOKENS = "name,,objectId";
    private static final String LONG_INVALID_FILTER_WITH_SEVERAL_TOKENS = "objectId, name CreationDate, CreatedBy*";
    private static final String INVALID_FILTER_WITH_SEVERAL_TOKENS_WITHOUT_BREAKS = ",name,objectId,CreationDate";
    private static final String INVALID_FILTER_WITH_SEVERAL_TOKENS_AND_WITH_BREAKS_IN_SOME_PLACES = " name, objectId,CreationDate CreatedBy ModifiedBy, LastModifiedBy";
    private static final String INVALID_FILTER_WITH_FIRST_BREAK_SYMBOL = " name, objectId,CreationDate, CreatedBy, ModifiedBy, LastModifiedBy";
    private static final String INVALID_FILTER_WITH_DENIED_SYMBOL = "objectId\"name";
    private static final String INVALID_FILTER_WITH_LAST_INVALID_SYMBOL = "objectId,name\\";

    public void testValidFilters() throws Exception {
        this.allTokensValidAssertion(new PropertyFilter(null));
        this.allTokensValidAssertion(new PropertyFilter(VALID_MATCHE_ALL_FILTER));
        this.onlyNameTokensAssertionValid(new PropertyFilter("name"));
        this.nameAndObjectIdTokensAssertionValid(new PropertyFilter(VALID_FILTER_WITH_SEVERAL_TOKENS));
        this.nameAndObjectIdTokensAssertionValid(new PropertyFilter(LONG_VALID_FILTER_WITH_SEVERAL_TOKENS));
    }

    public void testInvalidFilters() throws Exception {
        this.invalidFilterAssertion(INVALID_MATCHE_ALL_FILTER);
        this.invalidFilterAssertion(INVALID_FILTER_WITH_NAME);
        this.invalidFilterAssertion(INVALID_FILTER_WITH_SEVERAL_TOKENS);
        this.invalidFilterAssertion(LONG_INVALID_FILTER_WITH_SEVERAL_TOKENS);
        this.invalidFilterAssertion(INVALID_FILTER_WITH_SEVERAL_TOKENS_WITHOUT_BREAKS);
        this.invalidFilterAssertion(INVALID_FILTER_WITH_SEVERAL_TOKENS_AND_WITH_BREAKS_IN_SOME_PLACES);
        this.invalidFilterAssertion(INVALID_FILTER_WITH_FIRST_BREAK_SYMBOL);
        this.invalidFilterAssertion(INVALID_FILTER_WITH_DENIED_SYMBOL);
        this.invalidFilterAssertion(INVALID_FILTER_WITH_LAST_INVALID_SYMBOL);
    }

    private void nameAndObjectIdTokensAssertionValid(PropertyFilter propertyFilter) {
        for (String token : FILTER_TOKENS) {
            PropertyFilterTest.assertTrue((String)(token + " should be allowed"), (boolean)propertyFilter.allow(token));
        }
        for (String token : TOKENS_THAT_ARE_NOT_ALLOWED) {
            PropertyFilterTest.assertFalse((String)(token + " should not be allowed"), (boolean)propertyFilter.allow(token));
        }
    }

    private void onlyNameTokensAssertionValid(PropertyFilter propertyFilter) {
        for (String token : FILTER_TOKENS) {
            if (!token.equals("name")) break;
            PropertyFilterTest.assertTrue((boolean)propertyFilter.allow(token));
        }
        for (String token : TOKENS_THAT_ARE_NOT_ALLOWED) {
            PropertyFilterTest.assertFalse((boolean)propertyFilter.allow(token));
        }
    }

    private void allTokensValidAssertion(PropertyFilter propertyFilter) {
        for (String token : FILTER_TOKENS) {
            PropertyFilterTest.assertTrue((boolean)propertyFilter.allow(token));
        }
        for (String token : TOKENS_THAT_ARE_NOT_ALLOWED) {
            PropertyFilterTest.assertTrue((boolean)propertyFilter.allow(token));
        }
    }

    private void invalidFilterAssertion(String filterValue) {
        try {
            new PropertyFilter(filterValue);
            PropertyFilterTest.fail((String)("Invalid filter \"" + filterValue + "\" was interpreted as valid"));
        }
        catch (CMISFilterNotValidException cMISFilterNotValidException) {
            // empty catch block
        }
    }
}

