/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.alfresco.cmis.CMISCardinalityEnum;
import org.alfresco.cmis.CMISChoice;
import org.alfresco.cmis.CMISDataTypeEnum;
import org.alfresco.cmis.CMISPropertyAccessor;
import org.alfresco.cmis.CMISPropertyDefinition;
import org.alfresco.cmis.CMISPropertyId;
import org.alfresco.cmis.CMISPropertyLuceneBuilder;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.CMISUpdatabilityEnum;
import org.alfresco.cmis.mapping.AbstractProperty;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.dictionary.constraint.ListOfValuesConstraint;
import org.alfresco.repo.dictionary.constraint.NumericRangeConstraint;
import org.alfresco.repo.dictionary.constraint.StringLengthConstraint;
import org.alfresco.repo.search.impl.lucene.analysis.DateAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.DoubleAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.FloatAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.IntegerAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.LongAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.PathAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.alfresco.service.cmr.dictionary.Constraint;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISBasePropertyDefinition
implements CMISPropertyDefinition,
Serializable {
    private static final long serialVersionUID = -8119257313852558466L;
    private CMISTypeDefinition typeDef;
    private CMISPropertyId propertyId;
    private String queryName;
    private String displayName;
    private String description;
    private CMISDataTypeEnum propertyType;
    private CMISCardinalityEnum cardinality;
    private Double minValue = null;
    private Double maxValue = null;
    private int maximumLength = -1;
    private Collection<CMISChoice> choices = new HashSet<CMISChoice>();
    private boolean isOpenChoice = false;
    private boolean required;
    private String defaultValue;
    private CMISUpdatabilityEnum updatability;
    private boolean queryable;
    private boolean orderable;
    private AbstractProperty propertyAccessor;

    public CMISBasePropertyDefinition(CMISMapping cmisMapping, CMISPropertyId propertyId, PropertyDefinition propDef, CMISTypeDefinition typeDef) {
        this.propertyId = propertyId;
        this.typeDef = typeDef;
        this.queryName = cmisMapping.buildPrefixEncodedString(propertyId.getQName());
        this.displayName = propDef.getTitle() != null ? propDef.getTitle() : propertyId.getId();
        this.description = propDef.getDescription();
        this.propertyType = cmisMapping.getDataType(propDef.getDataType());
        this.cardinality = propDef.isMultiValued() ? CMISCardinalityEnum.MULTI_VALUED : CMISCardinalityEnum.SINGLE_VALUED;
        for (ConstraintDefinition constraintDef : propDef.getConstraints()) {
            Constraint constraint = constraintDef.getConstraint();
            if (constraint instanceof ListOfValuesConstraint) {
                int position = 1;
                ListOfValuesConstraint lovc = (ListOfValuesConstraint)constraint;
                for (String allowed : lovc.getAllowedValues()) {
                    CMISChoice choice = new CMISChoice(allowed, (Serializable)((Object)allowed), position++);
                    this.choices.add(choice);
                }
            }
            if (constraint instanceof StringLengthConstraint) {
                StringLengthConstraint slc = (StringLengthConstraint)constraint;
                this.maximumLength = slc.getMaxLength();
            }
            if (!(constraint instanceof NumericRangeConstraint)) continue;
            NumericRangeConstraint nrc = (NumericRangeConstraint)constraint;
            this.minValue = nrc.getMinValue();
            this.maxValue = nrc.getMaxValue();
        }
        this.required = propDef.isMandatory();
        this.defaultValue = propDef.getDefaultValue();
        this.updatability = propertyId.getId().equals("cmis:objectTypeId") || propertyId.getId().equals("cmis:sourceId") || propertyId.getId().equals("cmis:targetId") ? CMISUpdatabilityEnum.ON_CREATE : (propDef.isProtected() ? CMISUpdatabilityEnum.READ_ONLY : CMISUpdatabilityEnum.READ_AND_WRITE);
        this.queryable = propDef.isIndexed();
        if (this.queryable) {
            if (this.cardinality == CMISCardinalityEnum.SINGLE_VALUED) {
                IndexTokenisationMode indexTokenisationMode = IndexTokenisationMode.TRUE;
                if (propDef.getIndexTokenisationMode() != null) {
                    indexTokenisationMode = propDef.getIndexTokenisationMode();
                }
                switch (indexTokenisationMode) {
                    case BOTH: 
                    case FALSE: {
                        this.orderable = true;
                        break;
                    }
                    default: {
                        String analyserClassName = propDef.getDataType().getAnalyserClassName();
                        if (propDef.getDataType().getName().equals((Object)DataTypeDefinition.BOOLEAN)) {
                            this.orderable = true;
                            break;
                        }
                        if (analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName()) || analyserClassName.equals(DateAnalyser.class.getCanonicalName()) || analyserClassName.equals(DoubleAnalyser.class.getCanonicalName()) || analyserClassName.equals(FloatAnalyser.class.getCanonicalName()) || analyserClassName.equals(IntegerAnalyser.class.getCanonicalName()) || analyserClassName.equals(LongAnalyser.class.getCanonicalName()) || analyserClassName.equals(PathAnalyser.class.getCanonicalName()) || analyserClassName.equals(VerbatimAnalyser.class.getCanonicalName())) {
                            this.orderable = true;
                            break;
                        }
                        this.orderable = false;
                        break;
                    }
                }
            } else {
                this.orderable = false;
            }
        } else {
            this.orderable = false;
        }
        this.propertyAccessor = cmisMapping.getPropertyAccessor(propertyId);
    }

    @Override
    public CMISPropertyId getPropertyId() {
        return this.propertyId;
    }

    @Override
    public CMISTypeDefinition getOwningType() {
        return this.typeDef;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CMISDataTypeEnum getDataType() {
        return this.propertyType;
    }

    @Override
    public CMISCardinalityEnum getCardinality() {
        return this.cardinality;
    }

    @Override
    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Collection<CMISChoice> getChoices() {
        return this.choices;
    }

    @Override
    public boolean isOpenChoice() {
        return this.isOpenChoice;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public CMISUpdatabilityEnum getUpdatability() {
        return this.updatability;
    }

    @Override
    public boolean isQueryable() {
        return this.queryable;
    }

    @Override
    public boolean isOrderable() {
        return this.orderable;
    }

    @Override
    public CMISPropertyAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    @Override
    public CMISPropertyLuceneBuilder getPropertyLuceneBuilder() {
        return this.propertyAccessor;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CMISPropertyDefinition[");
        builder.append("OwningTypeId=").append(this.getOwningType().getTypeId()).append(", ");
        builder.append("Id=").append(this.getPropertyId().getId()).append(", ");
        builder.append("LocalName=").append(this.getPropertyId().getLocalName()).append(", ");
        builder.append("Namespace=").append(this.getPropertyId().getLocalNamespace()).append(", ");
        builder.append("InternalQName=").append(this.getPropertyId().getQName()).append(", ");
        builder.append("QueryName=").append(this.getQueryName()).append(", ");
        builder.append("DisplayName=").append(this.getDisplayName()).append(", ");
        builder.append("Description=").append(this.getDescription()).append(", ");
        builder.append("PropertyType=").append(this.getDataType()).append(", ");
        builder.append("Cardinality=").append(this.getCardinality()).append(", ");
        builder.append("MaximumLength=").append(this.getMaximumLength()).append(", ");
        builder.append("Choices=").append(this.getChoices()).append(", ");
        builder.append("IsOpenChoice=").append(this.isOpenChoice()).append(", ");
        builder.append("Required=").append(this.isRequired()).append(", ");
        builder.append("Default=").append(this.getDefaultValue()).append(", ");
        builder.append("Updatable=").append(this.getUpdatability()).append(", ");
        builder.append("Queryable=").append(this.isQueryable()).append(", ");
        builder.append("Orderable=").append(this.isOrderable());
        builder.append("]");
        return builder.toString();
    }
}

