/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.util.Map;
import org.alfresco.cmis.mapping.AbstractProperty;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;

public abstract class AbstractVersioningProperty
extends AbstractProperty {
    protected AbstractVersioningProperty(ServiceRegistry serviceRegistry, String propertyName) {
        super(serviceRegistry, propertyName);
    }

    public NodeRef getVersionSeries(NodeRef nodeRef) {
        if (nodeRef.getStoreRef().getProtocol().equals("versionStore")) {
            Map properties = this.getServiceRegistry().getNodeService().getProperties(nodeRef);
            return new NodeRef((String)properties.get(ContentModel.PROP_STORE_PROTOCOL), (String)properties.get(ContentModel.PROP_STORE_IDENTIFIER), (String)properties.get(ContentModel.PROP_NODE_UUID));
        }
        if (this.isWorkingCopy(nodeRef)) {
            return (NodeRef)this.getServiceRegistry().getNodeService().getProperty(nodeRef, ContentModel.PROP_COPY_REFERENCE);
        }
        return nodeRef;
    }

    public boolean isWorkingCopy(NodeRef nodeRef) {
        return this.getServiceRegistry().getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
    }

    public boolean hasWorkingCopy(NodeRef nodeRef) {
        return this.getServiceRegistry().getLockService().getLockType(nodeRef) == LockType.READ_ONLY_LOCK;
    }
}

