/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.mapping.AbstractActionEvaluator;
import org.alfresco.cmis.mapping.PermissionActionEvaluator;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanCheckOutActionEvaluator
extends AbstractActionEvaluator<NodeRef> {
    private PermissionActionEvaluator permissionEvaluator;
    private NodeService nodeService;
    private LockService lockService;

    protected CanCheckOutActionEvaluator(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, CMISAllowedActionEnum.CAN_CHECKOUT);
        this.permissionEvaluator = new PermissionActionEvaluator(serviceRegistry, CMISAllowedActionEnum.CAN_CHECKOUT, "CheckOut");
        this.nodeService = serviceRegistry.getNodeService();
        this.lockService = serviceRegistry.getLockService();
    }

    @Override
    public boolean isAllowed(NodeRef nodeRef) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) || this.lockService.getLockType(nodeRef) == LockType.READ_ONLY_LOCK) {
            return false;
        }
        return this.permissionEvaluator.isAllowed(nodeRef);
    }
}

