/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import java.io.File;
import java.io.IOException;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.DesktopActionException;
import org.alfresco.filesys.alfresco.DesktopParams;
import org.alfresco.filesys.alfresco.DesktopResponse;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.pseudo.LocalPseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.util.ResourceFinder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigElement;

public abstract class DesktopAction {
    protected static final Log logger = LogFactory.getLog(DesktopAction.class);
    public static final int AttrTargetFiles = 1;
    public static final int AttrTargetFolders = 2;
    public static final int AttrClientFiles = 4;
    public static final int AttrClientFolders = 8;
    public static final int AttrAlfrescoFiles = 16;
    public static final int AttrAlfrescoFolders = 32;
    public static final int AttrMultiplePaths = 64;
    public static final int AttrAllowNoParams = 128;
    public static final int AttrAnyFiles = 21;
    public static final int AttrAnyFolders = 42;
    public static final int AttrAnyFilesFolders = 63;
    public static final int PreCopyToTarget = 1;
    public static final int PreConfirmAction = 2;
    public static final int PreLocalToWorkingCopy = 4;
    public static final int StsSuccess = 0;
    public static final int StsError = 1;
    public static final int StsFileNotFound = 2;
    public static final int StsAccessDenied = 3;
    public static final int StsBadParameter = 4;
    public static final int StsNotWorkingCopy = 5;
    public static final int StsNoSuchAction = 6;
    public static final int StsLaunchURL = 7;
    public static final int StsCommandLine = 8;
    public static final int StsAuthTicket = 9;
    private String m_name;
    private PseudoFile m_pseudoFile;
    private String m_filename;
    private String m_path;
    private int m_attributes;
    private int m_clientPreActions;
    private AlfrescoDiskDriver m_filesysDriver;
    private AlfrescoContext m_filesysContext;
    private String m_webappURL;
    private boolean m_debug;

    protected DesktopAction() {
    }

    protected DesktopAction(int attr, int preActions) {
        this.setAttributes(attr);
        this.setPreProcessActions(preActions);
    }

    protected DesktopAction(String name) {
        this.m_name = name;
    }

    public final int getAttributes() {
        return this.m_attributes;
    }

    public final boolean hasAttribute(int attr) {
        return (this.m_attributes & attr) != 0;
    }

    public final int getPreProcessActions() {
        return this.m_clientPreActions;
    }

    public final boolean hasPreProcessAction(int pre) {
        return (this.m_clientPreActions & pre) != 0;
    }

    public final String getName() {
        return this.m_name;
    }

    public final boolean hasPseudoFile() {
        return this.m_pseudoFile != null;
    }

    public final PseudoFile getPseudoFile() {
        return this.m_pseudoFile;
    }

    public final AlfrescoDiskDriver getDriver() {
        return this.m_filesysDriver;
    }

    public final AlfrescoContext getContext() {
        return this.m_filesysContext;
    }

    public String getConfirmationString() {
        return null;
    }

    public final ServiceRegistry getServiceRegistry() {
        return this.m_filesysDriver.getServiceRegistry();
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasWebappURL() {
        return this.m_webappURL != null;
    }

    public final String getWebappURL() {
        return this.m_webappURL;
    }

    public void initializeAction(ConfigElement global, ConfigElement config, DiskSharedDevice fileSys) throws DesktopActionException {
        if (!(fileSys.getContext() instanceof AlfrescoContext)) {
            throw new DesktopActionException("Desktop action requires an Alfresco filesystem driver");
        }
        this.standardInitialize(global, config, fileSys);
        this.initializeAction((AlfrescoDiskDriver)fileSys.getDiskInterface(), (AlfrescoContext)fileSys.getDiskContext());
    }

    public void standardInitialize(ConfigElement global, ConfigElement config, DiskSharedDevice fileSys) throws DesktopActionException {
        ConfigElement debug;
        ConfigElement webURL;
        ConfigElement elem = config.getChild("name");
        if (elem == null || elem.getValue().length() <= 0) {
            throw new DesktopActionException("Desktop action name not specified");
        }
        this.setName(elem.getValue());
        ConfigElement name = config.getChild("filename");
        if (name == null || name.getValue() == null || name.getValue().length() == 0) {
            throw new DesktopActionException("Desktop action pseudo name not specified");
        }
        this.setFilename(name.getValue());
        ConfigElement path = this.findConfigElement("path", global, config);
        if (path == null || path.getValue() == null || path.getValue().length() == 0) {
            throw new DesktopActionException("Desktop action executable path not specified");
        }
        this.setPath(path.getValue());
        if (this.findConfigElement("noConfirm", global, config) != null && this.hasPreProcessAction(2)) {
            this.setPreProcessActions(this.getPreProcessActions() - 2);
        }
        if ((webURL = this.findConfigElement("webpath", global, config)) != null && webURL.getValue() != null && webURL.getValue().length() > 0) {
            this.setWebappURL(webURL.getValue());
        }
        if ((debug = this.findConfigElement("debug", global, config)) != null) {
            this.setDebug(true);
        }
    }

    public void initializeAction(AlfrescoDiskDriver filesysDriver, AlfrescoContext filesysContext) throws DesktopActionException {
        this.m_filesysDriver = filesysDriver;
        this.m_filesysContext = filesysContext;
        if (this.m_name == null || this.m_name.length() == 0) {
            throw new DesktopActionException("Desktop action name not specified");
        }
        if (this.m_pseudoFile == null) {
            File appFile;
            if (this.m_filename == null || this.m_filename.length() == 0) {
                throw new DesktopActionException("Desktop action pseudo name not specified");
            }
            if (this.m_path == null || this.m_path.length() == 0) {
                this.m_path = this.m_filesysContext.getGlobalDesktopActionConfig().getPath();
            }
            if (this.m_path == null || this.m_path.length() == 0) {
                throw new DesktopActionException("Desktop action executable path not specified");
            }
            Resource resource = new ResourceFinder().getResource(this.m_path);
            if (!resource.exists()) {
                throw new DesktopActionException("Failed to find drag and drop application, " + this.m_path);
            }
            try {
                appFile = resource.getFile();
                if (!appFile.exists()) {
                    throw new DesktopActionException("Drag and drop application not found, " + appFile);
                }
            }
            catch (IOException e) {
                throw new DesktopActionException("Unable to resolve drag and drop application as a file, " + resource.getDescription());
            }
            LocalPseudoFile pseudoFile = new LocalPseudoFile(this.m_filename, appFile.getAbsolutePath());
            this.setPseudoFile((PseudoFile)pseudoFile);
        }
        if (this.m_filesysContext.getGlobalDesktopActionConfig().getNoConfirm() && this.hasPreProcessAction(2)) {
            this.setPreProcessActions(this.getPreProcessActions() - 2);
        }
        SysAdminParams sysAdminParams = this.m_filesysContext.getSysAdminParams();
        if (this.m_webappURL == null || this.m_webappURL.length() == 0) {
            this.m_webappURL = this.m_filesysContext.getURLPrefix();
        } else {
            this.m_webappURL = sysAdminParams.subsituteHost(this.m_webappURL);
            if (!this.m_webappURL.endsWith("/")) {
                this.m_webappURL = this.m_webappURL + "/";
            }
        }
        if (this.m_filesysContext.getGlobalDesktopActionConfig().getDebug()) {
            this.setDebug(true);
        }
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Initialized desktop action " + this.getName() + ", pseudo name " + this.m_pseudoFile.getFileName()));
        }
    }

    private final ConfigElement findConfigElement(String name, ConfigElement global, ConfigElement local) {
        ConfigElement elem = local.getChild(name);
        if (elem == null && global != null) {
            elem = global.getChild(name);
        }
        return elem;
    }

    public abstract DesktopResponse runAction(DesktopParams var1) throws DesktopActionException;

    protected final void setAttributes(int attr) {
        this.m_attributes = attr;
    }

    public final void setPreProcessActions(int pre) {
        this.m_clientPreActions = pre;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final void setPseudoFile(PseudoFile pseudoFile) {
        this.m_pseudoFile = pseudoFile;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final void setWebappURL(String urlStr) {
        this.m_webappURL = urlStr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DesktopAction) {
            DesktopAction action = (DesktopAction)obj;
            return action.getName().equals(this.getName());
        }
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append(":Attr=0x");
        str.append(Integer.toHexString(this.getAttributes()));
        str.append(":Pre=0x");
        str.append(Integer.toHexString(this.getPreProcessActions()));
        if (this.hasPseudoFile()) {
            str.append(":Pseudo=");
            str.append(this.getPseudoFile().getFileName());
        }
        str.append("]");
        return str.toString();
    }
}

