/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth.nfs;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.filesys.AlfrescoConfigSection;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.auth.nfs.UserMapping;
import org.alfresco.jlan.oncrpc.AuthType;
import org.alfresco.jlan.oncrpc.RpcAuthenticationException;
import org.alfresco.jlan.oncrpc.RpcAuthenticator;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoRpcAuthenticator
implements RpcAuthenticator,
InitializingBean {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.nfs.protocol.auth");
    private int[] _authTypes = new int[]{1};
    private HashMap<Integer, String> m_idMap;
    private List<UserMapping> userMappings;
    private AuthenticationComponent authenticationComponent;
    private AuthenticationService authenticationService;
    private TransactionService transactionService;

    public void setUserMappings(List<UserMapping> userMappings) {
        this.userMappings = userMappings;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public Object authenticateRpcClient(int authType, RpcPacket rpc) throws RpcAuthenticationException {
        Long sessKey = null;
        if (authType == 1) {
            Integer idKey;
            String userName;
            rpc.positionAtCredentialsData();
            rpc.skipBytes(4);
            int nameLen = rpc.unpackInt();
            rpc.skipBytes(nameLen);
            int uid = rpc.unpackInt();
            int gid = rpc.unpackInt();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RpcAuth: Type=Unix uid=" + uid + ", gid=" + gid));
            }
            if ((userName = this.m_idMap.get(idKey = new Integer((gid << 16) + uid))) == null) {
                throw new RpcAuthenticationException(13);
            }
            sessKey = new Long(((long)rpc.getClientAddress().hashCode() << 32) + (long)(gid << 16) + (long)uid);
        }
        if (sessKey == null) {
            throw new RpcAuthenticationException(1, "Unsupported auth type, " + authType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RpcAuth: RPC from " + rpc.getClientDetails() + ", authType=" + AuthType.getTypeAsString((int)authType) + ", sessKey=" + sessKey));
        }
        return sessKey;
    }

    public int[] getRpcAuthenticationTypes() {
        return this._authTypes;
    }

    public ClientInfo getRpcClientInformation(Object sessKey, RpcPacket rpc) {
        ClientInfo cInfo = null;
        int authType = rpc.getCredentialsType();
        if (authType == 1) {
            rpc.positionAtCredentialsData();
            rpc.skipBytes(4);
            String clientAddr = rpc.unpackString();
            int uid = rpc.unpackInt();
            int gid = rpc.unpackInt();
            int grpLen = rpc.unpackInt();
            int[] groups = null;
            if (grpLen > 0) {
                groups = new int[grpLen];
                rpc.unpackIntArray(groups);
            }
            Integer idKey = new Integer((gid << 16) + uid);
            String userName = this.m_idMap.get(idKey);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RpcClientInfo: username=" + userName + ", uid=" + uid + ", gid=" + gid));
            }
            if (userName != null) {
                cInfo = ClientInfo.getFactory().createInfo(userName, null);
                cInfo.setNFSAuthenticationType(authType);
                cInfo.setClientAddress(clientAddr);
                cInfo.setUid(uid);
                cInfo.setGid(gid);
                cInfo.setGroupsList(groups);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RpcAuth: Client info, type=" + AuthType.getTypeAsString((int)authType) + ", name=" + clientAddr + ", uid=" + uid + ", gid=" + gid + ", groups=" + grpLen));
            }
        } else if (authType == 0) {
            cInfo = ClientInfo.getFactory().createInfo("", null);
            cInfo.setClientAddress(rpc.getClientAddress().getHostAddress());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RpcAuth: Client info, type=" + AuthType.getTypeAsString((int)authType) + ", addr=" + rpc.getClientAddress().getHostAddress()));
            }
        }
        return cInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(SrvSession sess, ClientInfo client) {
        UserTransaction tx = this.createTransaction();
        try {
            tx.begin();
            if (client == null || client.isNullSession() || !(client instanceof AlfrescoClientInfo)) {
                this.getAuthenticationComponent().clearCurrentSecurityContext();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Clear security context, client=" + client));
                }
            } else if (!client.isGuest()) {
                AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                if (!alfClient.hasAuthenticationTicket()) {
                    this.getAuthenticationComponent().setCurrentUser(client.getUserName());
                    alfClient.setAuthenticationTicket(this.getAuthenticationService().getCurrentTicket());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Set user name=" + client.getUserName() + ", ticket=" + alfClient.getAuthenticationTicket()));
                    }
                } else {
                    this.getAuthenticationService().validate(alfClient.getAuthenticationTicket());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Set user using auth ticket, ticket=" + alfClient.getAuthenticationTicket()));
                    }
                }
            } else {
                this.getAuthenticationComponent().setGuestUserAsCurrentUser();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Set guest user");
                }
            }
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)ex);
            }
        }
        finally {
            if (tx != null) {
                try {
                    if (tx.getStatus() == 1) {
                        tx.rollback();
                    } else {
                        tx.commit();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        AlfrescoConfigSection alfrescoConfig = (AlfrescoConfigSection)config.getConfigSection("Alfresco");
        this.setAuthenticationComponent(alfrescoConfig.getAuthenticationComponent());
        this.setAuthenticationService(alfrescoConfig.getAuthenticationService());
        this.setTransactionService(alfrescoConfig.getTransactionService());
        ConfigElement userMappings = params.getChild("userMappings");
        if (userMappings != null) {
            LinkedList<UserMapping> mappings = new LinkedList<UserMapping>();
            List userMaps = userMappings.getChildren();
            for (ConfigElement userElem : userMaps) {
                if (!userElem.getName().equalsIgnoreCase("user")) continue;
                String userName = userElem.getAttribute("name");
                String uidStr = userElem.getAttribute("uid");
                String gidStr = userElem.getAttribute("gid");
                if (userName == null || userName.length() == 0) {
                    throw new InvalidConfigurationException("Empty user name, or name not specified");
                }
                if (uidStr == null || uidStr.length() == 0) {
                    throw new InvalidConfigurationException("Invalid uid, or uid not specified, for user " + userName);
                }
                if (gidStr == null || gidStr.length() == 0) {
                    throw new InvalidConfigurationException("Invalid gid, or gid not specified, for user " + userName);
                }
                int uid = -1;
                int gid = -1;
                try {
                    uid = Integer.parseInt(uidStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid uid value, " + uidStr + " for user " + userName);
                }
                try {
                    gid = Integer.parseInt(gidStr);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Invalid gid value, " + gidStr + " for user " + userName);
                }
                mappings.add(new UserMapping(userName, uid, gid));
            }
            this.setUserMappings(mappings);
        }
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() throws InvalidConfigurationException {
        if (this.userMappings != null) {
            this.m_idMap = new HashMap(this.userMappings.size() * 2);
            for (UserMapping userElem : this.userMappings) {
                String userName = userElem.getName();
                if (userName == null || userName.length() == 0) {
                    throw new InvalidConfigurationException("Empty user name, or name not specified");
                }
                Integer idKey = new Integer((userElem.getGid() << 16) + userElem.getUid());
                if (!this.m_idMap.containsKey(idKey)) {
                    this.m_idMap.put(idKey, userName);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Added RPC user mapping for user " + userName + " uid=" + userElem.getUid() + ", gid=" + userElem.getGid()));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignored duplicate mapping for uid=" + userElem.getUid() + ", gid=" + userElem.getGid()));
            }
        }
        if (this.m_idMap == null || this.m_idMap.size() == 0) {
            throw new InvalidConfigurationException("No user mappings for RPC authenticator");
        }
    }

    protected final UserTransaction createTransaction() {
        TransactionService txService = this.getTransactionService();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using " + (txService.isReadOnly() ? "ReadOnly" : "Write") + " transaction"));
        }
        return txService.getUserTransaction(txService.isReadOnly());
    }

    protected AuthenticationComponent getAuthenticationComponent() {
        return this.authenticationComponent;
    }

    protected AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    protected TransactionService getTransactionService() {
        return this.transactionService;
    }
}

