/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentDiskDriver;
import org.alfresco.filesys.repo.CreateNodeEvent;
import org.alfresco.filesys.repo.DeleteNodeEvent;
import org.alfresco.filesys.repo.LockNodeEvent;
import org.alfresco.filesys.repo.MoveNodeEvent;
import org.alfresco.filesys.repo.NodeEvent;
import org.alfresco.filesys.repo.NodeEventQueue;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.smb.server.notify.NotifyChangeHandler;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMonitor
extends TransactionListenerAdapter
implements NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
Runnable {
    private static final Log logger = LogFactory.getLog(NodeMonitor.class);
    public static final String FileSysNodeEvent = "FileSysNodeEvent";
    public static final String FileSysNodeEvent2 = "FileSysNodeEvent2";
    private PolicyComponent m_policyComponent;
    private NodeService m_nodeService;
    private FileFolderService m_fileFolderService;
    private PermissionService m_permissionService;
    private TransactionService m_transService;
    private ContentDiskDriver m_filesysDriver;
    private ContentContext m_filesysCtx;
    private FileStateCache m_stateTable;
    private NotifyChangeHandler m_changeHandler;
    private String m_rootPath;
    private StoreRef m_storeRef;
    private NodeEventQueue m_eventQueue;
    private Thread m_thread;
    private boolean m_shutdown;

    protected NodeMonitor(ContentDiskDriver filesysDriver, ContentContext filesysCtx, NodeService nodeService, PolicyComponent policyComponent, FileFolderService fileFolderService, PermissionService permissionService, TransactionService transService) {
        this.m_filesysDriver = filesysDriver;
        this.m_filesysCtx = filesysCtx;
        this.m_nodeService = nodeService;
        this.m_policyComponent = policyComponent;
        this.m_fileFolderService = fileFolderService;
        this.m_permissionService = permissionService;
        this.m_transService = transService;
        this.init();
    }

    public final void init() {
        this.m_filesysCtx.setFileServerNotifications(false);
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), this, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), this, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onMoveNode"), this, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.m_policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.m_storeRef = this.m_filesysCtx.getRootNode().getStoreRef();
        String rootPath = (String)((Object)this.m_nodeService.getProperty(this.m_filesysCtx.getRootNode(), ContentModel.PROP_NAME));
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("/");
        if (rootPath != null && rootPath.length() > 0) {
            pathBuilder.append(rootPath);
        }
        this.m_rootPath = pathBuilder.toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node monitor filesystem=" + this.m_filesysCtx.getDeviceName() + ", rootPath=" + this.m_rootPath));
        }
        this.m_eventQueue = new NodeEventQueue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Node monitor installed for " + this.m_filesysCtx.getDeviceName()));
        }
    }

    public void startMonitor() {
        this.m_stateTable = this.m_filesysCtx.getStateCache();
        this.m_changeHandler = this.m_filesysCtx.getChangeHandler();
        this.m_thread = new Thread(this);
        this.m_thread.setName("NodeMonitor_" + this.m_filesysCtx.getDeviceName());
        this.m_thread.setDaemon(true);
        this.m_thread.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("NodeMonitor started, " + this.m_thread.getName()));
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (!nodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(nodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            if (logger.isDebugEnabled()) {
                Path nodePath = this.m_nodeService.getPath(nodeRef);
                String fName = (String)((Object)this.m_nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                logger.debug((Object)("OnCreateNode: nodeRef=" + nodeRef + ", name=" + fName + ", path=" + nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService)));
            }
            CreateNodeEvent nodeEvent = new CreateNodeEvent(fType, nodeRef);
            AlfrescoTransactionSupport.bindListener(this);
            AlfrescoTransactionSupport.bindResource(FileSysNodeEvent, nodeEvent);
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (!nodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(nodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            LockNodeEvent nodeEvent = null;
            String beforeLock = (String)((Object)before.get(ContentModel.PROP_LOCK_TYPE));
            String afterLock = (String)((Object)after.get(ContentModel.PROP_LOCK_TYPE));
            if (beforeLock != null && afterLock == null || beforeLock == null && afterLock != null) {
                nodeEvent = new LockNodeEvent(fType, nodeRef, beforeLock, afterLock);
            }
            if (nodeEvent != null) {
                String eventKey = FileSysNodeEvent;
                if (AlfrescoTransactionSupport.getResource(FileSysNodeEvent) != null) {
                    eventKey = FileSysNodeEvent2;
                }
                AlfrescoTransactionSupport.bindListener(this);
                AlfrescoTransactionSupport.bindResource(eventKey, nodeEvent);
            }
        }
    }

    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isArchivedNode) {
        NodeEvent nodeEvent = (NodeEvent)AlfrescoTransactionSupport.getResource(FileSysNodeEvent);
        if (nodeEvent != null && nodeEvent instanceof DeleteNodeEvent) {
            DeleteNodeEvent deleteEvent = (DeleteNodeEvent)nodeEvent;
            NodeRef nodeRef = childAssocRef.getChildRef();
            if (nodeRef.equals((Object)deleteEvent.getNodeRef())) {
                deleteEvent.setDeleteConfirm(true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("OnDeleteNode: confirm delete nodeRef=" + nodeRef));
                }
            }
        }
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef oldNodeRef = oldChildAssocRef.getChildRef();
        if (!oldNodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(oldNodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            Path nodePath = this.m_nodeService.getPath(oldNodeRef);
            String fName = (String)((Object)this.m_nodeService.getProperty(oldNodeRef, ContentModel.PROP_NAME));
            StringBuilder pathStr = new StringBuilder();
            pathStr.append(nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService));
            if (pathStr.charAt(pathStr.length() - 1) != '/' && pathStr.charAt(pathStr.length() - 1) != '\\') {
                pathStr.append("\\");
            }
            pathStr.append(fName);
            String relPath = pathStr.toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OnMoveNode: nodeRef=" + oldNodeRef + ", relPath=" + relPath));
            }
            if (relPath.startsWith(this.m_rootPath)) {
                MoveNodeEvent nodeEvent = new MoveNodeEvent(fType, oldNodeRef, relPath, newChildAssocRef.getChildRef());
                AlfrescoTransactionSupport.bindListener(this);
                AlfrescoTransactionSupport.bindResource(FileSysNodeEvent, nodeEvent);
            }
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (!nodeRef.getStoreRef().equals((Object)this.m_storeRef)) {
            return;
        }
        QName nodeType = this.m_nodeService.getType(nodeRef);
        FileFolderServiceType fType = this.m_fileFolderService.getType(nodeType);
        if (fType != FileFolderServiceType.INVALID) {
            Path nodePath = this.m_nodeService.getPath(nodeRef);
            String fName = (String)((Object)this.m_nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            StringBuilder pathStr = new StringBuilder();
            pathStr.append(nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService));
            if (pathStr.length() == 0 || pathStr.charAt(pathStr.length() - 1) != '/' && pathStr.charAt(pathStr.length() - 1) != '\\') {
                pathStr.append("\\");
            }
            pathStr.append(fName);
            String relPath = pathStr.toString();
            if (relPath.startsWith(this.m_rootPath)) {
                DeleteNodeEvent nodeEvent = new DeleteNodeEvent(fType, nodeRef, relPath);
                AlfrescoTransactionSupport.bindListener(this);
                AlfrescoTransactionSupport.bindResource(FileSysNodeEvent, nodeEvent);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("BeforeDeleteNode: nodeRef=" + nodeRef + ", relPath=" + relPath));
                }
            }
        }
    }

    public final void shutdownRequest() {
        if (this.m_thread != null) {
            this.m_shutdown = true;
            try {
                this.m_thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void afterCommit() {
        NodeEvent nodeEvent = (NodeEvent)AlfrescoTransactionSupport.getResource(FileSysNodeEvent);
        if (nodeEvent != null) {
            this.m_eventQueue.addEvent(nodeEvent);
            AlfrescoTransactionSupport.unbindResource(FileSysNodeEvent);
            nodeEvent = (NodeEvent)AlfrescoTransactionSupport.getResource(FileSysNodeEvent2);
            if (nodeEvent != null) {
                this.m_eventQueue.addEvent(nodeEvent);
                AlfrescoTransactionSupport.unbindResource(FileSysNodeEvent2);
            }
        }
    }

    @Override
    public void run() {
        this.m_shutdown = false;
        AuthenticationContext authenticationContext = this.m_filesysDriver.getAuthenticationContext();
        authenticationContext.setSystemUserAsCurrentUser();
        while (!this.m_shutdown) {
            try {
                final NodeEvent nodeEvent = this.m_eventQueue.removeEvent();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing event " + nodeEvent));
                }
                if (this.m_shutdown) continue;
                RetryingTransactionHelper.RetryingTransactionCallback<Object> processEventCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Throwable {
                        if (nodeEvent == null) {
                            return null;
                        }
                        if (nodeEvent instanceof DeleteNodeEvent) {
                            NodeMonitor.this.processDeleteNode((DeleteNodeEvent)nodeEvent);
                        } else if (!NodeMonitor.this.m_nodeService.exists(nodeEvent.getNodeRef())) {
                            return null;
                        }
                        if (nodeEvent instanceof CreateNodeEvent) {
                            NodeMonitor.this.processCreateNode((CreateNodeEvent)nodeEvent);
                        } else if (nodeEvent instanceof MoveNodeEvent) {
                            NodeMonitor.this.processMoveNode((MoveNodeEvent)nodeEvent);
                        } else if (nodeEvent instanceof LockNodeEvent) {
                            NodeMonitor.this.processLockNode((LockNodeEvent)nodeEvent);
                        }
                        return null;
                    }
                };
                this.m_transService.getRetryingTransactionHelper().doInTransaction(processEventCallback, true, true);
            }
            catch (InterruptedException ex) {
            }
            catch (Throwable e) {
                logger.error((Object)e);
            }
        }
    }

    private final void processCreateNode(NodeEvent createEvent) {
        Path nodePath = this.m_nodeService.getPath(createEvent.getNodeRef());
        String relPath = nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService);
        String fName = (String)((Object)this.m_nodeService.getProperty(createEvent.getNodeRef(), ContentModel.PROP_NAME));
        if (relPath.startsWith(this.m_rootPath)) {
            FileState fState;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("CreateNode nodeRef=" + createEvent.getNodeRef() + ", fName=" + fName + ", path=" + relPath));
            }
            StringBuilder fullPath = new StringBuilder();
            fullPath.append(relPath.substring(this.m_rootPath.length()));
            fullPath.append("/");
            fullPath.append(fName);
            relPath = fullPath.toString();
            if (this.m_stateTable != null && (fState = this.m_stateTable.findFileState(relPath)) != null && !fState.exists()) {
                if (createEvent.getFileType() == FileFolderServiceType.FILE) {
                    fState.setFileStatus(1);
                } else {
                    fState.setFileStatus(2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("CreateNode updated file state - " + fState));
                }
            }
            if (this.m_changeHandler != null && this.m_changeHandler.getGlobalNotifyMask() != 0) {
                if (createEvent.getFileType() == FileFolderServiceType.FILE) {
                    this.m_changeHandler.notifyFileChanged(1, relPath);
                } else {
                    this.m_changeHandler.notifyDirectoryChanged(1, relPath);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"CreateNode queued change notification");
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("CreateNode ignored nodeRef=" + createEvent.getNodeRef() + ", path=" + relPath));
        }
    }

    private final void processDeleteNode(DeleteNodeEvent deleteEvent) {
        FileState fState;
        if (!deleteEvent.hasDeleteConfirm()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DeleteNode not confirmed, nodeRef=" + deleteEvent.getNodeRef() + ", path=" + deleteEvent.getPath()));
            }
            return;
        }
        String relPath = deleteEvent.getPath().substring(this.m_rootPath.length()).replace('/', '\\');
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DeleteNode nodeRef=" + deleteEvent.getNodeRef() + ", path=" + relPath));
        }
        if (this.m_stateTable != null && (fState = this.m_stateTable.findFileState(relPath)) != null && fState.exists()) {
            fState.setFileStatus(0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DeleteNode updated file state - " + fState));
            }
        }
        if (this.m_changeHandler != null && this.m_changeHandler.getGlobalNotifyMask() != 0) {
            if (deleteEvent.getFileType() == FileFolderServiceType.FILE) {
                this.m_changeHandler.notifyFileChanged(2, relPath);
            } else {
                this.m_changeHandler.notifyDirectoryChanged(2, relPath);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"DeleteNode queued change notification");
            }
        }
    }

    private final void processMoveNode(MoveNodeEvent moveEvent) {
        String fromPath = moveEvent.getPath().substring(this.m_rootPath.length()).replace('/', '\\');
        Path nodePath = this.m_nodeService.getPath(moveEvent.getMoveToNodeRef());
        String fName = (String)((Object)this.m_nodeService.getProperty(moveEvent.getMoveToNodeRef(), ContentModel.PROP_NAME));
        StringBuilder pathStr = new StringBuilder();
        pathStr.append(nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService));
        if (pathStr.charAt(pathStr.length() - 1) != '/' && pathStr.charAt(pathStr.length() - 1) != '\\') {
            pathStr.append("\\");
        }
        pathStr.append(fName);
        String toPath = pathStr.toString().substring(this.m_rootPath.length()).replace('/', '\\');
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MoveNode fromPath=" + fromPath + ", toPath=" + toPath));
        }
        if (this.m_stateTable != null) {
            FileState fState = this.m_stateTable.findFileState(fromPath);
            if (fState != null && fState.exists()) {
                fState.setFileStatus(0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MoveNode updated state for fromPath=" + fromPath));
                }
            }
            if ((fState = this.m_stateTable.findFileState(toPath)) != null && !fState.exists()) {
                if (moveEvent.getFileType() == FileFolderServiceType.FILE) {
                    fState.setFileStatus(1);
                } else {
                    fState.setFileStatus(2);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MoveNode updated state for toPath=" + toPath));
                }
            }
        }
        if (this.m_changeHandler != null && this.m_changeHandler.getGlobalNotifyMask() != 0) {
            this.m_changeHandler.notifyRename(fromPath, toPath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"MoveNode queued change notification");
            }
        }
    }

    private final void processLockNode(LockNodeEvent lockEvent) {
        Path nodePath = this.m_nodeService.getPath(lockEvent.getNodeRef());
        String relPath = nodePath.toDisplayPath(this.m_nodeService, this.m_permissionService);
        String fName = (String)((Object)this.m_nodeService.getProperty(lockEvent.getNodeRef(), ContentModel.PROP_NAME));
        if (relPath.startsWith(this.m_rootPath)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("LockNode nodeRef=" + lockEvent.getNodeRef() + ", fName=" + fName + ", path=" + relPath));
            }
            StringBuilder fullPath = new StringBuilder();
            fullPath.append(relPath.substring(this.m_rootPath.length()));
            fullPath.append("/");
            fullPath.append(fName);
            relPath = fullPath.toString().replace('/', '\\');
            if (this.m_changeHandler != null) {
                this.m_changeHandler.notifyAttributesChanged(relPath, lockEvent.getFileType() != FileFolderServiceType.FILE);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"LockNode queued change notification");
                }
            }
        }
    }
}

