/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.util;

import java.util.NoSuchElementException;
import javax.jcr.RangeIterator;

public abstract class AbstractRangeIterator
implements RangeIterator {
    private int position = -1;

    protected long skip() {
        this.skip(1L);
        return this.position;
    }

    public void skip(long skipNum) {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must be positive.");
        }
        if ((long)this.position + skipNum >= this.getSize()) {
            throw new NoSuchElementException("Cannot skip " + skipNum + " elements from position " + this.getPosition() + " as only " + this.getSize() + " elements are available.");
        }
        this.position = (int)((long)this.position + skipNum);
    }

    public long getPosition() {
        return this.position + 1;
    }

    public boolean hasNext() {
        return this.getPosition() < this.getSize();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

