/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashMap;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionServiceImplTest;
import org.alfresco.repo.action.ActionTrackingServiceImpl;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.ExecutionDetails;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ConfigurableApplicationContext;

public class ActionTrackingServiceImplTest
extends TestCase {
    private static ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private NodeRef folder;
    private NodeService nodeService;
    private ActionService actionService;
    private ScriptService scriptService;
    private TransactionService transactionService;
    private RuntimeActionService runtimeActionService;
    private ActionTrackingService actionTrackingService;
    private SimpleCache<String, ExecutionDetails> executingActionsCache;

    protected void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.scriptService = (ScriptService)ctx.getBean("scriptService");
        this.actionService = (ActionService)ctx.getBean("actionService");
        this.runtimeActionService = (RuntimeActionService)ctx.getBean("actionService");
        this.actionTrackingService = (ActionTrackingService)ctx.getBean("actionTrackingService");
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.executingActionsCache = (SimpleCache)ctx.getBean("executingActionsCache");
        AuthenticationUtil.setRunAsUserSystem();
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        this.folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        txn.commit();
        this.executingActionsCache.clear();
        ((ActionTrackingServiceImpl)this.actionTrackingService).resetNextExecutionId();
        ActionServiceImplTest.SleepActionExecuter.registerIfNeeded(ctx);
    }

    public void testCreateCacheKeys() throws Exception {
        ActionImpl action = (ActionImpl)this.createWorkingSleepAction("1234");
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)action.getActionDefinitionName());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)action.getId());
        ActionTrackingServiceImplTest.assertEquals((int)-1, (int)action.getExecutionInstance());
        action.setExecutionInstance(1);
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action=1234=1", (String)key);
        ExecutionSummary s = new ExecutionSummary("sleep-action", "1234", 1);
        key = ActionTrackingServiceImpl.generateCacheKey(s);
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action=1234=1", (String)key);
    }

    public void testExecutionDetailsSummary() throws Exception {
        Action action = this.createWorkingSleepAction("1234");
        ((ActionImpl)action).setExecutionInstance(1);
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        ExecutionSummary s = ActionTrackingServiceImpl.buildExecutionSummary(action);
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)s.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)s.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)s.getExecutionInstance());
        s = ActionTrackingServiceImpl.buildExecutionSummary(key);
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)s.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)s.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)s.getExecutionInstance());
        ExecutionDetails d = ActionTrackingServiceImpl.buildExecutionDetails(action);
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getExecutionSummary());
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)d.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)d.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)d.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getPersistedActionRef());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getStartedAt());
        InetAddress localhost = InetAddress.getLocalHost();
        String machineName = localhost.getHostAddress() + " : " + localhost.getHostName();
        ActionTrackingServiceImplTest.assertEquals((String)machineName, (String)d.getRunningOn());
    }

    public void testExecutionInstanceAssignment() throws Exception {
        ActionImpl action = (ActionImpl)this.createWorkingSleepAction("1234");
        ActionTrackingServiceImplTest.assertEquals((int)-1, (int)action.getExecutionInstance());
        this.actionTrackingService.recordActionExecuting(action);
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)action.getExecutionInstance());
        this.actionTrackingService.recordActionExecuting(action);
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)action.getExecutionInstance());
        this.actionTrackingService.recordActionExecuting(action);
        ActionTrackingServiceImplTest.assertEquals((int)3, (int)action.getExecutionInstance());
    }

    public void testInOutCache() throws Exception {
        Action action = this.createWorkingSleepAction("1234");
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionComplete(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionFailure(action, new Exception("Testing"));
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals((String)"Testing", (String)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionPending(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        ExecutionSummary s = ActionTrackingServiceImpl.buildExecutionSummary(action);
        ExecutionDetails d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getExecutionSummary());
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)d.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)d.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)d.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getPersistedActionRef());
        ActionTrackingServiceImplTest.assertNull(null, (Object)d.getStartedAt());
        this.actionTrackingService.recordActionExecuting(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Running), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        s = ActionTrackingServiceImpl.buildExecutionSummary(action);
        d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getExecutionSummary());
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)d.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)d.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)d.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getPersistedActionRef());
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)d.getStartedAt());
        this.actionTrackingService.recordActionComplete(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionExecuting(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionFailure(action, new Exception("Testing"));
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals((String)"Testing", (String)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        ((ActionImpl)action).setExecutionStatus(ActionStatus.New);
        ((ActionImpl)action).setExecutionStartDate(null);
        ((ActionImpl)action).setExecutionEndDate(null);
        ((ActionImpl)action).setExecutionFailureMessage(null);
        ((ActionImpl)action).setExecutionInstance(-1);
        this.actionTrackingService.recordActionExecuting(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Running), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertTrue((((ActionImpl)action).getExecutionInstance() != -1 ? 1 : 0) != 0);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionComplete(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
    }

    public void testWorkingActions() throws Exception {
        ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)ctx.getBean("sleep-action");
        sleepActionExec.resetTimesExecuted();
        sleepActionExec.setSleepMs(10000);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        Action action = this.createWorkingSleepAction("54321");
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionService.executeAction(action, this.nodeRef, false, true);
        txn.commit();
        Thread.sleep(150L);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        System.out.println("Checking the cache for " + key);
        ActionTrackingServiceImplTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key)));
        ExecutionSummary s = ActionTrackingServiceImpl.buildExecutionSummary(action);
        ExecutionDetails d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getExecutionSummary());
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)d.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"54321", (String)d.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)d.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getPersistedActionRef());
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)d.getStartedAt());
        sleepActionExec.getExecutingThread().interrupt();
        Thread.sleep(100L);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d);
    }

    public void testFailingActions() throws Exception {
        ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)ctx.getBean("sleep-action");
        sleepActionExec.setSleepMs(10000);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        Action action = this.createFailingSleepAction("54321");
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionService.executeAction(action, this.nodeRef, false, true);
        txn.commit();
        Thread.sleep(150L);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        System.out.println("Checking the cache for " + key);
        ActionTrackingServiceImplTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key)));
        ExecutionSummary s = ActionTrackingServiceImpl.buildExecutionSummary(action);
        ExecutionDetails d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getExecutionSummary());
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)d.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"54321", (String)d.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)d.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getPersistedActionRef());
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)d.getStartedAt());
        sleepActionExec.getExecutingThread().interrupt();
        Thread.sleep(100L);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals((String)"Bang!", (String)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d);
    }

    public void testPendingActions() throws Exception {
        Action action = this.createWorkingSleepAction("1234");
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        String key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionPending(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        ExecutionSummary s = ActionTrackingServiceImpl.buildExecutionSummary(action);
        ExecutionDetails d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getExecutionSummary());
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)d.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)d.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)d.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getPersistedActionRef());
        ActionTrackingServiceImplTest.assertNull(null, (Object)d.getStartedAt());
        this.actionTrackingService.recordActionExecuting(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Running), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        s = ActionTrackingServiceImpl.buildExecutionSummary(action);
        d = this.actionTrackingService.getExecutionDetails(s);
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getExecutionSummary());
        ActionTrackingServiceImplTest.assertEquals((String)"sleep-action", (String)d.getActionType());
        ActionTrackingServiceImplTest.assertEquals((String)"1234", (String)d.getActionId());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)d.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals(null, (Object)d.getPersistedActionRef());
        ActionTrackingServiceImplTest.assertNotNull((Object)d.getStartedAt());
        this.actionTrackingService.recordActionComplete(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        action = this.createWorkingSleepAction("1234");
        this.actionTrackingService.recordActionPending(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.executingActionsCache.remove((Serializable)((Object)key));
        ActionTrackingServiceImplTest.assertNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        int instanceId = ((ActionImpl)action).getExecutionInstance();
        this.actionTrackingService.recordActionExecuting(action);
        ActionTrackingServiceImplTest.assertEquals((String)key, (String)ActionTrackingServiceImpl.generateCacheKey(action));
        ActionTrackingServiceImplTest.assertEquals((int)instanceId, (int)((ActionImpl)action).getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Running), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertNotNull(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
        this.actionTrackingService.recordActionComplete(action);
        key = ActionTrackingServiceImpl.generateCacheKey(action);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals(null, (Object)this.executingActionsCache.get((Serializable)((Object)key)));
    }

    public void testListings() throws Exception {
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions(this.createWorkingSleepAction(null)).size());
        Action sleepAction1 = this.createWorkingSleepAction("12345");
        Action sleepAction2 = this.createWorkingSleepAction("54321");
        Action moveAction = this.createFailingMoveAction();
        this.actionTrackingService.recordActionExecuting(sleepAction1);
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(sleepAction1).size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions(sleepAction2).size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions(moveAction).size());
        this.actionTrackingService.recordActionExecuting(moveAction);
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(sleepAction1).size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions(sleepAction2).size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(moveAction).size());
        this.actionTrackingService.recordActionExecuting(sleepAction2);
        ActionTrackingServiceImplTest.assertEquals((int)3, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(sleepAction1).size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(sleepAction2).size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(moveAction).size());
        this.actionTrackingService.recordActionComplete(sleepAction2);
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(sleepAction1).size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions(sleepAction2).size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(moveAction).size());
        this.actionTrackingService.recordActionComplete(sleepAction1);
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions(sleepAction1).size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions(sleepAction2).size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(moveAction).size());
        this.runtimeActionService.saveActionImpl(this.nodeRef, sleepAction1);
        ((ActionTrackingServiceImpl)this.actionTrackingService).resetNextExecutionId();
        ActionImpl sa11 = (ActionImpl)this.runtimeActionService.createAction(this.nodeRef);
        ActionImpl sa12 = (ActionImpl)this.runtimeActionService.createAction(this.nodeRef);
        ActionImpl sa13 = (ActionImpl)this.runtimeActionService.createAction(this.nodeRef);
        sa11 = new ActionImpl(sa11, "sleep-action");
        sa12 = new ActionImpl(sa12, "sleep-action");
        sa13 = new ActionImpl(sa13, "sleep-action");
        this.actionTrackingService.recordActionExecuting(sa11);
        this.actionTrackingService.recordActionExecuting(sa12);
        this.actionTrackingService.recordActionExecuting(sa13);
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)sa11.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)sa12.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals((int)3, (int)sa13.getExecutionInstance());
        ActionTrackingServiceImplTest.assertEquals((int)4, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)3, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)1, (int)this.actionTrackingService.getExecutingActions(moveAction).size());
        ActionTrackingServiceImplTest.assertEquals((int)3, (int)this.actionTrackingService.getExecutingActions(sa11).size());
        ActionTrackingServiceImplTest.assertEquals((int)3, (int)this.actionTrackingService.getExecutingActions(sa12).size());
        ActionTrackingServiceImplTest.assertEquals((int)3, (int)this.actionTrackingService.getExecutingActions(sa13).size());
        this.actionTrackingService.recordActionComplete(sa13);
        this.actionTrackingService.recordActionComplete(moveAction);
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getAllExecutingActions().size());
        ActionTrackingServiceImplTest.assertEquals((int)0, (int)this.actionTrackingService.getExecutingActions("test").size());
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getExecutingActions("sleep-action").size());
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getExecutingActions(sa11).size());
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getExecutingActions(sa12).size());
        ActionTrackingServiceImplTest.assertEquals((int)2, (int)this.actionTrackingService.getExecutingActions(sa13).size());
    }

    public void testCancellation() throws Exception {
        ActionServiceImplTest.CancellableSleepAction sleepAction1 = (ActionServiceImplTest.CancellableSleepAction)this.createWorkingSleepAction(null);
        ActionServiceImplTest.CancellableSleepAction sleepAction2 = (ActionServiceImplTest.CancellableSleepAction)this.createWorkingSleepAction(null);
        this.actionTrackingService.recordActionExecuting(sleepAction1);
        this.actionTrackingService.recordActionExecuting(sleepAction2);
        ActionTrackingServiceImplTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction1));
        ActionTrackingServiceImplTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction2));
        this.actionTrackingService.requestActionCancellation(sleepAction1);
        ActionTrackingServiceImplTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction1));
        ActionTrackingServiceImplTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction2));
        ExecutionSummary s2 = ActionTrackingServiceImpl.buildExecutionSummary(sleepAction2);
        this.actionTrackingService.requestActionCancellation(s2);
        ActionTrackingServiceImplTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction1));
        ActionTrackingServiceImplTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction2));
        ActionServiceImplTest.CancellableSleepAction sleepAction3 = (ActionServiceImplTest.CancellableSleepAction)this.createWorkingSleepAction(null);
        String key3 = ActionTrackingServiceImpl.generateCacheKey(sleepAction3);
        ActionTrackingServiceImplTest.assertNull((Object)this.executingActionsCache.get((Serializable)((Object)key3)));
        ActionTrackingServiceImplTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction3));
        ActionTrackingServiceImplTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key3)));
        this.executingActionsCache.remove((Serializable)((Object)key3));
        ActionTrackingServiceImplTest.assertNull((Object)this.executingActionsCache.get((Serializable)((Object)key3)));
        ActionTrackingServiceImplTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction3));
        ActionTrackingServiceImplTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key3)));
        this.actionTrackingService.requestActionCancellation(sleepAction3);
        ActionTrackingServiceImplTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction3));
        ActionTrackingServiceImplTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key3)));
        ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)ctx.getBean("sleep-action");
        sleepActionExec.setSleepMs(10000);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.executingActionsCache.remove((Serializable)((Object)key3));
        this.actionService.executeAction(sleepAction3, this.nodeRef, false, true);
        txn.commit();
        Thread.sleep(150L);
        key3 = ActionTrackingServiceImpl.generateCacheKey(sleepAction3);
        ExecutionSummary s3 = ActionTrackingServiceImpl.buildExecutionSummary(key3);
        ActionTrackingServiceImplTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction3));
        ActionTrackingServiceImplTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.getExecutionDetails(s3).isCancelRequested());
        ActionTrackingServiceImplTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key3)));
        this.actionTrackingService.requestActionCancellation(sleepAction3);
        ActionTrackingServiceImplTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested(sleepAction3));
        ActionTrackingServiceImplTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.getExecutionDetails(s3).isCancelRequested());
        ActionTrackingServiceImplTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key3)));
        sleepActionExec.getExecutingThread().interrupt();
        Thread.sleep(150L);
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Cancelled), (Object)((Object)sleepAction3.getExecutionStatus()));
        ActionTrackingServiceImplTest.assertEquals(null, (String)sleepAction3.getExecutionFailureMessage());
    }

    public void testExecutionTrackingOnExecution() throws Exception {
        ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)ctx.getBean("sleep-action");
        sleepActionExec.setSleepMs(10);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        Action action = this.createWorkingSleepAction(null);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        this.actionService.executeAction(action, this.nodeRef);
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        action = this.createFailingMoveAction();
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        try {
            this.actionService.executeAction(action, this.nodeRef);
            ActionTrackingServiceImplTest.fail((String)"Action should have failed, and the error been thrown");
        }
        catch (Exception e) {
            // empty catch block
        }
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        txn.rollback();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        action = this.createWorkingSleepAction(null);
        this.actionService.saveAction(this.nodeRef, action);
        NodeRef actionNode = action.getNodeRef();
        ActionTrackingServiceImplTest.assertNotNull((Object)actionNode);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        this.actionService.executeAction(action, this.nodeRef);
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        action = this.runtimeActionService.createAction(actionNode);
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        action = this.createFailingMoveAction();
        this.actionService.saveAction(this.nodeRef, action);
        actionNode = action.getNodeRef();
        String actionId = action.getId();
        ActionTrackingServiceImplTest.assertNotNull((Object)actionNode);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        try {
            this.actionService.executeAction(action, this.nodeRef);
            ActionTrackingServiceImplTest.fail((String)"Action should have failed, and the error been thrown");
        }
        catch (Exception e) {
            // empty catch block
        }
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        txn.rollback();
        Thread.sleep(150L);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        action = this.runtimeActionService.createAction(actionNode);
        ActionTrackingServiceImplTest.assertEquals((String)actionId, (String)action.getId());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        action = this.createWorkingSleepAction(null);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        this.actionService.executeAction(action, this.nodeRef, false, true);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)action.getExecutionStatus()));
        txn.commit();
        Thread.sleep(150L);
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        action = this.createFailingMoveAction();
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        this.actionService.executeAction(action, this.nodeRef, false, true);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)action.getExecutionStatus()));
        txn.commit();
        Thread.sleep(150L);
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        action = this.createWorkingSleepAction(null);
        this.actionService.saveAction(this.nodeRef, action);
        actionNode = action.getNodeRef();
        ActionTrackingServiceImplTest.assertNotNull((Object)actionNode);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        this.actionService.executeAction(action, this.nodeRef, false, true);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)action.getExecutionStatus()));
        txn.commit();
        Thread.sleep(150L);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        action = this.runtimeActionService.createAction(actionNode);
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Completed), (Object)((Object)action.getExecutionStatus()));
        action = this.createFailingMoveAction();
        this.actionService.saveAction(this.nodeRef, action);
        actionNode = action.getNodeRef();
        ActionTrackingServiceImplTest.assertNotNull((Object)actionNode);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.New), (Object)((Object)action.getExecutionStatus()));
        this.actionService.executeAction(action, this.nodeRef, false, true);
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionTrackingServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Pending), (Object)((Object)action.getExecutionStatus()));
        txn.commit();
        Thread.sleep(350L);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
        action = this.runtimeActionService.createAction(actionNode);
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionStartDate());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionStartDate(), action.getExecutionEndDate());
        ActionServiceImplTest.assertBefore(action.getExecutionEndDate(), new Date());
        ActionTrackingServiceImplTest.assertNotNull((Object)action.getExecutionFailureMessage());
        ActionTrackingServiceImplTest.assertEquals((Object)((Object)ActionStatus.Failed), (Object)((Object)action.getExecutionStatus()));
    }

    public void testJavascriptAPI() throws Exception {
        ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)ctx.getBean("sleep-action");
        sleepActionExec.setSleepMs(2000);
        ((ActionTrackingServiceImpl)this.actionTrackingService).resetNextExecutionId();
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ActionImpl sleepAction = (ActionImpl)this.createWorkingSleepAction(null);
        sleepAction.setNodeRef(this.nodeRef);
        this.actionService.executeAction(sleepAction, null, false, true);
        txn.commit();
        ActionImpl action = (ActionImpl)this.createFailingMoveAction();
        this.actionTrackingService.recordActionExecuting(action);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        action = (ActionImpl)this.createWorkingSleepAction(null);
        action.setExecutionStartDate(new Date(1234L));
        action.setExecutionEndDate(new Date(54321L));
        action.setExecutionStatus(ActionStatus.Failed);
        this.actionService.saveAction(this.nodeRef, action);
        txn.commit();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("NodeRef", this.nodeRef.toString());
        model.put("SleepAction", sleepAction);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/action/script/test_actionTrackingService.js");
        this.scriptService.executeScript(location, model);
    }

    private Action createFailingMoveAction() {
        Action failingAction = this.actionService.createAction("move");
        failingAction.setParameterValue("assoc-type", (Serializable)ContentModel.ASSOC_CHILDREN);
        failingAction.setParameterValue("assoc-name", (Serializable)ContentModel.ASSOC_CHILDREN);
        NodeRef badNodeRef = new NodeRef(this.storeRef, "123123");
        failingAction.setParameterValue("destination-folder", (Serializable)badNodeRef);
        return failingAction;
    }

    private Action createFailingSleepAction(String id) throws Exception {
        return ActionServiceImplTest.createFailingSleepAction(id, this.actionService);
    }

    private Action createWorkingSleepAction(String id) throws Exception {
        return ActionServiceImplTest.createWorkingSleepAction(id, this.actionService);
    }
}

