/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsAspect
implements CopyServicePolicies.OnCopyNodePolicy,
CopyServicePolicies.OnCopyCompletePolicy {
    private PolicyComponent policyComponent;
    private BehaviourFilter behaviourFilter;
    private RuleService ruleService;
    private NodeService nodeService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"ruleService", (Object)this.ruleService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ActionModel.ASPECT_ACTIONS, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCopyComplete"), ActionModel.ASPECT_ACTIONS, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ActionModel.ASPECT_ACTIONS, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.ruleService.disableRules(nodeRef);
        try {
            this.nodeService.createNode(nodeRef, ActionModel.ASSOC_ACTION_FOLDER, ActionModel.ASSOC_ACTION_FOLDER, ContentModel.TYPE_SYSTEM_FOLDER);
            Object var4_3 = null;
            this.ruleService.enableRules(nodeRef);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ruleService.enableRules(nodeRef);
            throw throwable;
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return new ActionsAspectCopyBehaviourCallback(this.behaviourFilter);
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef destinationRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        this.behaviourFilter.enableBehaviour(sourceNodeRef, ActionModel.ASPECT_ACTIONS);
    }

    private static class ActionsAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private final BehaviourFilter behaviourFilter;

        private ActionsAspectCopyBehaviourCallback(BehaviourFilter behaviourFilter) {
            this.behaviourFilter = behaviourFilter;
        }

        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            NodeRef targetNodeRef = copyDetails.getTargetNodeRef();
            this.behaviourFilter.disableBehaviour(targetNodeRef, ActionModel.ASPECT_ACTIONS);
            return true;
        }

        public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            ChildAssociationRef childAssocRef = childAssocCopyDetails.getChildAssocRef();
            if (childAssocRef.getTypeQName().equals((Object)ActionModel.ASSOC_ACTION_FOLDER)) {
                return CopyBehaviourCallback.ChildAssocCopyAction.COPY_CHILD;
            }
            throw new IllegalStateException("Behaviour should have been invoked: \n   Aspect: " + this.getClass().getName() + "\n" + "   " + childAssocCopyDetails + "\n" + "   " + copyDetails);
        }
    }
}

