/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.repo.activities.feed.JobSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedTaskSplit {
    private static Log logger = LogFactory.getLog(FeedTaskSplit.class);

    public Collection<JobSettings> split(int gridSize, JobSettings splitSettings) {
        long minSequence;
        long maxSequence = splitSettings.getMaxSeq();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("split: start - gridSize = " + gridSize + ", maxSequence = " + maxSequence));
        }
        splitSettings.setMinSeq((minSequence = maxSequence - (long)splitSettings.getMaxItemsPerCycle() + 1L) >= 0L ? minSequence : 0L);
        ArrayList<JobSettings> jobs = new ArrayList<JobSettings>(gridSize);
        int maxNodeHash = splitSettings.getJobTaskNode();
        for (int n = 1; n <= maxNodeHash; ++n) {
            JobSettings jobSettings = splitSettings.clone();
            jobSettings.setJobTaskNode(n);
            jobs.add(jobSettings);
        }
        return jobs;
    }
}

