/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.local;

import com.ibatis.sqlmap.client.SqlMapClient;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.activities.feed.FeedTaskProcessor;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.repo.domain.activities.FeedControlDAO;
import org.alfresco.repo.domain.activities.FeedControlEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.ClassPathRepoTemplateLoader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFeedTaskProcessor
extends FeedTaskProcessor
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(LocalFeedTaskProcessor.class);
    private ActivityPostDAO postDAO;
    private ActivityFeedDAO feedDAO;
    private FeedControlDAO feedControlDAO;
    private SiteService siteService;
    private NodeService nodeService;
    private ContentService contentService;
    private String defaultEncoding;
    private List<String> templateSearchPaths;
    private boolean useRemoteCallbacks;
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private SqlMapClient sqlMapper;

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setFeedDAO(ActivityFeedDAO feedDAO) {
        this.feedDAO = feedDAO;
    }

    public void setFeedControlDAO(FeedControlDAO feedControlDAO) {
        this.feedControlDAO = feedControlDAO;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setTemplateSearchPaths(List<String> templateSearchPaths) {
        this.templateSearchPaths = templateSearchPaths;
    }

    public void setUseRemoteCallbacks(boolean useRemoteCallbacks) {
        this.useRemoteCallbacks = useRemoteCallbacks;
    }

    public void setSqlMapClient(SqlMapClient sqlMapper) {
        this.sqlMapper = sqlMapper;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resolver = applicationContext;
    }

    @Override
    public void startTransaction() throws SQLException {
        this.sqlMapper.startTransaction();
    }

    @Override
    public void commitTransaction() throws SQLException {
        this.sqlMapper.commitTransaction();
    }

    @Override
    public void endTransaction() throws SQLException {
        this.sqlMapper.endTransaction();
    }

    @Override
    public List<ActivityPostEntity> selectPosts(ActivityPostEntity selector) throws SQLException {
        return this.postDAO.selectPosts(selector);
    }

    @Override
    public long insertFeedEntry(ActivityFeedEntity feed) throws SQLException {
        return this.feedDAO.insertFeedEntry(feed);
    }

    @Override
    public int updatePostStatus(long id, ActivityPostEntity.STATUS status) throws SQLException {
        return this.postDAO.updatePostStatus(id, status);
    }

    @Override
    public List<FeedControlEntity> selectUserFeedControls(String userId) throws SQLException {
        return this.feedControlDAO.selectFeedControls(userId);
    }

    @Override
    protected Set<String> getSiteMembers(final RepoCtx ctx, final String siteId) throws Exception {
        if (this.useRemoteCallbacks) {
            return super.getSiteMembers(ctx, siteId);
        }
        return (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<String>>(){

            public Set<String> doWork() throws Exception {
                Map<String, String> mapResult;
                HashSet<String> members = new HashSet<String>();
                if (siteId != null && siteId.length() != 0 && (mapResult = LocalFeedTaskProcessor.this.siteService.listMembers(siteId, null, null, 0, true)) != null && mapResult.size() != 0) {
                    for (String userName : mapResult.keySet()) {
                        if (!ctx.isUserNamesAreCaseSensitive()) {
                            userName = userName.toLowerCase();
                        }
                        members.add(userName);
                    }
                }
                return members;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected Map<String, List<String>> getActivityTypeTemplates(String repoEndPoint, String ticket, String subPath) throws Exception {
        int idx;
        if (this.useRemoteCallbacks) {
            return super.getActivityTypeTemplates(repoEndPoint, ticket, subPath);
        }
        String path = "/";
        String templatePattern = "*.ftl";
        if (subPath != null && subPath.length() > 0 && (idx = (subPath = subPath + "*").lastIndexOf("/")) != -1) {
            path = subPath.substring(0, idx);
            templatePattern = subPath.substring(idx + 1) + ".ftl";
        }
        List<String> allTemplateNames = this.getDocumentPaths(path, false, templatePattern);
        return this.getActivityTemplates(allTemplateNames);
    }

    @Override
    protected Configuration getFreemarkerConfiguration(RepoCtx ctx) {
        if (this.useRemoteCallbacks) {
            return super.getFreemarkerConfiguration(ctx);
        }
        Configuration cfg = new Configuration();
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setTemplateLoader((TemplateLoader)new ClassPathRepoTemplateLoader(this.nodeService, this.contentService, this.defaultEncoding));
        cfg.setLocalizedLookup(false);
        return cfg;
    }

    private List<String> getDocumentPaths(String path, boolean includeSubPaths, String documentPattern) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (documentPattern == null || documentPattern.length() == 0) {
            documentPattern = "*";
        }
        ArrayList<String> documentPaths = new ArrayList<String>(0);
        for (String classPath : this.templateSearchPaths) {
            StringBuilder pattern = new StringBuilder(128);
            pattern.append("classpath*:").append(classPath).append(path).append(includeSubPaths ? "**/" : "").append(documentPattern);
            try {
                documentPaths.addAll(this.getPaths(pattern.toString(), classPath));
            }
            catch (IOException e) {}
        }
        return documentPaths;
    }

    private List<String> getPaths(String pattern, String classPath) throws IOException {
        Resource[] resources = this.resolver.getResources(pattern);
        ArrayList<String> documentPaths = new ArrayList<String>(resources.length);
        for (Resource resource : resources) {
            String resourcePath = resource.getURL().toExternalForm();
            int idx = resourcePath.lastIndexOf(classPath);
            if (idx == -1) continue;
            String documentPath = resourcePath.substring(idx);
            documentPath = documentPath.replace('\\', '/');
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Item resource path: " + resourcePath + " , item path: " + documentPath));
            }
            documentPaths.add(documentPath);
        }
        return documentPaths;
    }
}

