/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.extensions.surf.util.I18NUtil;

public class AVMWebProjectInheritPermissionsPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.avmWebProjectInheritPermissions.result";
    private ImporterBootstrap spacesImporterBootstrap;
    private IndexerAndSearcher indexerAndSearcher;
    private PermissionService permissionService;

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    public void setSpacesImporterBootstrap(ImporterBootstrap spacesImporterBootstrap) {
        this.spacesImporterBootstrap = spacesImporterBootstrap;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applyInternal() throws Exception {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"wca:webfolder\"");
        sp.addStore(this.spacesImporterBootstrap.getStoreRef());
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            for (ResultSetRow row : rs) {
                this.permissionService.setInheritParentPermissions(row.getNodeRef(), false);
                List userInfoRefs = this.nodeService.getChildAssocs(row.getNodeRef(), (QNamePattern)WCMAppModel.ASSOC_WEBUSER, RegexQNamePattern.MATCH_ALL);
                for (ChildAssociationRef ref : userInfoRefs) {
                    NodeRef userInfoRef = ref.getChildRef();
                    String username = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERNAME));
                    String userrole = (String)((Object)this.nodeService.getProperty(userInfoRef, WCMAppModel.PROP_WEBUSERROLE));
                    if (!"ContentManager".equals(userrole)) continue;
                    this.permissionService.setPermission(row.getNodeRef(), username, "ContentManager", true);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS);
    }
}

