/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import com.ibatis.sqlmap.client.event.RowHandler;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateAttrPropBackedBeanPatch
extends AbstractPatch {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String ROOT_KEY_PBB = ".PropertyBackedBeans";
    private static final String MSG_SUCCESS = "patch.migrateAttrPropBackedBeans.result";
    private AttributeService attributeService;
    private PatchDAO patchDAO;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    protected String applyInternal() throws Exception {
        long startTime = System.currentTimeMillis();
        PBBRowHandler handler = new PBBRowHandler();
        this.patchDAO.migrateOldAttrPropertyBackedBeans(handler);
        handler.setComponent(handler.currentComponentName, handler.attributeMap);
        if (handler.total > 0) {
            this.logger.info((Object)("Processed " + handler.total + " Property-Backed Component attrs (" + handler.totalProps + " props) in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{handler.total, handler.totalProps});
        return msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PBBRowHandler
    implements RowHandler {
        private int total = 0;
        private int totalProps = 0;
        private Map<String, String> attributeMap = new HashMap<String, String>(10);
        private String currentComponentName = "";

        private PBBRowHandler() {
        }

        public void handleRow(Object valueObject) {
            Map result = (Map)valueObject;
            String componentName = (String)result.get("componentName");
            String propName = (String)result.get("propName");
            String propValue = (String)result.get("propValue");
            if (!this.currentComponentName.equals(componentName)) {
                this.setComponent(this.currentComponentName, this.attributeMap);
                this.currentComponentName = componentName;
                this.attributeMap.clear();
            }
            this.attributeMap.put(propName, propValue);
            ++this.totalProps;
            if (MigrateAttrPropBackedBeanPatch.this.logger.isTraceEnabled()) {
                MigrateAttrPropBackedBeanPatch.this.logger.trace((Object)("Read PBB [componentName=" + componentName + ", propName=" + propName + ", propValue=" + propValue + "]"));
            }
        }

        public void setComponent(String componentName, Map<String, String> attributeMap) {
            if (componentName.equals("") || attributeMap.size() == 0) {
                return;
            }
            MigrateAttrPropBackedBeanPatch.this.attributeService.setAttribute((Serializable)((Object)attributeMap), new Serializable[]{MigrateAttrPropBackedBeanPatch.ROOT_KEY_PBB, componentName});
            if (MigrateAttrPropBackedBeanPatch.this.logger.isTraceEnabled()) {
                MigrateAttrPropBackedBeanPatch.this.logger.trace((Object)("Set PBB component attr [name=" + componentName + ", attributeMap=" + attributeMap + "]"));
            }
            ++this.total;
            if (MigrateAttrPropBackedBeanPatch.this.logger.isDebugEnabled() && (this.total == 0 || this.total % 1000 == 0)) {
                MigrateAttrPropBackedBeanPatch.this.logger.debug((Object)("   Handled " + this.total + " Chaining URS attrs"));
            }
        }
    }
}

