/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

public class QNamePatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.QNamePatch.result";
    private String qnameStringBefore;
    private String qnameStringAfter;
    private String reindexClass;
    private ImporterBootstrap importerBootstrap;
    private IndexerAndSearcher indexerAndSearcher;
    private QNameDAO qnameDAO;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setQnameBefore(String qnameStringBefore) {
        this.qnameStringBefore = qnameStringBefore;
    }

    public void setQnameAfter(String qnameStringAfter) {
        this.qnameStringAfter = qnameStringAfter;
    }

    public void setReindexClass(String reindexClass) {
        this.reindexClass = reindexClass;
    }

    protected String applyInternal() throws Exception {
        QName qnameBefore = QName.createQName((String)this.qnameStringBefore);
        QName qnameAfter = QName.createQName((String)this.qnameStringAfter);
        if (this.qnameDAO.getQName(qnameBefore) != null) {
            this.qnameDAO.updateQName(qnameBefore, qnameAfter);
        }
        if ("TYPE".equals(this.reindexClass) || "ASPECT".equals(this.reindexClass)) {
            this.reindex(this.reindexClass + ":" + LuceneQueryParser.escape((String)this.qnameStringBefore), this.importerBootstrap.getStoreRef());
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{qnameBefore, qnameAfter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int reindex(String query, StoreRef store) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery(query);
        sp.addStore(store);
        Indexer indexer = this.indexerAndSearcher.getIndexer(store);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = this.searchService.query(sp);
            count = rs.length();
            for (ResultSetRow row : rs) {
                indexer.updateNode(row.getNodeRef());
            }
            Object var10_9 = null;
            if (rs == null) return count;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return count;
    }
}

