/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.net.URL;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.audit.generator.DataGenerator;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.audit.model.AuditModelException;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PathMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ResourceUtils;

public class AuditBootstrapTest
extends TestCase {
    private static final String APPLICATION_TEST = "Alfresco Test";
    private static final String KEY_TEST = "test";
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static final Log logger = LogFactory.getLog(AuditBootstrapTest.class);
    private AuditModelRegistryImpl auditModelRegistry;

    public void setUp() throws Exception {
        this.auditModelRegistry = (AuditModelRegistryImpl)ctx.getBean("auditModel.modelRegistry");
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
    }

    protected void tearDown() throws Exception {
        this.auditModelRegistry.destroy();
    }

    public void testSetUp() {
    }

    private void loadBadModel(String url) throws Exception {
        try {
            URL testModelUrl = ResourceUtils.getURL((String)url);
            this.auditModelRegistry.registerModel(testModelUrl);
            this.auditModelRegistry.loadAuditModels();
            AuditBootstrapTest.fail((String)"Expected model loading to fail.");
        }
        catch (AuditModelException e) {
            logger.error((Object)("Expected AuditModelException: " + e.getMessage()));
        }
    }

    public void testModelLoading_NoDataExtractor() throws Exception {
        this.loadBadModel("classpath:alfresco/testaudit/alfresco-audit-test-bad-01.xml");
    }

    public void testModelLoading_NoDataGenerator() throws Exception {
        this.loadBadModel("classpath:alfresco/testaudit/alfresco-audit-test-bad-02.xml");
    }

    public void testModelLoading_DuplicatePath() throws Exception {
        this.loadBadModel("classpath:alfresco/testaudit/alfresco-audit-test-bad-03.xml");
    }

    public void testModelLoading_UppercasePath() throws Exception {
        this.loadBadModel("classpath:alfresco/testaudit/alfresco-audit-test-bad-04.xml");
    }

    public void testModelLoading_InvalidDataGeneratorName() throws Exception {
        this.loadBadModel("classpath:alfresco/testaudit/alfresco-audit-test-bad-05.xml");
    }

    public void testModelLoading_BadGeneratorRegisteredName() throws Exception {
        this.loadBadModel("classpath:alfresco/testaudit/alfresco-audit-test-bad-06.xml");
    }

    public void testGetApplicationId() {
        AuditApplication app = this.auditModelRegistry.getAuditApplicationByName(APPLICATION_TEST);
        AuditBootstrapTest.assertNotNull((Object)app);
        Long appId = app.getApplicationId();
        AuditBootstrapTest.assertNotNull((String)"No audit application ID for Alfresco Test", (Object)appId);
    }

    public void testGetApplications() {
        Map<String, AuditApplication> apps = this.auditModelRegistry.getAuditApplications();
        AuditBootstrapTest.assertTrue((String)"Application map not complete", (boolean)apps.containsKey(APPLICATION_TEST));
    }

    public void testGetApplicationByKey() {
        AuditApplication app = this.auditModelRegistry.getAuditApplicationByKey(KEY_TEST);
        AuditBootstrapTest.assertNotNull((Object)app);
    }

    public void testGetPathMappings() {
        PathMapper pathMapper = this.auditModelRegistry.getAuditPathMapper();
        AuditBootstrapTest.assertNotNull((Object)pathMapper);
        try {
            pathMapper.addPathMap("x", "y");
            AuditBootstrapTest.fail((String)"Should not be allowed to update the path mappings.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void testBadPath(AuditApplication app, String path) {
        try {
            app.checkPath(path);
            AuditBootstrapTest.fail((String)"Expected path check to fail.");
        }
        catch (AuditModelException auditModelException) {
            // empty catch block
        }
    }

    public void testAuditApplication_Path() {
        AuditApplication app = this.auditModelRegistry.getAuditApplicationByName(APPLICATION_TEST);
        AuditBootstrapTest.assertNotNull((Object)app);
        this.testBadPath(app, null);
        this.testBadPath(app, "");
        this.testBadPath(app, KEY_TEST);
        this.testBadPath(app, "/Test");
        this.testBadPath(app, "/test/");
    }

    public void testAuditApplication_GetDataExtractors() {
        AuditApplication app = this.auditModelRegistry.getAuditApplicationByName(APPLICATION_TEST);
        AuditBootstrapTest.assertNotNull((Object)app);
        List<AuditApplication.DataExtractorDefinition> extractors = app.getDataExtractors();
        AuditBootstrapTest.assertNotNull((String)"Should never get a null list", extractors);
        AuditBootstrapTest.assertEquals((String)"Expected 13 extractors", (int)13, (int)extractors.size());
    }

    public void testAuditApplication_GetDataGenerators() {
        AuditApplication app = this.auditModelRegistry.getAuditApplicationByName(APPLICATION_TEST);
        AuditBootstrapTest.assertNotNull((Object)app);
        Map<String, DataGenerator> generators = app.getDataGenerators("/blah");
        AuditBootstrapTest.assertNotNull((String)"Should never get a null map", generators);
        AuditBootstrapTest.assertTrue((String)"Expected no generators", (boolean)generators.isEmpty());
        generators = app.getDataGenerators("/test/1.1/2.1/3.1/4.1");
        AuditBootstrapTest.assertEquals((int)1, (int)generators.size());
        AuditBootstrapTest.assertTrue((boolean)generators.containsKey("/test/time"));
        generators = app.getDataGenerators("/test/1.1/2.1/3.1/4.1");
        AuditBootstrapTest.assertEquals((int)1, (int)generators.size());
        AuditBootstrapTest.assertTrue((boolean)generators.containsKey("/test/time"));
        generators = app.getDataGenerators("/test/1.1/2.2/3.2/4.1");
        AuditBootstrapTest.assertEquals((int)2, (int)generators.size());
        AuditBootstrapTest.assertTrue((boolean)generators.containsKey("/test/time"));
        AuditBootstrapTest.assertTrue((boolean)generators.containsKey("/test/1.1/2.2/3.2/4.1/time"));
    }
}

