/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.audit.model.AuditModelException;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditComponentTest
extends TestCase {
    private static final String APPLICATION_TEST = "Alfresco Test";
    private static final String APPLICATION_ACTIONS_TEST = "Actions Test";
    private static final String APPLICATION_API_TEST = "Test AuthenticationService";
    private static final Log logger = LogFactory.getLog(AuditComponentTest.class);
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuditModelRegistryImpl auditModelRegistry;
    private AuditComponent auditComponent;
    private AuditService auditService;
    private ServiceRegistry serviceRegistry;
    private TransactionService transactionService;
    private NodeService nodeService;
    private NodeRef nodeRef;
    private String user;

    public void setUp() throws Exception {
        this.auditModelRegistry = (AuditModelRegistryImpl)ctx.getBean("auditModel.modelRegistry");
        this.auditComponent = (AuditComponent)ctx.getBean("auditComponent");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.auditService = this.serviceRegistry.getAuditService();
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
        AuthenticationUtil.RunAsWork<NodeRef> testRunAs = new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return AuditComponentTest.this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            }
        };
        this.nodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)testRunAs, (String)AuthenticationUtil.getSystemUserName());
        this.user = "User-" + this.getName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.user);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> resetDisabledPathsCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuditComponentTest.this.auditComponent.resetDisabledPaths(AuditComponentTest.APPLICATION_TEST);
                AuditComponentTest.this.auditComponent.resetDisabledPaths(AuditComponentTest.APPLICATION_ACTIONS_TEST);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(resetDisabledPathsCallback);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
        this.auditModelRegistry.destroy();
    }

    public void testSetUp() {
    }

    public void testAuditWithBadPath() throws Exception {
        this.auditComponent.recordAuditValues("/test", Collections.<String, Serializable>emptyMap());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                try {
                    AuditComponentTest.this.auditComponent.recordAuditValues("test", null);
                    Assert.fail((String)"Failed to detect illegal path");
                }
                catch (AuditModelException e) {
                    // empty catch block
                }
                try {
                    AuditComponentTest.this.auditComponent.recordAuditValues("/test/", null);
                    Assert.fail((String)"Failed to detect illegal path");
                }
                catch (AuditModelException e) {
                    // empty catch block
                }
                Map<String, Serializable> auditedValues = AuditComponentTest.this.auditComponent.recordAuditValues("/bogus", null);
                Assert.assertNotNull(auditedValues);
                Assert.assertTrue((String)"Invalid application should not audit anything", (boolean)auditedValues.isEmpty());
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(testCallback);
    }

    public void testAudit_Basic() throws Exception {
        final RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashMap<String, Serializable> values = new HashMap<String, Serializable>(13);
                values.put("/3.1/4.1", new Long(41L));
                values.put("/3.1/4.2", (Serializable)((Object)"42"));
                values.put("/3.1/4.3", new Date());
                values.put("/3.1/4.4", (Serializable)((Object)""));
                values.put("/3.1/4.5", null);
                AuditComponentTest.this.auditComponent.recordAuditValues("/test/one.one/two.one", values);
                return null;
            }
        };
        AuthenticationUtil.RunAsWork<Void> testRunAs = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                return (Void)AuditComponentTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(testCallback);
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)testRunAs, (String)"SomeOtherUser");
    }

    private Map<String, Serializable> auditTestAction(String action, NodeRef nodeRef, Map<String, Serializable> parameters) {
        final HashMap<String, Object> adjustedValues = new HashMap<String, Object>(parameters.size() * 2);
        adjustedValues.put(AuditApplication.buildPath("context-node"), nodeRef);
        for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
            String paramName = entry.getKey();
            String path = AuditApplication.buildPath(action, "params", paramName);
            adjustedValues.put(path, entry.getValue());
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>> auditCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>>(){

            @Override
            public Map<String, Serializable> execute() throws Throwable {
                String actionPath = AuditApplication.buildPath("actions-test/actions");
                return AuditComponentTest.this.auditComponent.recordAuditValues(actionPath, adjustedValues);
            }
        };
        return this.transactionService.getRetryingTransactionHelper().doInTransaction(auditCallback);
    }

    private void checkAuditMaps(Map<String, Serializable> result, Map<String, Serializable> expected) {
        String failure = EqualsHelper.getMapDifferenceReport(result, expected);
        if (failure != null) {
            AuditComponentTest.fail((String)failure);
        }
    }

    private void auditAction01(String actionName) throws Exception {
        Date valueA = new Date();
        String valueB = "BBB-value-here";
        Float valueC = new Float(16.0f);
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(13);
        parameters.put("A", valueA);
        parameters.put("B", (Serializable)((Object)valueB));
        parameters.put("C", valueC);
        parameters.put("a", valueA);
        parameters.put("b", (Serializable)((Object)valueB));
        parameters.put("c", valueC);
        Map<String, Serializable> result = this.auditTestAction(actionName, this.nodeRef, parameters);
        HashMap<String, Serializable> expected = new HashMap<String, Serializable>();
        expected.put("/actions-test/actions/user", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        expected.put("/actions-test/actions/context-node/noderef", (Serializable)this.nodeRef);
        expected.put("/actions-test/actions/action-01/params/A/value", valueA);
        expected.put("/actions-test/actions/action-01/params/B/value", (Serializable)((Object)valueB));
        expected.put("/actions-test/actions/action-01/params/C/value", valueC);
        this.checkAuditMaps(result, expected);
    }

    public void testAudit_Action01() throws Exception {
        this.auditAction01("action-01");
    }

    public void testAudit_Action01Mapped() throws Exception {
        this.auditAction01("action-01-mapped");
    }

    private void auditAction02(String actionName) throws Exception {
        Date valueA = new Date();
        String valueB = "BBB-value-here";
        Float valueC = new Float(16.0f);
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(13);
        parameters.put("A", valueA);
        parameters.put("B", (Serializable)((Object)valueB));
        parameters.put("C", valueC);
        parameters.put("a", valueA);
        parameters.put("b", (Serializable)((Object)valueB));
        parameters.put("c", valueC);
        Map<String, Serializable> result = this.auditTestAction(actionName, this.nodeRef, parameters);
        HashMap<String, Serializable> expected = new HashMap<String, Serializable>();
        expected.put("/actions-test/actions/user", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        expected.put("/actions-test/actions/context-node/noderef", (Serializable)this.nodeRef);
        expected.put("/actions-test/actions/action-02/valueA", valueA);
        expected.put("/actions-test/actions/action-02/valueB", (Serializable)((Object)valueB));
        expected.put("/actions-test/actions/action-02/valueC", valueC);
        this.checkAuditMaps(result, expected);
    }

    public void testAudit_Action02Sourced() throws Exception {
        this.auditAction02("action-02-sourced");
    }

    public void testQuery_Action01() throws Exception {
        Long beforeTime = new Long(System.currentTimeMillis());
        this.testAudit_Action01();
        final StringBuilder sb = new StringBuilder();
        final MutableInt rowCount = new MutableInt();
        AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            @Override
            public boolean valuesRequired() {
                return true;
            }

            @Override
            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                Assert.assertNotNull((Object)applicationName);
                Assert.assertNotNull((Object)user);
                sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                rowCount.setValue(rowCount.intValue() + 1);
                return true;
            }

            @Override
            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(true);
        params.setApplicationName(APPLICATION_ACTIONS_TEST);
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        this.auditComponent.auditQuery(callback, params, -1);
        AuditComponentTest.assertTrue((String)"Expected some data", (rowCount.intValue() > 0 ? 1 : 0) != 0);
        logger.debug((Object)sb.toString());
        int allResults = rowCount.intValue();
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        this.auditComponent.auditQuery(callback, params, 1);
        AuditComponentTest.assertEquals((String)"Expected to limit data", (int)1, (int)rowCount.intValue());
        logger.debug((Object)sb.toString());
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setToTime(beforeTime);
        this.auditComponent.auditQuery(callback, params, -1);
        params.setToTime(null);
        logger.debug((Object)sb.toString());
        int resultsBefore = rowCount.intValue();
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setFromTime(beforeTime);
        this.auditComponent.auditQuery(callback, params, -1);
        params.setFromTime(null);
        logger.debug((Object)sb.toString());
        int resultsAfter = rowCount.intValue();
        AuditComponentTest.assertEquals((String)"Time-limited queries did not get all results before and after a time", (int)allResults, (int)(resultsBefore + resultsAfter));
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setUser(this.user);
        this.auditComponent.auditQuery(callback, params, -1);
        params.setUser(null);
        AuditComponentTest.assertTrue((String)"Expected some data for specific user", (rowCount.intValue() > 0 ? 1 : 0) != 0);
        logger.debug((Object)sb.toString());
        sb.delete(0, sb.length());
        rowCount.setValue(0);
        params.setUser("Numpty");
        this.auditComponent.auditQuery(callback, params, -1);
        params.setUser(null);
        AuditComponentTest.assertTrue((String)"Expected no data for bogus user", (rowCount.intValue() == 0 ? 1 : 0) != 0);
        logger.debug((Object)sb.toString());
    }

    public void testAudit_EnableDisableAuditPaths() throws Exception {
        Date valueA = new Date();
        String valueB = "BBB-value-here";
        Float valueC = new Float(16.0f);
        final HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(13);
        parameters.put("A", valueA);
        parameters.put("B", (Serializable)((Object)valueB));
        parameters.put("C", valueC);
        parameters.put("a", valueA);
        parameters.put("b", (Serializable)((Object)valueB));
        parameters.put("c", valueC);
        Map<String, Serializable> result = this.auditTestAction("action-01", this.nodeRef, parameters);
        final HashMap<String, Serializable> expected = new HashMap<String, Serializable>();
        expected.put("/actions-test/actions/user", (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
        expected.put("/actions-test/actions/context-node/noderef", (Serializable)this.nodeRef);
        expected.put("/actions-test/actions/action-01/params/A/value", valueA);
        expected.put("/actions-test/actions/action-01/params/B/value", (Serializable)((Object)valueB));
        expected.put("/actions-test/actions/action-01/params/C/value", valueC);
        this.checkAuditMaps(result, expected);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> disableAuditCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashMap expectedInner = new HashMap(expected);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test/actions/action-01/params/A");
                expectedInner.remove("/actions-test/actions/action-01/params/A/value");
                Map result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test/actions/action-01/params/B");
                expectedInner.remove("/actions-test/actions/action-01/params/B/value");
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test");
                expectedInner.clear();
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.enableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test/actions/action-01/params/B");
                expectedInner.clear();
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.enableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, "/actions-test");
                expectedInner = new HashMap(expected);
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.disableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, null);
                expectedInner.clear();
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                AuditComponentTest.this.auditComponent.enableAudit(AuditComponentTest.APPLICATION_ACTIONS_TEST, null);
                expectedInner = new HashMap(expected);
                result = AuditComponentTest.this.auditTestAction("action-01", AuditComponentTest.this.nodeRef, parameters);
                AuditComponentTest.this.checkAuditMaps(result, expectedInner);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(disableAuditCallback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuditAuthenticationService() throws Exception {
        AuditQueryParameters params = new AuditQueryParameters();
        params.setForward(true);
        params.setApplicationName(APPLICATION_API_TEST);
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-authenticationservice.xml");
        this.auditModelRegistry.registerModel(testModelUrl);
        this.auditModelRegistry.loadAuditModels();
        final ArrayList results = new ArrayList();
        final StringBuilder sb = new StringBuilder();
        AuditService.AuditQueryCallback auditQueryCallback = new AuditService.AuditQueryCallback(){

            @Override
            public boolean valuesRequired() {
                return true;
            }

            @Override
            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                results.add(values);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Audit Entry " + entryId + ": " + applicationName + ", " + user + ", " + new Date(time) + "\n" + "   Data: " + values));
                }
                sb.append("Row: ").append(entryId).append(" | ").append(applicationName).append(" | ").append(user).append(" | ").append(new Date(time)).append(" | ").append(values).append(" | ").append("\n");
                return true;
            }

            @Override
            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        this.clearAuditLog(APPLICATION_API_TEST);
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, -1);
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertTrue((String)"There should be no audit entries for the API test after a clear", (boolean)results.isEmpty());
        final MutableAuthenticationService authenticationService = this.serviceRegistry.getAuthenticationService();
        AuthenticationUtil.RunAsWork<Void> createAuthenticationWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (!authenticationService.authenticationExists(AuditComponentTest.this.getName())) {
                    authenticationService.createAuthentication(AuditComponentTest.this.getName(), AuditComponentTest.this.getName().toCharArray());
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createAuthenticationWork, (String)AuthenticationUtil.getSystemUserName());
        this.clearAuditLog(APPLICATION_API_TEST);
        try {
            AuthenticationUtil.pushAuthentication();
            authenticationService.authenticate(this.getName(), this.getName().toCharArray());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, -1);
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertFalse((String)"Did not get any audit results after successful login", (boolean)results.isEmpty());
        this.clearAuditLog(APPLICATION_API_TEST);
        try {
            authenticationService.authenticate("banana", "****".toCharArray());
            AuditComponentTest.fail((String)"Invalid authentication attempt should fail");
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        results.clear();
        sb.delete(0, sb.length());
        this.queryAuditLog(auditQueryCallback, params, -1);
        logger.debug((Object)sb.toString());
        AuditComponentTest.assertFalse((String)"Did not get any audit results after failed login", (boolean)results.isEmpty());
    }

    public void testAuditQuery_MaxId() throws Exception {
        AuditService.AuditQueryCallback auditQueryCallback = new AuditService.AuditQueryCallback(){

            @Override
            public boolean valuesRequired() {
                return true;
            }

            @Override
            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Audit Entry " + entryId + ": " + applicationName + ", " + user + ", " + new Date(time) + "\n" + "   Data: " + values));
                }
                return true;
            }

            @Override
            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(APPLICATION_API_TEST);
        params.setForward(false);
        params.setToId(Long.MAX_VALUE);
        this.queryAuditLog(auditQueryCallback, params, 1);
    }

    private void clearAuditLog(final String applicationName) {
        AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuditComponentTest.this.auditService.clearAudit(applicationName, null, null);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminRoleName());
    }

    private void queryAuditLog(final AuditService.AuditQueryCallback callback, final AuditQueryParameters parameters, final int maxResults) {
        AuthenticationUtil.RunAsWork<Void> work = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                AuditComponentTest.this.auditService.auditQuery(callback, parameters, maxResults);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)work, (String)AuthenticationUtil.getAdminRoleName());
    }
}

