/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditServiceImpl
implements AuditService {
    private AuditComponent auditComponent;

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.auditComponent.isAuditEnabled();
    }

    @Override
    public void setAuditEnabled(boolean enable) {
        this.auditComponent.setAuditEnabled(enable);
    }

    @Override
    public Map<String, AuditService.AuditApplication> getAuditApplications() {
        Map<String, AuditApplication> apps = this.auditComponent.getAuditApplications();
        HashMap<String, AuditService.AuditApplication> ret = new HashMap<String, AuditService.AuditApplication>(apps.size() * 2);
        Iterator<String> i$ = apps.keySet().iterator();
        while (i$.hasNext()) {
            String app;
            String name = app = i$.next();
            String key = "/" + apps.get(app).getApplicationKey();
            boolean enabled = this.auditComponent.isAuditPathEnabled(app, key);
            AuditService.AuditApplication auditApplication = new AuditService.AuditApplication(name, key, enabled);
            ret.put(name, auditApplication);
        }
        return ret;
    }

    @Override
    public boolean isAuditEnabled(String applicationName, String path) {
        return this.auditComponent.isAuditPathEnabled(applicationName, path);
    }

    @Override
    public void enableAudit(String applicationName, String path) {
        this.auditComponent.enableAudit(applicationName, path);
    }

    @Override
    public void disableAudit(String applicationName, String path) {
        this.auditComponent.disableAudit(applicationName, path);
    }

    @Override
    public int clearAudit(String applicationName) {
        Long now = System.currentTimeMillis();
        return this.auditComponent.deleteAuditEntries(applicationName, null, now);
    }

    @Override
    public int clearAudit(String applicationName, Long fromTime, Long toTime) {
        toTime = toTime == null ? Long.valueOf(System.currentTimeMillis()) : toTime;
        return this.auditComponent.deleteAuditEntries(applicationName, fromTime, toTime);
    }

    @Override
    public void auditQuery(AuditService.AuditQueryCallback callback, AuditQueryParameters parameters, int maxResults) {
        this.auditComponent.auditQuery(callback, parameters, maxResults);
    }
}

