/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.List;
import junit.framework.Assert;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.util.GUID;

public class AVMDiffPerformanceTest
extends AVMServiceTestBase {
    public void testSetup() throws Exception {
        super.testSetup();
    }

    public void test_1000() throws Exception {
        this.runTest(1000);
    }

    public void xtest_2000() throws Exception {
        this.runTest(2000);
    }

    private void runTest(final int cnt) throws Exception {
        fTransactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute() throws Throwable {
                try {
                    String name;
                    int i;
                    AVMServiceTestBase.fService.createStore("StagingArea");
                    AVMServiceTestBase.fService.createStore("SandBox");
                    AVMServiceTestBase.fService.createDirectory("StagingArea:/", "www");
                    AVMServiceTestBase.fService.createDirectory("StagingArea:/www", "test");
                    AVMServiceTestBase.fService.createLayeredDirectory("StagingArea:/www", "SandBox:/", "www");
                    long start = System.nanoTime();
                    for (int i2 = 0; i2 < cnt; ++i2) {
                        String name2 = GUID.generate();
                        AVMServiceTestBase.fService.createFile("SandBox:/www", name2).close();
                    }
                    long end = System.nanoTime();
                    System.out.println("Create SandBox:/www in " + (float)(end - start) / 1.0E9f);
                    start = System.nanoTime();
                    for (i = 0; i < cnt; ++i) {
                        name = GUID.generate();
                        AVMServiceTestBase.fService.createFile("SandBox:/www/test", name).close();
                    }
                    end = System.nanoTime();
                    System.out.println("Create SandBox:/www/test in " + (float)(end - start) / 1.0E9f);
                    start = System.nanoTime();
                    for (i = 0; i < cnt; ++i) {
                        name = GUID.generate();
                        AVMServiceTestBase.fService.createFile("StagingArea:/www", name).close();
                    }
                    end = System.nanoTime();
                    System.out.println("Create StagingArea:/www in " + (float)(end - start) / 1.0E9f);
                    start = System.nanoTime();
                    for (i = 0; i < cnt; ++i) {
                        name = GUID.generate();
                        AVMServiceTestBase.fService.createFile("StagingArea:/www/test", name).close();
                    }
                    end = System.nanoTime();
                    System.out.println("Create StagingArea:/www/test in " + (float)(end - start) / 1.0E9f);
                    start = System.nanoTime();
                    List<AVMDifference> diffs = AVMServiceTestBase.fSyncService.compare(-1, "SandBox:/www", -1, "StagingArea:/www", null);
                    end = System.nanoTime();
                    System.out.println("Diff in " + (float)(end - start) / 1.0E9f);
                    Assert.assertEquals((int)(cnt * 2), (int)diffs.size());
                    Object var8_8 = null;
                    AVMServiceTestBase.fService.purgeStore("StagingArea");
                    AVMServiceTestBase.fService.purgeStore("SandBox");
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    AVMServiceTestBase.fService.purgeStore("StagingArea");
                    AVMServiceTestBase.fService.purgeStore("SandBox");
                    throw throwable;
                }
                return null;
            }
        });
    }
}

