/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.RawServices;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;

public class AVMRemoveAllSrcWebappsHandler
extends JBPMSpringActionHandler {
    static final long serialVersionUID = 3004374776252613278L;
    private static Log log = LogFactory.getLog(AVMRemoveAllSrcWebappsHandler.class);
    private AVMService fAVMService;

    protected void initialiseHandler(BeanFactory factory) {
        this.fAVMService = (AVMService)factory.getBean("AVMService");
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AVMRemoveAllSrcWebappsHandler.execute()");
        }
        NodeRef pkg = ((JBPMNode)executionContext.getContextInstance().getVariable("bpm_package")).getNodeRef();
        Pair<Integer, String> pkgPath = AVMNodeConverter.ToAVMVersionPath(pkg);
        Integer version = (Integer)pkgPath.getFirst();
        String www_dir = (String)pkgPath.getSecond();
        String appbase_dir = www_dir + "/" + "avm_webapps";
        if (log.isDebugEnabled()) {
            log.debug((Object)("version:     " + version));
            log.debug((Object)("appbase_dir: " + appbase_dir));
        }
        ApplicationContext springContext = RawServices.Instance().getContext();
        VirtServerRegistry vServerRegistry = (VirtServerRegistry)springContext.getBean("VirtServerRegistry");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending JMX message to shut down workflow webapps");
        }
        vServerRegistry.removeAllWebapps(version.intValue(), appbase_dir, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sent JMX message to shut down workflow webapps");
        }
    }
}

