/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.coci;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class WorkingCopyAspect
implements CopyServicePolicies.OnCopyNodePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private LockService lockService;
    private WorkingCopyAspectCopyBehaviourCallback workingCopyAspectCopyBehaviourCallback = new WorkingCopyAspectCopyBehaviourCallback();

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.TYPE_CMOBJECT, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.ASPECT_WORKING_COPY, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
        NodeRef origNodeRef;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_COPIEDFROM) && (origNodeRef = (NodeRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_COPY_REFERENCE)) != null && !this.lockService.getLockStatus(origNodeRef).equals((Object)LockStatus.NO_LOCK)) {
            this.lockService.unlock(origNodeRef);
        }
    }

    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return this.workingCopyAspectCopyBehaviourCallback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkingCopyAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private WorkingCopyAspectCopyBehaviourCallback() {
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return !classQName.equals((Object)ContentModel.ASPECT_WORKING_COPY);
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            if (classQName.equals((Object)ContentModel.ASPECT_WORKING_COPY)) {
                return Collections.emptyMap();
            }
            if (copyDetails.getSourceNodeAspectQNames().contains(ContentModel.ASPECT_WORKING_COPY)) {
                String newName = null;
                if (copyDetails.isTargetNodeIsNew() && copyDetails.getSourceNodeAspectQNames().contains(ContentModel.ASPECT_COPIEDFROM)) {
                    NodeRef checkedOutFrom = (NodeRef)copyDetails.getSourceNodeProperties().get(ContentModel.PROP_COPY_REFERENCE);
                    if (WorkingCopyAspect.this.nodeService.exists(checkedOutFrom)) {
                        String oldName = (String)((Object)WorkingCopyAspect.this.nodeService.getProperty(checkedOutFrom, ContentModel.PROP_NAME));
                        int extIndex = oldName.lastIndexOf(46);
                        String string = newName = extIndex == -1 ? oldName + "_" + GUID.generate() : oldName.substring(0, extIndex) + "_" + GUID.generate() + oldName.substring(extIndex);
                    }
                }
                if (newName == null) {
                    properties.remove(ContentModel.PROP_NAME);
                } else {
                    properties.put(ContentModel.PROP_NAME, (Serializable)((Object)newName));
                }
                return properties;
            }
            return properties;
        }
    }
}

