/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.content.cleanup.ContentStoreCleaner;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.tools.Repository;
import org.alfresco.tools.ToolException;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.lang.mutable.MutableInt;
import org.springframework.context.ApplicationContext;

public class ContentStoreCleanerScalabilityRunner
extends Repository {
    private VmShutdownListener vmShutdownListener = new VmShutdownListener("ContentStoreCleanerScalabilityRunner");
    private ApplicationContext ctx;
    private NodeHelper nodeHelper;
    private TransactionService transactionService;
    private NodeDAO nodeDAO;
    private ContentStore contentStore;
    private ContentStoreCleaner cleaner;

    public static void main(String[] args) {
        new ContentStoreCleanerScalabilityRunner().start(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int execute() throws ToolException {
        this.ctx = super.getApplicationContext();
        this.nodeHelper = new NodeHelper();
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
        int orphanCount = 1000;
        this.contentStore = new NullContentStore(10000);
        this.loadData(orphanCount);
        System.out.println("Ready to clean store: " + this.contentStore);
        ContentStoreCleanerScalabilityRunner contentStoreCleanerScalabilityRunner = this;
        synchronized (contentStoreCleanerScalabilityRunner) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        long beforeClean = System.currentTimeMillis();
        this.clean();
        long afterClean = System.currentTimeMillis();
        double aveClean = (double)(afterClean - beforeClean) / (double)orphanCount / 1000.0;
        System.out.println();
        System.out.println(String.format("Cleaning took %3f per 1000 content URLs in DB", aveClean));
        return 0;
    }

    private void loadData(final int maxCount) {
        final MutableInt doneCount = new MutableInt(0);
        RetryingTransactionHelper.RetryingTransactionCallback<Integer> makeNodesCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                for (int i = 0; i < 1000; ++i) {
                    String contentUrl = FileContentStore.createNewFileStoreUrl();
                    ContentData contentData = new ContentData(contentUrl, "text/plain", 10L, "UTF-8");
                    ContentStoreCleanerScalabilityRunner.this.nodeHelper.makeNode(contentData);
                    int count = doneCount.intValue();
                    doneCount.setValue(++count);
                    if (count % 1000 == 0) {
                        System.out.println(String.format("   " + new Date() + "Total created: %6d", count));
                    }
                    if (ContentStoreCleanerScalabilityRunner.this.vmShutdownListener.isVmShuttingDown()) break;
                }
                return maxCount;
            }
        };
        int repetitions = (int)Math.floor((double)maxCount / 1000.0);
        for (int i = 0; i < repetitions; ++i) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(makeNodesCallback);
        }
    }

    private void clean() {
        ContentStoreCleanerListener listener = new ContentStoreCleanerListener(){
            private int count = 0;

            public void beforeDelete(ContentStore store, String contentUrl) throws ContentIOException {
                ++this.count;
                if (this.count % 1000 == 0) {
                    System.out.println(String.format("   Total deleted: %6d", this.count));
                }
            }
        };
        EagerContentStoreCleaner eagerCleaner = (EagerContentStoreCleaner)this.ctx.getBean("eagerContentStoreCleaner");
        eagerCleaner.setListeners(Collections.singletonList(listener));
        eagerCleaner.setStores(Collections.singletonList(this.contentStore));
        this.cleaner = (ContentStoreCleaner)this.ctx.getBean("contentStoreCleaner");
        this.cleaner.setProtectDays(0);
        this.cleaner.execute();
    }

    private class NodeHelper {
        private QName contentQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"realContent");

        public void makeNode(ContentData contentData) {
            StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
            Long rootNodeId = (Long)ContentStoreCleanerScalabilityRunner.this.nodeDAO.newStore(storeRef).getFirst();
            ChildAssocEntity assoc = ContentStoreCleanerScalabilityRunner.this.nodeDAO.newNode(rootNodeId, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, storeRef, null, ContentModel.TYPE_CONTENT, null, null);
            Long nodeId = assoc.getChildNode().getId();
            ContentStoreCleanerScalabilityRunner.this.nodeDAO.addNodeProperty(nodeId, this.contentQName, (Serializable)contentData);
        }
    }

    private class NullContentStore
    extends AbstractContentStore {
        private ThreadLocal<File> hammeredFile = new ThreadLocal();
        private int count;
        private int deletedCount;

        private NullContentStore(int count) {
            this.count = count;
        }

        public boolean isWriteSupported() {
            return true;
        }

        protected ContentWriter getWriterInternal(ContentReader existingContentReader, String newContentUrl) {
            File file = this.hammeredFile.get();
            if (file == null) {
                file = TempFileProvider.createTempFile((String)"NullContentStore", (String)".txt");
                this.hammeredFile.set(file);
            }
            return new FileContentWriter(file);
        }

        public void getUrls(Date createdAfter, Date createdBefore, ContentStore.ContentUrlHandler handler) throws ContentIOException {
            for (int i = 0; i < this.count; ++i) {
                String contentUrl = FileContentStore.createNewFileStoreUrl() + "-imaginary";
                handler.handle(contentUrl);
            }
        }

        public ContentReader getReader(String contentUrl) {
            File file = this.hammeredFile.get();
            if (file == null) {
                return new EmptyContentReader(contentUrl);
            }
            return new FileContentReader(file);
        }

        public boolean delete(String contentUrl) {
            ++this.deletedCount;
            if (this.deletedCount % 1000 == 0) {
                System.out.println(String.format("   Deleted %6d files", this.deletedCount));
            }
            return true;
        }
    }
}

