/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagerContentStoreCleaner
extends TransactionListenerAdapter {
    private static final String KEY_POST_COMMIT_DELETION_URLS = "ContentStoreCleaner.PostCommitDeletionUrls";
    private static final String KEY_POST_ROLLBACK_DELETION_URLS = "ContentStoreCleaner.PostRollbackDeletionUrls";
    private static Log logger = LogFactory.getLog(EagerContentStoreCleaner.class);
    private boolean eagerOrphanCleanup;
    private List<ContentStore> stores = new ArrayList<ContentStore>(0);
    private List<ContentStoreCleanerListener> listeners = new ArrayList<ContentStoreCleanerListener>(0);

    public void setEagerOrphanCleanup(boolean eagerOrphanCleanup) {
        this.eagerOrphanCleanup = eagerOrphanCleanup;
    }

    public void setStores(List<ContentStore> stores) {
        this.stores = stores;
    }

    public void setListeners(List<ContentStoreCleanerListener> listeners) {
        this.listeners = listeners;
    }

    public void init() {
        this.checkProperties();
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"listeners", this.listeners);
    }

    public void registerNewContentUrl(String contentUrl) {
        Set urlsToDelete = TransactionalResourceHelper.getSet(KEY_POST_ROLLBACK_DELETION_URLS);
        urlsToDelete.add(contentUrl);
        AlfrescoTransactionSupport.bindListener(this);
    }

    public boolean registerOrphanedContentUrl(String contentUrl) {
        return this.registerOrphanedContentUrl(contentUrl, false);
    }

    public boolean registerOrphanedContentUrl(String contentUrl, boolean force) {
        if (!this.eagerOrphanCleanup && !force) {
            return false;
        }
        Set urlsToDelete = TransactionalResourceHelper.getSet(KEY_POST_COMMIT_DELETION_URLS);
        urlsToDelete.add(contentUrl);
        AlfrescoTransactionSupport.bindListener(this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduled content for post-commit eager cleanup: " + contentUrl));
        }
        return true;
    }

    @Override
    public void afterCommit() {
        Set<String> urlsToDelete = TransactionalResourceHelper.getSet(KEY_POST_COMMIT_DELETION_URLS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Post-commit deletion of old content URLs: ");
            int count = 0;
            for (String contentUrl : urlsToDelete) {
                if (count == 10) {
                    logger.debug((Object)("   " + (urlsToDelete.size() - 10) + " more ..."));
                } else {
                    logger.debug((Object)("   Deleting content URL: " + contentUrl));
                }
                ++count;
            }
        }
        for (String contentUrl : urlsToDelete) {
            for (ContentStore store : this.stores) {
                for (ContentStoreCleanerListener listener : this.listeners) {
                    listener.beforeDelete(store, contentUrl);
                }
                store.delete(contentUrl);
            }
        }
    }

    @Override
    public void afterRollback() {
        Set<String> urlsToDelete = TransactionalResourceHelper.getSet(KEY_POST_ROLLBACK_DELETION_URLS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Post-rollback deletion of new content URLs: ");
            int count = 0;
            for (String contentUrl : urlsToDelete) {
                if (count == 10) {
                    logger.debug((Object)("   " + (urlsToDelete.size() - 10) + " more ..."));
                } else if (count < 10) {
                    logger.debug((Object)("   Deleting content URL: " + contentUrl));
                }
                ++count;
            }
        }
        for (String contentUrl : urlsToDelete) {
            for (ContentStore store : this.stores) {
                store.delete(contentUrl);
            }
        }
    }
}

