/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerHelper;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentTransformer2
extends ContentTransformerHelper
implements ContentTransformer {
    private static final Log logger = LogFactory.getLog(AbstractContentTransformer2.class);
    private ContentTransformerRegistry registry;
    private double averageTime = 0.0;
    private long count = 0L;

    protected AbstractContentTransformer2() {
    }

    public void setRegistry(ContentTransformerRegistry registry) {
        this.registry = registry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[ average=").append((long)this.averageTime).append("ms").append("]");
        return sb.toString();
    }

    public void register() {
        if (this.registry == null) {
            logger.warn((Object)("Property 'registry' has not been set.  Ignoring auto-registration: \n   transformer: " + this));
            return;
        }
        this.registry.addTransformer(this);
    }

    protected void checkTransformable(ContentReader reader, ContentWriter writer, TransformationOptions options) {
        String targetMimetype;
        String sourceMimetype = this.getMimetype((ContentAccessor)reader);
        boolean transformable = this.isTransformable(sourceMimetype, targetMimetype = this.getMimetype((ContentAccessor)writer), options);
        if (!transformable) {
            throw new AlfrescoRuntimeException("Unsuported transformation attempted: \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
    }

    protected abstract void transformInternal(ContentReader var1, ContentWriter var2, TransformationOptions var3) throws Exception;

    @Override
    public final void transform(ContentReader reader, ContentWriter writer) throws ContentIOException {
        this.transform(reader, writer, new TransformationOptions());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void transform(ContentReader reader, ContentWriter writer, TransformationOptions options) throws ContentIOException {
        long before = System.currentTimeMillis();
        if (options == null) {
            options = new TransformationOptions();
        }
        try {
            try {
                this.checkTransformable(reader, writer, options);
                this.transformInternal(reader, writer, options);
            }
            catch (Throwable e) {
                this.recordTime(60000L);
                throw new ContentIOException("Content conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options, e);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (reader.isChannelOpen()) {
                logger.error((Object)("Content reader not closed by transformer: \n   reader: " + reader + "\n" + "   transformer: " + this));
            }
            if (writer.isChannelOpen()) {
                logger.error((Object)("Content writer not closed by transformer: \n   writer: " + writer + "\n" + "   transformer: " + this));
            }
            throw throwable;
        }
        if (reader.isChannelOpen()) {
            logger.error((Object)("Content reader not closed by transformer: \n   reader: " + reader + "\n" + "   transformer: " + this));
        }
        if (writer.isChannelOpen()) {
            logger.error((Object)("Content writer not closed by transformer: \n   writer: " + writer + "\n" + "   transformer: " + this));
        }
        long after = System.currentTimeMillis();
        this.recordTime(after - before);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completed transformation: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   options: " + options + "\n" + "   transformer: " + this));
        }
    }

    @Override
    public final void transform(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws ContentIOException {
        this.transform(reader, writer, new TransformationOptions(options));
    }

    @Override
    public synchronized long getTransformationTime() {
        return (long)this.averageTime;
    }

    protected final synchronized void recordTime(long transformationTime) {
        if (this.count == Long.MAX_VALUE) {
            this.count /= 2L;
        }
        ++this.count;
        double diffTime = (double)transformationTime - this.averageTime;
        this.averageTime += diffTime / (double)this.count;
    }
}

