/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveContentTransformer
extends AbstractContentTransformer2 {
    private static Log logger = LogFactory.getLog(ArchiveContentTransformer.class);

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "application/zip".equals(sourceMimetype) && "text/plain".equals(targetMimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        InputStream is = null;
        try {
            is = reader.getContentInputStream();
            ArrayList<String> zipEntryNames = new ArrayList<String>();
            ZipInputStream zin = new ZipInputStream(is);
            ZipEntry nextZipEntry = null;
            while ((nextZipEntry = zin.getNextEntry()) != null) {
                String entryName = nextZipEntry.getName();
                zipEntryNames.add(entryName);
            }
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Transformed ").append(zipEntryNames.size()).append(zipEntryNames.size() == 1 ? " zip entry" : " zip entries");
                logger.debug((Object)msg.toString());
            }
            String text = this.createTextContentFrom(zipEntryNames);
            writer.putContent(text);
            Object var10_9 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            is.close();
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String createTextContentFrom(List<String> zipEntryNames) {
        StringBuilder result = new StringBuilder();
        for (String entryName : zipEntryNames) {
            result.append(entryName).append('\n');
        }
        return result.toString();
    }
}

