/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PdfBoxPdfToImageContentTransformer
extends AbstractContentTransformer2 {
    private static Log logger = LogFactory.getLog(PdfBoxPdfToImageContentTransformer.class);

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "application/pdf".equals(sourceMimetype) && "image/png".equals(targetMimetype);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        PDDocument document = null;
        try {
            try {
                File file = TempFileProvider.createTempFile((String)"pdfToImage", (String)".pdf");
                reader.getContent(file);
                document = PDDocument.load((File)file);
                if (document.isEncrypted()) {
                    String msg = "PDF document is encrypted.";
                    if (!logger.isInfoEnabled()) throw new AlfrescoRuntimeException(msg);
                    logger.info((Object)msg);
                    throw new AlfrescoRuntimeException(msg);
                }
                int resolution = 16;
                List pages = document.getDocumentCatalog().getAllPages();
                PDPage page = (PDPage)pages.get(0);
                BufferedImage img = page.convertToImage(2, 16);
                File outputFile = TempFileProvider.createTempFile((String)"pdfToImageOutput", (String)".png");
                ImageIO.write((RenderedImage)img, "png", outputFile);
                writer.putContent(outputFile);
            }
            catch (FileNotFoundException e1) {
                throw new AlfrescoRuntimeException("Unable to create image from pdf file.", (Throwable)e1);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Unable to create image from pdf file.", (Throwable)e);
            }
            Object var12_14 = null;
            if (document == null) return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }
}

