/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionServiceImpl;
import org.alfresco.repo.copy.CompoundCopyBehaviourCallback;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.CopyServiceException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyServiceImpl
implements CopyService {
    private static Log logger = LogFactory.getLog(ActionServiceImpl.class);
    private String COPY_OF_LABEL = "copy_service.copy_of_label";
    private NodeService nodeService;
    private NodeService internalNodeService;
    private DictionaryService dictionaryService;
    private SearchService searchService;
    private PolicyComponent policyComponent;
    private RuleService ruleService;
    private PermissionService permissionService;
    private AuthenticationService authenticationService;
    private ClassPolicyDelegate<CopyServicePolicies.OnCopyNodePolicy> onCopyNodeDelegate;
    private ClassPolicyDelegate<CopyServicePolicies.OnCopyCompletePolicy> onCopyCompleteDelegate;
    private ClassPolicyDelegate<CopyServicePolicies.BeforeCopyPolicy> beforeCopyDelegate;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setInternalNodeService(NodeService internalNodeService) {
        this.internalNodeService = internalNodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void init() {
        this.onCopyNodeDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.OnCopyNodePolicy.class);
        this.onCopyCompleteDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.OnCopyCompletePolicy.class);
        this.beforeCopyDelegate = this.policyComponent.registerClassPolicy(CopyServicePolicies.BeforeCopyPolicy.class);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.ASPECT_COPIEDFROM, (Behaviour)new JavaBehaviour(this, "getCallbackForCopiedFromAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.TYPE_FOLDER, (Behaviour)new JavaBehaviour(this, "getCallbackForFolderType"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.ASPECT_OWNABLE, (Behaviour)new JavaBehaviour(this, "getCallbackForOwnableAspect"));
    }

    @Override
    public NodeRef copy(NodeRef sourceNodeRef, NodeRef targetParentRef, QName assocTypeQName, QName assocQName, boolean copyChildren) {
        ParameterCheck.mandatory((String)"sourceNodeRef", (Object)sourceNodeRef);
        ParameterCheck.mandatory((String)"targetParentRef", (Object)targetParentRef);
        ParameterCheck.mandatory((String)"assocTypeQName", (Object)assocTypeQName);
        ParameterCheck.mandatory((String)"assocQName", (Object)assocQName);
        if (!sourceNodeRef.getStoreRef().equals((Object)targetParentRef.getStoreRef())) {
            throw new UnsupportedOperationException("Copying nodes across stores is not currently supported.");
        }
        HashMap<NodeRef, NodeRef> copiesByOriginals = new HashMap<NodeRef, NodeRef>(17);
        HashSet<NodeRef> copies = new HashSet<NodeRef>(17);
        NodeRef copiedNodeRef = this.copyImpl(sourceNodeRef, targetParentRef, assocTypeQName, assocQName, copyChildren, true, copiesByOriginals, copies);
        if (copiedNodeRef == null) {
            CopyDetails copyDetails = this.getCopyDetails(sourceNodeRef, targetParentRef, null, assocTypeQName, assocQName);
            throw new CopyServiceException("A bound policy denied copy: \n   " + copyDetails);
        }
        for (Map.Entry entry : copiesByOriginals.entrySet()) {
            NodeRef mappedSourceNodeRef = (NodeRef)entry.getKey();
            NodeRef mappedTargetNodeRef = (NodeRef)entry.getValue();
            this.invokeCopyComplete(mappedSourceNodeRef, mappedTargetNodeRef, true, copiesByOriginals);
        }
        return copiedNodeRef;
    }

    @Override
    public NodeRef copyAndRename(NodeRef sourceNodeRef, NodeRef destinationParent, QName assocTypeQName, QName assocQName, boolean copyChildren) {
        String sourceName;
        NodeRef result = null;
        String newName = sourceName = (String)((Object)this.internalNodeService.getProperty(sourceNodeRef, ContentModel.PROP_NAME));
        while (this.internalNodeService.getChildByName(destinationParent, assocTypeQName, newName) != null) {
            newName = I18NUtil.getMessage((String)this.COPY_OF_LABEL, (Object[])new Object[]{newName});
        }
        if (assocQName == null) {
            assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)newName));
        }
        result = this.copy(sourceNodeRef, destinationParent, assocTypeQName, assocQName, copyChildren);
        this.internalNodeService.setProperty(result, ContentModel.PROP_NAME, (Serializable)((Object)newName));
        return result;
    }

    @Override
    public NodeRef copy(NodeRef sourceNodeRef, NodeRef targetParentNodeRef, QName assocTypeQName, QName assocQName) {
        return this.copy(sourceNodeRef, targetParentNodeRef, assocTypeQName, assocQName, false);
    }

    @Override
    public void copy(NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        QName targetNodeTypeQName;
        QName sourceNodeTypeQName = this.nodeService.getType(sourceNodeRef);
        if (!sourceNodeTypeQName.equals((Object)(targetNodeTypeQName = this.nodeService.getType(targetNodeRef)))) {
            throw new CopyServiceException("The source and destination node must be the same type.");
        }
        Map sourceNodeProperties = this.nodeService.getProperties(sourceNodeRef);
        ChildAssociationRef destinationPrimaryAssocRef = this.nodeService.getPrimaryParent(targetNodeRef);
        NodeRef destinationParentNodeRef = destinationPrimaryAssocRef.getParentRef();
        QName assocTypeQName = destinationPrimaryAssocRef.getTypeQName();
        QName assocQName = destinationPrimaryAssocRef.getQName();
        CopyDetails copyDetails = this.getCopyDetails(sourceNodeRef, destinationParentNodeRef, targetNodeRef, assocTypeQName, assocQName);
        Map<QName, CopyBehaviourCallback> callbacks = this.getCallbacks(copyDetails);
        sourceNodeProperties.remove(ContentModel.PROP_NAME);
        this.invokeBeforeCopy(sourceNodeRef, targetNodeRef);
        this.copyProperties(copyDetails, targetNodeRef, sourceNodeTypeQName, callbacks);
        this.copyAspects(copyDetails, targetNodeRef, Collections.<QName>emptySet(), callbacks);
        this.copyResidualProperties(copyDetails, targetNodeRef);
        HashMap<NodeRef, NodeRef> copiedNodeRefs = new HashMap<NodeRef, NodeRef>(1);
        copiedNodeRefs.put(sourceNodeRef, targetNodeRef);
        this.invokeCopyComplete(sourceNodeRef, targetNodeRef, false, copiedNodeRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<NodeRef> getCopies(NodeRef nodeRef) {
        ArrayList<NodeRef> copies = new ArrayList<NodeRef>();
        ResultSet resultSet = null;
        try {
            resultSet = this.searchService.query(nodeRef.getStoreRef(), "lucene", "+@\\{http\\://www.alfresco.org/model/content/1.0\\}" + ContentModel.PROP_COPY_REFERENCE.getLocalName() + ":\"" + nodeRef.toString() + "\"");
            for (NodeRef copy : resultSet.getNodeRefs()) {
                copies.add(copy);
            }
            Object var7_6 = null;
            if (resultSet == null) return copies;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (resultSet == null) throw throwable;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return copies;
    }

    private NodeRef copyImpl(NodeRef sourceNodeRef, NodeRef targetParentRef, QName assocTypeQName, QName assocQName, boolean copyChildren, boolean dropName, Map<NodeRef, NodeRef> copiesByOriginals, Set<NodeRef> copies) {
        QName sourceNodeTypeQName;
        CopyDetails copyDetails = this.getCopyDetails(sourceNodeRef, targetParentRef, null, assocTypeQName, assocQName);
        Map<QName, CopyBehaviourCallback> callbacks = this.getCallbacks(copyDetails);
        CopyBehaviourCallback callback = callbacks.get(sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName());
        if (callback == null) {
            throw new IllegalStateException("Source node type has no callback: " + sourceNodeTypeQName);
        }
        if (!callback.getMustCopy(sourceNodeTypeQName, copyDetails)) {
            return null;
        }
        NodeRef copiedNodeRef = this.recursiveCopy(copyDetails, copyChildren, dropName, copiesByOriginals, copies, callbacks);
        return copiedNodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef recursiveCopy(CopyDetails copyDetails, boolean copyChildren, boolean dropName, Map<NodeRef, NodeRef> copiesByOriginal, Set<NodeRef> copies, Map<QName, CopyBehaviourCallback> callbacks) {
        NodeRef sourceNodeRef = copyDetails.getSourceNodeRef();
        Set<QName> sourceNodeAspectQNames = copyDetails.getSourceNodeAspectQNames();
        NodeRef targetParentNodeRef = copyDetails.getTargetParentNodeRef();
        QName assocTypeQName = copyDetails.getAssocTypeQName();
        QName assocQName = copyDetails.getAssocQName();
        if (copies.contains(sourceNodeRef)) {
            throw new IllegalStateException("Nested copy prevention has failed: \n   " + copyDetails + "\n" + "   Copies by original: " + copiesByOriginal);
        }
        if (copiesByOriginal.containsKey(sourceNodeRef)) {
            throw new IllegalStateException("Multiple child assocs between same two nodes detected: \n   " + copyDetails + "\n" + "   Copies by original: " + copiesByOriginal);
        }
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        CopyBehaviourCallback sourceTypeBehaviour = callbacks.get(sourceNodeTypeQName);
        if (sourceTypeBehaviour == null) {
            throw new IllegalStateException("Source node type has no callback: " + sourceNodeTypeQName);
        }
        if (!sourceTypeBehaviour.getMustCopy(sourceNodeTypeQName, copyDetails)) {
            return null;
        }
        Map<QName, Serializable> targetNodeProperties = this.buildCopyProperties(copyDetails, Collections.singleton(sourceNodeTypeQName), callbacks);
        Set<QName> defaultAspectQNames = this.getDefaultAspects(sourceNodeTypeQName);
        Map<QName, Serializable> defaultAspectsProperties = this.buildCopyProperties(copyDetails, defaultAspectQNames, callbacks);
        targetNodeProperties.putAll(defaultAspectsProperties);
        AssociationDefinition assocDef = this.dictionaryService.getAssociation(assocTypeQName);
        if (!assocDef.isChild()) {
            throw new AlfrescoRuntimeException("Association is not a child association: " + assocTypeQName);
        }
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        if (dropName && !childAssocDef.getDuplicateChildNamesAllowed()) {
            targetNodeProperties.remove(ContentModel.PROP_NAME);
        }
        String targetNodeUuid = copyDetails.getTargetNodeRef().getId();
        targetNodeProperties.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)targetNodeUuid));
        ChildAssociationRef targetChildAssocRef = this.nodeService.createNode(targetParentNodeRef, assocTypeQName, assocQName, sourceNodeTypeQName, targetNodeProperties);
        NodeRef targetNodeRef = targetChildAssocRef.getChildRef();
        copiesByOriginal.put(sourceNodeRef, targetNodeRef);
        copies.add(targetNodeRef);
        this.invokeBeforeCopy(sourceNodeRef, targetNodeRef);
        HashSet<QName> remainingAspectQNames = new HashSet<QName>(sourceNodeAspectQNames);
        remainingAspectQNames.removeAll(defaultAspectQNames);
        this.ruleService.disableRules(targetNodeRef);
        try {
            for (QName remainingAspectQName : remainingAspectQNames) {
                this.copyProperties(copyDetails, targetNodeRef, remainingAspectQName, callbacks);
            }
            this.copyResidualProperties(copyDetails, targetNodeRef);
            HashMap<QName, NodeRef> copyProperties = new HashMap<QName, NodeRef>();
            copyProperties.put(ContentModel.PROP_COPY_REFERENCE, sourceNodeRef);
            this.internalNodeService.addAspect(targetNodeRef, ContentModel.ASPECT_COPIEDFROM, copyProperties);
            this.copyChildren(copyDetails, targetNodeRef, true, copyChildren, copiesByOriginal, copies, callbacks);
            Object var25_24 = null;
            this.ruleService.enableRules(targetNodeRef);
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            this.ruleService.enableRules(targetNodeRef);
            throw throwable;
        }
        return targetNodeRef;
    }

    private Set<QName> getDefaultAspects(QName sourceNodeTypeQName) {
        TypeDefinition sourceNodeTypeDef = this.dictionaryService.getType(sourceNodeTypeQName);
        if (sourceNodeTypeDef == null) {
            return Collections.emptySet();
        }
        HashSet<QName> defaultAspectQNames = new HashSet<QName>(7);
        for (AspectDefinition aspectDef : sourceNodeTypeDef.getDefaultAspects()) {
            defaultAspectQNames.add(aspectDef.getName());
        }
        return defaultAspectQNames;
    }

    private Map<QName, Serializable> buildCopyProperties(CopyDetails copyDetails, Set<QName> classQNames, Map<QName, CopyBehaviourCallback> callbacks) {
        Map<QName, Serializable> sourceNodeProperties = copyDetails.getSourceNodeProperties();
        HashMap<QName, Serializable> copyProperties = new HashMap<QName, Serializable>(sourceNodeProperties.size(), 1.0f);
        Map<QName, Serializable> scratchProperties = new HashMap<QName, Serializable>(11);
        for (QName classQName : classQNames) {
            ClassDefinition classDef;
            CopyBehaviourCallback callback = callbacks.get(classQName);
            if (callback == null) {
                throw new IllegalStateException("Source node class has no callback: " + classQName);
            }
            if (!callback.getMustCopy(classQName, copyDetails) || (classDef = this.dictionaryService.getClass(classQName)) == null) continue;
            Map propertyDefs = classDef.getProperties();
            scratchProperties.clear();
            for (QName propertyQName : propertyDefs.keySet()) {
                Serializable value = sourceNodeProperties.get(propertyQName);
                if (value == null) continue;
                scratchProperties.put(propertyQName, value);
            }
            scratchProperties = callback.getCopyProperties(classQName, copyDetails, scratchProperties);
            copyProperties.putAll(scratchProperties);
        }
        return copyProperties;
    }

    private void invokeBeforeCopy(NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        QName targetClassRef = this.internalNodeService.getType(targetNodeRef);
        this.invokeBeforeCopy(targetClassRef, sourceNodeRef, targetNodeRef);
        Set targetAspects = this.nodeService.getAspects(targetNodeRef);
        for (QName targetAspect : targetAspects) {
            this.invokeBeforeCopy(targetAspect, sourceNodeRef, targetNodeRef);
        }
    }

    private void invokeBeforeCopy(QName typeQName, NodeRef sourceNodeRef, NodeRef targetNodeRef) {
        Collection<CopyServicePolicies.BeforeCopyPolicy> policies = this.beforeCopyDelegate.getList(typeQName);
        for (CopyServicePolicies.BeforeCopyPolicy policy : policies) {
            policy.beforeCopy(typeQName, sourceNodeRef, targetNodeRef);
        }
    }

    private void invokeCopyComplete(NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copiedNodeRefs) {
        QName sourceClassRef = this.internalNodeService.getType(sourceNodeRef);
        this.invokeCopyComplete(sourceClassRef, sourceNodeRef, targetNodeRef, copyToNewNode, copiedNodeRefs);
        Set sourceAspects = this.nodeService.getAspects(sourceNodeRef);
        for (QName sourceAspect : sourceAspects) {
            this.invokeCopyComplete(sourceAspect, sourceNodeRef, targetNodeRef, copyToNewNode, copiedNodeRefs);
        }
    }

    private void invokeCopyComplete(QName typeQName, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copiedNodeRefs) {
        Collection<CopyServicePolicies.OnCopyCompletePolicy> policies = this.onCopyCompleteDelegate.getList(typeQName);
        for (CopyServicePolicies.OnCopyCompletePolicy policy : policies) {
            policy.onCopyComplete(typeQName, sourceNodeRef, targetNodeRef, copyToNewNode, copiedNodeRefs);
        }
    }

    private CopyDetails getCopyDetails(NodeRef sourceNodeRef, NodeRef targetParentNodeRef, NodeRef targetNodeRef, QName assocTypeQName, QName assocQName) {
        Map sourceNodeProperties = this.nodeService.getProperties(sourceNodeRef);
        QName sourceNodeTypeQName = this.internalNodeService.getType(sourceNodeRef);
        Set sourceNodeAspectQNames = this.internalNodeService.getAspects(sourceNodeRef);
        boolean targetNodeIsNew = false;
        if (targetNodeRef == null) {
            targetNodeRef = new NodeRef(targetParentNodeRef.getStoreRef(), GUID.generate());
            targetNodeIsNew = true;
        }
        CopyDetails copyDetails = new CopyDetails(sourceNodeRef, sourceNodeTypeQName, sourceNodeAspectQNames, sourceNodeProperties, targetParentNodeRef, targetNodeRef, targetNodeIsNew, assocTypeQName, assocQName);
        return copyDetails;
    }

    private Map<QName, CopyBehaviourCallback> getCallbacks(CopyDetails copyDetails) {
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        HashMap<QName, CopyBehaviourCallback> callbacks = new HashMap<QName, CopyBehaviourCallback>(11);
        CopyBehaviourCallback callback = this.getCallback(sourceNodeTypeQName, copyDetails);
        callbacks.put(sourceNodeTypeQName, callback);
        for (QName sourceNodeAspectQName : copyDetails.getSourceNodeAspectQNames()) {
            callback = this.getCallback(sourceNodeAspectQName, copyDetails);
            callbacks.put(sourceNodeAspectQName, callback);
        }
        return callbacks;
    }

    private CopyBehaviourCallback getCallback(QName sourceClassQName, CopyDetails copyDetails) {
        Collection<CopyServicePolicies.OnCopyNodePolicy> policies = this.onCopyNodeDelegate.getList(sourceClassQName);
        ClassDefinition sourceClassDef = this.dictionaryService.getClass(sourceClassQName);
        CopyBehaviourCallback callback = null;
        if (sourceClassDef == null) {
            callback = DoNothingCopyBehaviourCallback.getInstance();
        }
        if (policies.isEmpty()) {
            callback = DefaultCopyBehaviourCallback.getInstance();
        } else if (policies.size() == 1) {
            callback = policies.iterator().next().getCopyCallback(sourceClassQName, copyDetails);
        } else {
            CompoundCopyBehaviourCallback compoundCallback = new CompoundCopyBehaviourCallback(sourceClassQName);
            for (CopyServicePolicies.OnCopyNodePolicy policy : policies) {
                CopyBehaviourCallback nestedCallback = policy.getCopyCallback(sourceClassQName, copyDetails);
                compoundCallback.addBehaviour(nestedCallback);
            }
            callback = compoundCallback;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched copy callback: \n   Class:                      " + sourceClassQName + "\n" + "   Details:                    " + copyDetails + "\n" + "   Callback: " + callback));
        }
        return callback;
    }

    private void copyProperties(CopyDetails copyDetails, NodeRef targetNodeRef, QName classQName, Map<QName, CopyBehaviourCallback> callbacks) {
        ClassDefinition targetClassDef = this.dictionaryService.getClass(classQName);
        if (targetClassDef == null) {
            return;
        }
        CopyBehaviourCallback callback = callbacks.get(classQName);
        if (callback == null) {
            throw new IllegalStateException("Source node class has no callback: " + classQName);
        }
        if (!callback.getMustCopy(classQName, copyDetails)) {
            return;
        }
        Map<QName, Serializable> classProperties = this.buildCopyProperties(copyDetails, Collections.singleton(classQName), callbacks);
        if (targetClassDef.isAspect()) {
            this.internalNodeService.addAspect(targetNodeRef, classQName, classProperties);
        } else {
            this.internalNodeService.addProperties(targetNodeRef, classProperties);
        }
    }

    private void copyResidualProperties(CopyDetails copyDetails, NodeRef targetNodeRef) {
        HashMap<QName, Serializable> residualProperties = new HashMap<QName, Serializable>();
        residualProperties.putAll(copyDetails.getSourceNodeProperties());
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        HashSet<QName> knownClassQNames = new HashSet<QName>(13);
        knownClassQNames.addAll(this.getDefaultAspects(sourceNodeTypeQName));
        knownClassQNames.addAll(copyDetails.getSourceNodeAspectQNames());
        knownClassQNames.add(sourceNodeTypeQName);
        block0: for (QName knownClassQName : knownClassQNames) {
            ClassDefinition classDef = this.dictionaryService.getClass(knownClassQName);
            if (classDef == null) continue;
            for (QName definedPropQName : classDef.getProperties().keySet()) {
                residualProperties.remove(definedPropQName);
                if (residualProperties.size() != 0) continue;
                continue block0;
            }
        }
        if (residualProperties.size() > 0) {
            this.internalNodeService.addProperties(targetNodeRef, residualProperties);
        }
    }

    private void copyAspects(CopyDetails copyDetails, NodeRef targetNodeRef, Set<QName> aspectsToIgnore, Map<QName, CopyBehaviourCallback> callbacks) {
        Set<QName> sourceAspectQNames = copyDetails.getSourceNodeAspectQNames();
        for (QName aspectQName : sourceAspectQNames) {
            if (aspectsToIgnore.contains(aspectQName)) continue;
            CopyBehaviourCallback callback = callbacks.get(aspectQName);
            if (callback == null) {
                throw new IllegalStateException("Source aspect class has no callback: " + aspectQName);
            }
            if (!callback.getMustCopy(aspectQName, copyDetails)) continue;
            this.copyProperties(copyDetails, targetNodeRef, aspectQName, callbacks);
        }
    }

    private void copyChildren(CopyDetails copyDetails, NodeRef targetNodeRef, boolean targetNodeIsNew, boolean copyChildren, Map<NodeRef, NodeRef> copiesByOriginals, Set<NodeRef> copies, Map<QName, CopyBehaviourCallback> callbacks) {
        QName sourceNodeTypeQName = copyDetails.getSourceNodeTypeQName();
        Set<QName> sourceNodeAspectQNames = copyDetails.getSourceNodeAspectQNames();
        this.copyChildren(copyDetails, sourceNodeTypeQName, targetNodeRef, targetNodeIsNew, copyChildren, copiesByOriginals, copies, callbacks);
        for (QName aspectQName : sourceNodeAspectQNames) {
            AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectQName);
            if (aspectDef == null) continue;
            this.copyChildren(copyDetails, aspectQName, targetNodeRef, targetNodeIsNew, copyChildren, copiesByOriginals, copies, callbacks);
        }
    }

    private void copyChildren(CopyDetails copyDetails, QName classQName, NodeRef targetNodeRef, boolean targetNodeIsNew, boolean copyChildren, Map<NodeRef, NodeRef> copiesByOriginals, Set<NodeRef> copies, Map<QName, CopyBehaviourCallback> callbacks) {
        NodeRef sourceNodeRef = copyDetails.getSourceNodeRef();
        ClassDefinition classDef = this.dictionaryService.getClass(classQName);
        if (classDef == null) {
            return;
        }
        CopyBehaviourCallback callback = callbacks.get(classQName);
        if (callback == null) {
            throw new IllegalStateException("Source node class has no callback: " + classQName);
        }
        for (Map.Entry entry : classDef.getChildAssociations().entrySet()) {
            QName assocTypeQName = (QName)entry.getKey();
            ChildAssociationDefinition assocDef = (ChildAssociationDefinition)entry.getValue();
            if (!assocDef.isChild()) continue;
            List childAssocRefs = this.nodeService.getChildAssocs(sourceNodeRef, (QNamePattern)assocTypeQName, RegexQNamePattern.MATCH_ALL);
            block10: for (ChildAssociationRef childAssocRef : childAssocRefs) {
                NodeRef childNodeRef = childAssocRef.getChildRef();
                QName assocQName = childAssocRef.getQName();
                CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails = new CopyBehaviourCallback.CopyChildAssociationDetails(childAssocRef, targetNodeRef, targetNodeIsNew, copyChildren);
                if (copies.contains(childNodeRef)) continue;
                CopyBehaviourCallback.ChildAssocCopyAction childAssocCopyAction = callback.getChildAssociationCopyAction(classQName, copyDetails, childAssocCopyDetails);
                switch (childAssocCopyAction) {
                    case IGNORE: {
                        continue block10;
                    }
                    case COPY_ASSOC: {
                        this.nodeService.addChild(targetNodeRef, childNodeRef, assocTypeQName, assocQName);
                        continue block10;
                    }
                    case COPY_CHILD: {
                        if (copiesByOriginals.containsKey(childNodeRef)) {
                            this.nodeService.addChild(targetNodeRef, childNodeRef, assocTypeQName, assocQName);
                            continue block10;
                        }
                        CopyBehaviourCallback.ChildAssocRecurseAction childAssocRecurseAction = callback.getChildAssociationRecurseAction(classQName, copyDetails, childAssocCopyDetails);
                        switch (childAssocRecurseAction) {
                            case RESPECT_RECURSE_FLAG: {
                                break;
                            }
                            case FORCE_RECURSE: {
                                copyChildren = true;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unrecognized enum");
                            }
                        }
                        this.copyImpl(childNodeRef, targetNodeRef, assocTypeQName, assocQName, copyChildren, false, copiesByOriginals, copies);
                        continue block10;
                    }
                }
                throw new IllegalStateException("Unrecognized enum");
            }
        }
    }

    public CopyBehaviourCallback getCallbackForCopiedFromAspect(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    public CopyBehaviourCallback getCallbackForFolderType(QName classRef, CopyDetails copyDetails) {
        return FolderTypeCopyBehaviourCallback.INSTANCE;
    }

    public CopyBehaviourCallback getCallbackForOwnableAspect(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }

    private static class FolderTypeCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new FolderTypeCopyBehaviourCallback();

        private FolderTypeCopyBehaviourCallback() {
        }

        public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            ChildAssociationRef childAssocRef = childAssocCopyDetails.getChildAssocRef();
            boolean copyChildren = childAssocCopyDetails.isCopyChildren();
            if (childAssocRef.getTypeQName().equals((Object)ContentModel.ASSOC_CONTAINS)) {
                if (!copyChildren) {
                    return CopyBehaviourCallback.ChildAssocCopyAction.IGNORE;
                }
                if (childAssocRef.isPrimary()) {
                    return CopyBehaviourCallback.ChildAssocCopyAction.COPY_CHILD;
                }
                return CopyBehaviourCallback.ChildAssocCopyAction.COPY_ASSOC;
            }
            throw new IllegalStateException("Behaviour should have been invoked: \n   Aspect: " + this.getClass().getName() + "\n" + "   Assoc:  " + childAssocRef + "\n" + "   " + copyDetails);
        }
    }
}

