/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Association;
import org.alfresco.repo.dictionary.M2ChildAssociation;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.PropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyServiceImplTest
extends BaseSpringTest {
    private NodeService nodeService;
    private CopyService copyService;
    private DictionaryDAO dictionaryDAO;
    private ContentService contentService;
    private RuleService ruleService;
    private ActionService actionService;
    private AuthenticationComponent authenticationComponent;
    private StoreRef storeRef;
    private NodeRef sourceNodeRef;
    private NodeRef rootNodeRef;
    private NodeRef targetNodeRef;
    private NodeRef nonPrimaryChildNodeRef;
    private NodeRef childNodeRef;
    private NodeRef destinationNodeRef;
    private static final String TEST_TYPE_NAMESPACE = "testTypeNamespaceURI";
    private static final QName TEST_TYPE_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testType");
    private static final QName PROP1_QNAME_MANDATORY = QName.createQName((String)"testTypeNamespaceURI", (String)"prop1Mandatory");
    private static final QName PROP2_QNAME_OPTIONAL = QName.createQName((String)"testTypeNamespaceURI", (String)"prop2Optional");
    private static final QName TEST_ASPECT_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testAspect");
    private static final QName PROP3_QNAME_MANDATORY = QName.createQName((String)"testTypeNamespaceURI", (String)"prop3Mandatory");
    private static final QName PROP4_QNAME_OPTIONAL = QName.createQName((String)"testTypeNamespaceURI", (String)"prop4Optional");
    private static final QName PROP_QNAME_MY_NODE_REF = QName.createQName((String)"testTypeNamespaceURI", (String)"myNodeRef");
    private static final QName PROP_QNAME_MY_ANY = QName.createQName((String)"testTypeNamespaceURI", (String)"myAny");
    private static final QName PROP_QNAME_RESIDUAL_NODE_REF = QName.createQName((String)"testTypeNamespaceURI", (String)"residualNodeRef");
    private static final QName PROP_QNAME_RESIDUAL_ANY = QName.createQName((String)"testTypeNamespaceURI", (String)"residualAny");
    private static final QName TEST_MANDATORY_ASPECT_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testMandatoryAspect");
    private static final QName PROP5_QNAME_MANDATORY = QName.createQName((String)"testTypeNamespaceURI", (String)"prop5Mandatory");
    private static final String TEST_NAME = "testName";
    private static final String TEST_VALUE_1 = "testValue1";
    private static final String TEST_VALUE_2 = "testValue2";
    private static final String TEST_VALUE_3 = "testValue3";
    private static final QName TEST_CHILD_ASSOC_TYPE_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"contains");
    private static final QName TEST_CHILD_ASSOC_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testChildAssocName");
    private static final QName TEST_ASSOC_TYPE_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testAssocName");
    private static final QName TEST_CHILD_ASSOC_QNAME2 = QName.createQName((String)"testTypeNamespaceURI", (String)"testChildAssocName2");
    private static final ContentData CONTENT_DATA_TEXT = new ContentData(null, "text/plain", 0L, "UTF-8");
    private static final String SOME_CONTENT = "This is some content ...";

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.copyService = (CopyService)this.applicationContext.getBean("copyService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createTestModel();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}test"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.sourceNodeRef = childAssocRef.getChildRef();
        HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
        aspectProperties.put(PROP3_QNAME_MANDATORY, TEST_VALUE_1);
        aspectProperties.put(PROP4_QNAME_OPTIONAL, TEST_VALUE_2);
        this.nodeService.addAspect(this.sourceNodeRef, TEST_ASPECT_QNAME, aspectProperties);
        this.nodeService.addAspect(this.sourceNodeRef, ContentModel.ASPECT_TITLED, null);
        ChildAssociationRef temp3 = this.nodeService.createNode(this.sourceNodeRef, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME, TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.childNodeRef = temp3.getChildRef();
        ChildAssociationRef temp2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testNonPrimaryChild"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.nonPrimaryChildNodeRef = temp2.getChildRef();
        this.nodeService.addChild(this.sourceNodeRef, this.nonPrimaryChildNodeRef, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME2);
        ChildAssociationRef temp = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testAssoc"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.targetNodeRef = temp.getChildRef();
        this.nodeService.createAssociation(this.sourceNodeRef, this.targetNodeRef, TEST_ASSOC_TYPE_QNAME);
        HashMap<QName, String> destinationProps = new HashMap<QName, String>();
        destinationProps.put(PROP1_QNAME_MANDATORY, TEST_VALUE_1);
        destinationProps.put(PROP5_QNAME_MANDATORY, TEST_VALUE_3);
        destinationProps.put(ContentModel.PROP_CONTENT, (String)CONTENT_DATA_TEXT);
        ChildAssociationRef temp5 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testDestinationNode"), TEST_TYPE_QNAME, destinationProps);
        this.destinationNodeRef = temp5.getChildRef();
    }

    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.onTearDownInTransaction();
    }

    private Map<QName, Serializable> createTypePropertyBag() {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        result.put(ContentModel.PROP_NAME, (Serializable)((Object)TEST_NAME));
        result.put(PROP1_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_1));
        result.put(PROP2_QNAME_OPTIONAL, (Serializable)((Object)TEST_VALUE_2));
        result.put(PROP5_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_3));
        result.put(ContentModel.PROP_CONTENT, (Serializable)CONTENT_DATA_TEXT);
        return result;
    }

    private void createTestModel() {
        M2Model model = M2Model.createModel((String)"test:nodeoperations");
        model.createNamespace(TEST_TYPE_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/system/1.0", "sys");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        M2Type testType = model.createType("test:" + TEST_TYPE_QNAME.getLocalName());
        testType.setParentName("cm:" + ContentModel.TYPE_CONTENT.getLocalName());
        M2Property prop1 = testType.createProperty("test:" + PROP1_QNAME_MANDATORY.getLocalName());
        prop1.setMandatory(true);
        prop1.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop1.setMultiValued(false);
        M2Property prop2 = testType.createProperty("test:" + PROP2_QNAME_OPTIONAL.getLocalName());
        prop2.setMandatory(false);
        prop2.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop2.setMandatory(false);
        M2Property propNodeRef = testType.createProperty("test:" + PROP_QNAME_MY_NODE_REF.getLocalName());
        propNodeRef.setMandatory(false);
        propNodeRef.setType("d:" + DataTypeDefinition.NODE_REF.getLocalName());
        propNodeRef.setMandatory(false);
        M2Property propAnyNodeRef = testType.createProperty("test:" + PROP_QNAME_MY_ANY.getLocalName());
        propAnyNodeRef.setMandatory(false);
        propAnyNodeRef.setType("d:" + DataTypeDefinition.ANY.getLocalName());
        propAnyNodeRef.setMandatory(false);
        M2ChildAssociation childAssoc = testType.createChildAssociation("test:" + TEST_CHILD_ASSOC_TYPE_QNAME.getLocalName());
        childAssoc.setTargetClassName("sys:base");
        childAssoc.setTargetMandatory(false);
        M2Association assoc = testType.createAssociation("test:" + TEST_ASSOC_TYPE_QNAME.getLocalName());
        assoc.setTargetClassName("sys:base");
        assoc.setTargetMandatory(false);
        M2Aspect testAspect = model.createAspect("test:" + TEST_ASPECT_QNAME.getLocalName());
        M2Property prop3 = testAspect.createProperty("test:" + PROP3_QNAME_MANDATORY.getLocalName());
        prop3.setMandatory(true);
        prop3.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop3.setMultiValued(false);
        M2Property prop4 = testAspect.createProperty("test:" + PROP4_QNAME_OPTIONAL.getLocalName());
        prop4.setMandatory(false);
        prop4.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop4.setMultiValued(false);
        M2Aspect testMandatoryAspect = model.createAspect("test:" + TEST_MANDATORY_ASPECT_QNAME.getLocalName());
        M2Property prop5 = testMandatoryAspect.createProperty("test:" + PROP5_QNAME_MANDATORY.getLocalName());
        prop5.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop5.setMandatory(true);
        testType.addMandatoryAspect("test:" + TEST_MANDATORY_ASPECT_QNAME.getLocalName());
        this.dictionaryDAO.putModel(model);
    }

    public void testCopyToNewNode() {
        List<NodeRef> copies = this.copyService.getCopies(this.sourceNodeRef);
        CopyServiceImplTest.assertNotNull(copies);
        CopyServiceImplTest.assertTrue((boolean)copies.isEmpty());
        NodeRef copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc"));
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, false);
        List<NodeRef> copies2 = this.copyService.getCopies(this.sourceNodeRef);
        CopyServiceImplTest.assertNotNull(copies2);
        CopyServiceImplTest.assertEquals((int)1, (int)copies2.size());
        NodeRef copy2 = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc2"), true);
        this.checkCopiedNode(this.sourceNodeRef, copy2, true, true, true);
        List<NodeRef> copies3 = this.copyService.getCopies(this.sourceNodeRef);
        CopyServiceImplTest.assertNotNull(copies3);
        CopyServiceImplTest.assertEquals((int)2, (int)copies3.size());
        NodeRef copyOfCopy = this.copyService.copy(copy, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyOfCopy"));
        this.checkCopiedNode(copy, copyOfCopy, true, true, false);
        ContentWriter contentWriter = this.contentService.getWriter(this.sourceNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(SOME_CONTENT);
        NodeRef copyWithContent = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyWithContent"));
        this.checkCopiedNode(this.sourceNodeRef, copyWithContent, true, true, false);
        ContentReader contentReader = this.contentService.getReader(copyWithContent, ContentModel.PROP_CONTENT);
        CopyServiceImplTest.assertNotNull((Object)contentReader);
        CopyServiceImplTest.assertEquals((String)SOME_CONTENT, (String)contentReader.getContentString());
    }

    public void testCopyNodeWithRules() {
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        HashMap<String, Serializable> props = new HashMap<String, Serializable>(1);
        props.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Action action = this.actionService.createAction("add-features", props);
        rule.setAction(action);
        ActionCondition actionCondition = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(actionCondition);
        this.ruleService.saveRule(this.sourceNodeRef, rule);
        CopyServiceImplTest.assertNotNull((Object)rule.getNodeRef());
        CopyServiceImplTest.assertEquals((Object)this.sourceNodeRef, (Object)this.ruleService.getOwningNodeRef(rule));
        NodeRef copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}withRulesCopy"), true);
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, true);
        CopyServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(copy, RuleModel.ASPECT_RULES));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.hasRules(copy));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(copy));
        List<Rule> copiedRules = this.ruleService.getRules(copy);
        CopyServiceImplTest.assertEquals((int)1, (int)copiedRules.size());
        Rule copiedRule = copiedRules.get(0);
        CopyServiceImplTest.assertNotNull((Object)copiedRule.getNodeRef());
        CopyServiceImplTest.assertFalse((boolean)copiedRule.getNodeRef().equals((Object)rule.getNodeRef()));
        CopyServiceImplTest.assertEquals((String)rule.getTitle(), (String)copiedRule.getTitle());
        CopyServiceImplTest.assertEquals((String)rule.getDescription(), (String)copiedRule.getDescription());
        CopyServiceImplTest.assertEquals((Object)copy, (Object)this.ruleService.getOwningNodeRef(copiedRule));
        CopyServiceImplTest.assertEquals((String)rule.getAction().getActionDefinitionName(), (String)copiedRule.getAction().getActionDefinitionName());
        NodeRef copy2 = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}withRuleCopyNoChildren"), false);
        this.checkCopiedNode(this.sourceNodeRef, copy2, true, true, false);
        CopyServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(copy2, RuleModel.ASPECT_RULES));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.hasRules(copy2));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(copy2));
        List<Rule> copiedRules2 = this.ruleService.getRules(copy2);
        CopyServiceImplTest.assertEquals((int)1, (int)copiedRules.size());
        Rule copiedRule2 = copiedRules2.get(0);
        CopyServiceImplTest.assertFalse((boolean)rule.getNodeRef().equals((Object)copiedRule2.getNodeRef()));
        CopyServiceImplTest.assertEquals((String)rule.getTitle(), (String)copiedRule2.getTitle());
        CopyServiceImplTest.assertEquals((String)rule.getDescription(), (String)copiedRule2.getDescription());
        CopyServiceImplTest.assertEquals((Object)this.ruleService.getOwningNodeRef(copiedRule2), (Object)copy2);
        CopyServiceImplTest.assertEquals((String)rule.getAction().getActionDefinitionName(), (String)copiedRule2.getAction().getActionDefinitionName());
    }

    public void testCopyToExistingNode() {
        this.copyService.copy(this.sourceNodeRef, this.destinationNodeRef);
        this.checkCopiedNode(this.sourceNodeRef, this.destinationNodeRef, false, true, false);
    }

    public void testRecursiveCopy() {
        PropertyMap props = new PropertyMap();
        props.put(ContentModel.PROP_NODE_UUID, "nodeOne");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeTwo");
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeThree");
        NodeRef nodeThree = this.nodeService.createNode(nodeTwo, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        this.copyService.copy(nodeOne, nodeThree, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, true);
    }

    public void testCopyResidualProperties() throws Exception {
        QName nodeOneAssocName = QName.createQName((String)"{test}nodeOne");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, nodeOneAssocName, TEST_TYPE_QNAME).getChildRef();
        this.nodeService.setProperty(nodeOne, PROP_QNAME_RESIDUAL_NODE_REF, (Serializable)nodeOne);
        this.nodeService.setProperty(nodeOne, PROP_QNAME_RESIDUAL_ANY, (Serializable)nodeOne);
        NodeRef nodeOneCopy = this.copyService.copy(nodeOne, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copiedNodeOne"));
        Serializable propNodeRef = this.nodeService.getProperty(nodeOneCopy, PROP_QNAME_RESIDUAL_NODE_REF);
        CopyServiceImplTest.assertEquals((String)"Residual d:noderef not copied", (Object)nodeOne, (Object)propNodeRef);
        Serializable propAny = this.nodeService.getProperty(nodeOneCopy, PROP_QNAME_RESIDUAL_ANY);
        CopyServiceImplTest.assertEquals((String)"Residual d:any not copied", (Object)nodeOne, (Object)propAny);
    }

    public void testRelativeLinks() {
        QName nodeOneAssocName = QName.createQName((String)"{test}nodeOne");
        QName nodeTwoAssocName = QName.createQName((String)"{test}nodeTwo");
        QName nodeThreeAssocName = QName.createQName((String)"{test}nodeThree");
        QName nodeFourAssocName = QName.createQName((String)"{test}nodeFour");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, nodeOneAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, TEST_CHILD_ASSOC_TYPE_QNAME, nodeTwoAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeThree = this.nodeService.createNode(nodeTwo, TEST_CHILD_ASSOC_TYPE_QNAME, nodeThreeAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeFour = this.nodeService.createNode(nodeOne, TEST_CHILD_ASSOC_TYPE_QNAME, nodeFourAssocName, TEST_TYPE_QNAME).getChildRef();
        this.nodeService.addChild(nodeFour, nodeThree, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME);
        this.nodeService.createAssociation(nodeTwo, nodeThree, TEST_ASSOC_TYPE_QNAME);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", (Serializable)nodeTwo);
        params.put("assoc-type", (Serializable)TEST_CHILD_ASSOC_TYPE_QNAME);
        params.put("assoc-name", (Serializable)QName.createQName((String)"{test}ruleCopy"));
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        Action action = this.actionService.createAction("copy", params);
        ActionCondition condition = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(condition);
        rule.setAction(action);
        this.ruleService.saveRule(nodeOne, rule);
        NodeRef nodeOneCopy = this.copyService.copy(nodeOne, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copiedNodeOne"), true);
        NodeRef nodeTwoCopy = null;
        NodeRef nodeThreeCopy = null;
        NodeRef nodeFourCopy = null;
        List nodeOneCopyChildren = this.nodeService.getChildAssocs(nodeOneCopy);
        CopyServiceImplTest.assertNotNull((Object)nodeOneCopyChildren);
        CopyServiceImplTest.assertEquals((int)3, (int)nodeOneCopyChildren.size());
        for (ChildAssociationRef nodeOneCopyChild : nodeOneCopyChildren) {
            if (nodeOneCopyChild.getQName().equals((Object)nodeTwoAssocName)) {
                nodeTwoCopy = nodeOneCopyChild.getChildRef();
                List nodeTwoCopyChildren = this.nodeService.getChildAssocs(nodeTwoCopy);
                CopyServiceImplTest.assertNotNull((Object)nodeTwoCopyChildren);
                CopyServiceImplTest.assertEquals((int)1, (int)nodeTwoCopyChildren.size());
                for (ChildAssociationRef nodeTwoCopyChild : nodeTwoCopyChildren) {
                    if (!nodeTwoCopyChild.getQName().equals((Object)nodeThreeAssocName)) continue;
                    nodeThreeCopy = nodeTwoCopyChild.getChildRef();
                }
                continue;
            }
            if (!nodeOneCopyChild.getQName().equals((Object)nodeFourAssocName)) continue;
            nodeFourCopy = nodeOneCopyChild.getChildRef();
        }
        CopyServiceImplTest.assertNotNull(nodeTwoCopy);
        CopyServiceImplTest.assertNotNull(nodeThreeCopy);
        CopyServiceImplTest.assertNotNull(nodeFourCopy);
        List children = this.nodeService.getChildAssocs(nodeFourCopy, RegexQNamePattern.MATCH_ALL, (QNamePattern)TEST_CHILD_ASSOC_QNAME);
        CopyServiceImplTest.assertNotNull((Object)children);
        CopyServiceImplTest.assertEquals((int)1, (int)children.size());
        ChildAssociationRef child = (ChildAssociationRef)children.get(0);
        CopyServiceImplTest.assertEquals((Object)child.getChildRef(), (Object)nodeThree);
        List<Rule> rules = this.ruleService.getRules(nodeOneCopy);
        CopyServiceImplTest.assertNotNull(rules);
        CopyServiceImplTest.assertEquals((int)1, (int)rules.size());
        Rule copiedRule = rules.get(0);
        CopyServiceImplTest.assertNotNull((Object)copiedRule);
        Action ruleAction = copiedRule.getAction();
        CopyServiceImplTest.assertNotNull((Object)ruleAction);
        NodeRef value = (NodeRef)ruleAction.getParameterValue("destination-folder");
        CopyServiceImplTest.assertNotNull((Object)value);
        CopyServiceImplTest.assertEquals((Object)nodeTwoCopy, (Object)value);
    }

    public void testCopyAndRename() {
        NodeRef copy = this.copyService.copyAndRename(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc"), false);
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, false);
        CopyServiceImplTest.assertTrue((boolean)TEST_NAME.equals(this.nodeService.getProperty(copy, ContentModel.PROP_NAME)));
        HashMap<QName, String> propsFolder = new HashMap<QName, String>(1);
        propsFolder.put(ContentModel.PROP_NAME, "tempFolder");
        NodeRef folderNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}tempFolder"), ContentModel.TYPE_FOLDER, propsFolder).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, TEST_NAME);
        NodeRef contentNode = this.nodeService.createNode(folderNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}renametest"), ContentModel.TYPE_CONTENT, props).getChildRef();
        NodeRef contentCopy = this.copyService.copy(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}bobbins"), false);
        CopyServiceImplTest.assertFalse((boolean)TEST_NAME.equals(this.nodeService.getProperty(contentCopy, ContentModel.PROP_NAME)));
    }

    public void testETWOONE_244() {
        HashMap<QName, String> propsFolder = new HashMap<QName, String>(1);
        propsFolder.put(ContentModel.PROP_NAME, "tempFolder");
        NodeRef folderNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"tempFolder"), ContentModel.TYPE_FOLDER, propsFolder).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "myDoc.txt");
        NodeRef contentNode = this.nodeService.createNode(folderNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDoc.txt"), ContentModel.TYPE_CONTENT, props).getChildRef();
        NodeRef copy = this.copyService.copyAndRename(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, null, false);
        CopyServiceImplTest.assertEquals((Object)"Copy of myDoc.txt", (Object)this.nodeService.getProperty(copy, ContentModel.PROP_NAME));
        QName copyQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Copy of myDoc.txt");
        CopyServiceImplTest.assertEquals((Object)copyQName, (Object)this.nodeService.getPrimaryParent(copy).getQName());
        copy = this.copyService.copyAndRename(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, null, false);
        CopyServiceImplTest.assertEquals((Object)"Copy of Copy of myDoc.txt", (Object)this.nodeService.getProperty(copy, ContentModel.PROP_NAME));
        copyQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Copy of Copy of myDoc.txt");
        CopyServiceImplTest.assertEquals((Object)copyQName, (Object)this.nodeService.getPrimaryParent(copy).getQName());
        copy = this.copyService.copyAndRename(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, null, false);
        CopyServiceImplTest.assertEquals((Object)"Copy of Copy of Copy of myDoc.txt", (Object)this.nodeService.getProperty(copy, ContentModel.PROP_NAME));
        copyQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Copy of Copy of Copy of myDoc.txt");
        CopyServiceImplTest.assertEquals((Object)copyQName, (Object)this.nodeService.getPrimaryParent(copy).getQName());
    }

    private void checkCopiedNode(NodeRef sourceNodeRef, NodeRef destinationNodeRef, boolean newCopy, boolean sameStore, boolean copyChildren) {
        int expectedSize;
        if (newCopy) {
            if (sameStore) {
                boolean hasCopyAspect = this.nodeService.hasAspect(destinationNodeRef, ContentModel.ASPECT_COPIEDFROM);
                CopyServiceImplTest.assertTrue((String)("Missing aspect: " + ContentModel.ASPECT_COPIEDFROM), (boolean)hasCopyAspect);
                NodeRef copyNodeRef = (NodeRef)this.nodeService.getProperty(destinationNodeRef, ContentModel.PROP_COPY_REFERENCE);
                CopyServiceImplTest.assertNotNull((Object)copyNodeRef);
                CopyServiceImplTest.assertEquals((Object)sourceNodeRef, (Object)copyNodeRef);
            } else {
                CopyServiceImplTest.assertEquals((String)sourceNodeRef.getId(), (String)destinationNodeRef.getId());
            }
        }
        boolean hasTestAspect = this.nodeService.hasAspect(destinationNodeRef, TEST_ASPECT_QNAME);
        CopyServiceImplTest.assertTrue((boolean)hasTestAspect);
        Map destinationProperties = this.nodeService.getProperties(destinationNodeRef);
        CopyServiceImplTest.assertNotNull((Object)destinationProperties);
        String value1 = (String)destinationProperties.get(PROP1_QNAME_MANDATORY);
        CopyServiceImplTest.assertNotNull((Object)value1);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_1, (String)value1);
        String value2 = (String)destinationProperties.get(PROP2_QNAME_OPTIONAL);
        CopyServiceImplTest.assertNotNull((Object)value2);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_2, (String)value2);
        String value3 = (String)destinationProperties.get(PROP3_QNAME_MANDATORY);
        CopyServiceImplTest.assertNotNull((Object)value3);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_1, (String)value3);
        String value4 = (String)destinationProperties.get(PROP4_QNAME_OPTIONAL);
        CopyServiceImplTest.assertNotNull((Object)value4);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_2, (String)value4);
        List childAssocRefs = this.nodeService.getChildAssocs(destinationNodeRef);
        CopyServiceImplTest.assertNotNull((Object)childAssocRefs);
        int n = expectedSize = copyChildren ? 2 : 0;
        if (this.nodeService.hasAspect(destinationNodeRef, RuleModel.ASPECT_RULES)) {
            ++expectedSize;
        }
        CopyServiceImplTest.assertEquals((int)expectedSize, (int)childAssocRefs.size());
        for (ChildAssociationRef ref : childAssocRefs) {
            if (ref.getQName().equals((Object)TEST_CHILD_ASSOC_QNAME2)) {
                CopyServiceImplTest.assertFalse((boolean)ref.isPrimary());
                CopyServiceImplTest.assertEquals((Object)this.nonPrimaryChildNodeRef, (Object)ref.getChildRef());
                continue;
            }
            if (!copyChildren) {
                if (ref.getTypeQName().equals((Object)RuleModel.ASSOC_RULE_FOLDER)) {
                    CopyServiceImplTest.assertTrue((boolean)ref.isPrimary());
                    CopyServiceImplTest.assertTrue((!this.childNodeRef.equals((Object)ref.getChildRef()) ? 1 : 0) != 0);
                    continue;
                }
                CopyServiceImplTest.assertFalse((boolean)ref.isPrimary());
                CopyServiceImplTest.assertEquals((Object)this.childNodeRef, (Object)ref.getChildRef());
                continue;
            }
            CopyServiceImplTest.assertTrue((boolean)ref.isPrimary());
            CopyServiceImplTest.assertTrue((!this.childNodeRef.equals((Object)ref.getChildRef()) ? 1 : 0) != 0);
        }
    }
}

