/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.io.IOException;
import java.util.Properties;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.descriptor.DescriptorServiceImpl;
import org.alfresco.service.descriptor.Descriptor;
import org.springframework.core.io.Resource;

public class ServerDescriptorDAOImpl
implements DescriptorDAO {
    private String repositoryName;
    protected Properties serverProperties;

    public void setRepositoryName(String repositoryName) throws IOException {
        this.repositoryName = repositoryName;
    }

    public void setResource(Resource descriptorResource) throws IOException {
        this.serverProperties = new Properties();
        this.serverProperties.load(descriptorResource.getInputStream());
    }

    public Descriptor getDescriptor() {
        return new ServerDescriptor();
    }

    public byte[] getLicenseKey() {
        throw new UnsupportedOperationException();
    }

    public Descriptor updateDescriptor(Descriptor serverDescriptor) {
        throw new UnsupportedOperationException();
    }

    public void updateLicenseKey(byte[] key) {
        throw new UnsupportedOperationException();
    }

    private class ServerDescriptor
    extends DescriptorServiceImpl.BaseDescriptor {
        private ServerDescriptor() {
        }

        public String getId() {
            return "Unknown";
        }

        public String getName() {
            return ServerDescriptorDAOImpl.this.repositoryName == null ? "<Unknown>" : ServerDescriptorDAOImpl.this.repositoryName;
        }

        public String getVersionMajor() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.major");
        }

        public String getVersionMinor() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.minor");
        }

        public String getVersionRevision() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.revision");
        }

        public String getVersionLabel() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.label");
        }

        public String getVersionBuild() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.build");
        }

        public String getEdition() {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.edition");
        }

        public int getSchema() {
            return this.getSchema(ServerDescriptorDAOImpl.this.serverProperties.getProperty("version.schema"));
        }

        public String[] getDescriptorKeys() {
            String[] keys = new String[ServerDescriptorDAOImpl.this.serverProperties.size()];
            ServerDescriptorDAOImpl.this.serverProperties.keySet().toArray(keys);
            return keys;
        }

        public String getDescriptor(String key) {
            return ServerDescriptorDAOImpl.this.serverProperties.getProperty(key, "");
        }
    }
}

