/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.activities.ibatis;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.ibatis.IBatisSqlMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityFeedDAOImpl
extends IBatisSqlMapper
implements ActivityFeedDAO {
    @Override
    public long insertFeedEntry(ActivityFeedEntity activityFeed) throws SQLException {
        Long id = (Long)this.getSqlMapClient().insert("alfresco.activities.insert_activity_feed", (Object)activityFeed);
        return id != null ? id : -1L;
    }

    @Override
    public int deleteFeedEntries(Date keepDate) throws SQLException {
        return this.getSqlMapClient().delete("alfresco.activities.delete_activity_feed_entries_older_than_date", (Object)keepDate);
    }

    @Override
    public int deleteSiteFeedEntries(String siteId, String format, Date keepDate) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setSiteNetwork(siteId);
        params.setActivitySummaryFormat(format);
        params.setPostDate(keepDate);
        return this.getSqlMapClient().delete("alfresco.activities.delete_activity_feed_for_site_entries_older_than_date", (Object)params);
    }

    @Override
    public int deleteUserFeedEntries(String feedUserId, String format, Date keepDate) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setFeedUserId(feedUserId);
        params.setActivitySummaryFormat(format);
        params.setPostDate(keepDate);
        return this.getSqlMapClient().delete("alfresco.activities.delete_activity_feed_for_feeduser_entries_older_than_date", (Object)params);
    }

    @Override
    public List<ActivityFeedEntity> selectFeedsToClean(int maxFeedSize) throws SQLException {
        return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_greater_than_max", (Object)maxFeedSize);
    }

    @Override
    public List<ActivityFeedEntity> selectUserFeedEntries(String feedUserId, String format, String siteId, boolean excludeThisUser, boolean excludeOtherUsers) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setFeedUserId(feedUserId);
        params.setActivitySummaryFormat(format);
        if (siteId != null) {
            params.setSiteNetwork(siteId);
            if (excludeThisUser && excludeOtherUsers) {
                return new ArrayList<ActivityFeedEntity>(0);
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_for_feeduser_and_site", (Object)params);
            }
            if (excludeThisUser && !excludeOtherUsers) {
                return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_for_feeduser_others_and_site", (Object)params);
            }
            if (excludeOtherUsers && !excludeThisUser) {
                return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_for_feeduser_me_and_site", (Object)params);
            }
        } else {
            if (excludeThisUser && excludeOtherUsers) {
                return new ArrayList<ActivityFeedEntity>(0);
            }
            if (!excludeThisUser && !excludeOtherUsers) {
                return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_for_feeduser", (Object)params);
            }
            if (excludeThisUser) {
                return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_for_feeduser_others", (Object)params);
            }
            if (excludeOtherUsers) {
                return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_for_feeduser_me", (Object)params);
            }
        }
        throw new AlfrescoRuntimeException("Unexpected: invalid arguments");
    }

    @Override
    public List<ActivityFeedEntity> selectSiteFeedEntries(String siteId, String format) throws SQLException {
        ActivityFeedEntity params = new ActivityFeedEntity();
        params.setSiteNetwork(siteId);
        params.setActivitySummaryFormat(format);
        return this.getSqlMapClient().queryForList("alfresco.activities.select_activity_feed_for_site", (Object)params);
    }
}

