/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.mimetype.ibatis;

import org.alfresco.repo.domain.mimetype.AbstractMimetypeDAOImpl;
import org.alfresco.repo.domain.mimetype.MimetypeEntity;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class MimetypeDAOImpl
extends AbstractMimetypeDAOImpl {
    private static final String SELECT_MIMETYPE_BY_ID = "alfresco.content.select_MimetypeById";
    private static final String SELECT_MIMETYPE_BY_KEY = "alfresco.content.select_MimetypeByKey";
    private static final String INSERT_MIMETYPE = "alfresco.content.insert_Mimetype";
    private static final String UPDATE_MIMETYPE = "alfresco.content.update_Mimetype";
    private SqlMapClientTemplate template;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    protected MimetypeEntity getMimetypeEntity(Long id) {
        MimetypeEntity mimetypeEntity = new MimetypeEntity();
        mimetypeEntity.setId(id);
        mimetypeEntity = (MimetypeEntity)this.template.queryForObject(SELECT_MIMETYPE_BY_ID, (Object)mimetypeEntity);
        return mimetypeEntity;
    }

    protected MimetypeEntity getMimetypeEntity(String mimetype) {
        MimetypeEntity mimetypeEntity = new MimetypeEntity();
        mimetypeEntity.setMimetype(mimetype == null ? null : mimetype.toLowerCase());
        mimetypeEntity = (MimetypeEntity)this.template.queryForObject(SELECT_MIMETYPE_BY_KEY, (Object)mimetypeEntity);
        return mimetypeEntity;
    }

    protected MimetypeEntity createMimetypeEntity(String mimetype) {
        MimetypeEntity mimetypeEntity = new MimetypeEntity();
        mimetypeEntity.setVersion(MimetypeEntity.CONST_LONG_ZERO);
        mimetypeEntity.setMimetype(mimetype == null ? null : mimetype.toLowerCase());
        Long id = (Long)this.template.insert(INSERT_MIMETYPE, (Object)mimetypeEntity);
        mimetypeEntity.setId(id);
        return mimetypeEntity;
    }

    protected int updateMimetypeEntity(Long id, String newMimetype) {
        MimetypeEntity mimetypeEntity = this.getMimetypeEntity(id);
        if (mimetypeEntity == null) {
            throw new DataIntegrityViolationException("Cannot update mimetype as ID doesn't exist: " + id);
        }
        mimetypeEntity.incrementVersion();
        mimetypeEntity.setMimetype(newMimetype);
        return this.template.update(UPDATE_MIMETYPE, (Object)mimetypeEntity);
    }
}

