/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.BatchingDAO;
import org.alfresco.ibatis.RetryingCallbackHelper;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeAspectsEntity;
import org.alfresco.repo.domain.node.NodeAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.node.NodeUpdateEntity;
import org.alfresco.repo.domain.node.ParentAssocsInfo;
import org.alfresco.repo.domain.node.ReferenceablePropertiesEntity;
import org.alfresco.repo.domain.node.ServerEntity;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.domain.node.TransactionEntity;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionAwareSingleton;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.ReadOnlyServerException;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.ReadWriteLockExecuter;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeDAOImpl
implements NodeDAO,
BatchingDAO {
    private static final String CACHE_REGION_ROOT_NODES = "N.RN";
    private static final String CACHE_REGION_NODES = "N.N";
    private static final String CACHE_REGION_ASPECTS = "N.A";
    private static final String CACHE_REGION_PROPERTIES = "N.P";
    private static final String CACHE_REGION_PARENT_ASSOCS = "N.PA";
    private Log logger = LogFactory.getLog(this.getClass());
    private Log loggerPaths = LogFactory.getLog((String)(this.getClass().getName() + ".paths"));
    private boolean isDebugEnabled = this.logger.isDebugEnabled();
    private NodePropertyHelper nodePropertyHelper;
    private ServerIdCallback serverIdCallback = new ServerIdCallback();
    private UpdateTransactionListener updateTransactionListener = new UpdateTransactionListener();
    private RetryingCallbackHelper childAssocRetryingHelper = new RetryingCallbackHelper();
    private DictionaryService dictionaryService;
    private BehaviourFilter policyBehaviourFilter;
    private AclDAO aclDAO;
    private AccessControlListDAO accessControlListDAO;
    private ControlDAO controlDAO;
    private QNameDAO qnameDAO;
    private ContentDataDAO contentDataDAO;
    private LocaleDAO localeDAO;
    private UsageDAO usageDAO;
    private EntityLookupCache<StoreRef, Node, Serializable> rootNodesCache;
    private EntityLookupCache<Long, Node, NodeRef> nodesCache;
    private EntityLookupCache<Long, Set<QName>, Serializable> aspectsCache;
    private EntityLookupCache<Long, Map<QName, Serializable>, Serializable> propertiesCache;
    private EntityLookupCache<Long, ParentAssocsInfo, Serializable> parentAssocsCache;
    private static final String KEY_TRANSACTION = "node.transaction.id";
    public static final Long LONG_ZERO = 0L;

    public AbstractNodeDAOImpl() {
        this.childAssocRetryingHelper.setRetryWaitMs(10);
        this.childAssocRetryingHelper.setMaxRetries(5);
        this.rootNodesCache = new EntityLookupCache<StoreRef, Node, Serializable>(new RootNodesCacheCallbackDAO());
        this.nodesCache = new EntityLookupCache<Long, Node, NodeRef>(new NodesCacheCallbackDAO());
        this.aspectsCache = new EntityLookupCache<Long, Set<QName>, Serializable>(new AspectsCallbackDAO());
        this.propertiesCache = new EntityLookupCache<Long, Map<QName, Serializable>, Serializable>(new PropertiesCallbackDAO());
        this.parentAssocsCache = new EntityLookupCache<Long, ParentAssocsInfo, Serializable>(new ParentAssocsCallbackDAO());
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setAclDAO(AclDAO aclDAO) {
        this.aclDAO = aclDAO;
    }

    public void setAccessControlListDAO(AccessControlListDAO accessControlListDAO) {
        this.accessControlListDAO = accessControlListDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void setUsageDAO(UsageDAO usageDAO) {
        this.usageDAO = usageDAO;
    }

    public void setRootNodesCache(SimpleCache<Serializable, Serializable> cache) {
        this.rootNodesCache = new EntityLookupCache<StoreRef, Node, Serializable>(cache, CACHE_REGION_ROOT_NODES, new RootNodesCacheCallbackDAO());
    }

    public void setNodesCache(SimpleCache<Serializable, Serializable> cache) {
        this.nodesCache = new EntityLookupCache<Long, Node, NodeRef>(cache, CACHE_REGION_NODES, new NodesCacheCallbackDAO());
    }

    public void setAspectsCache(SimpleCache<Long, Set<QName>> aspectsCache) {
        this.aspectsCache = new EntityLookupCache<Long, Set<QName>, Serializable>(aspectsCache, CACHE_REGION_ASPECTS, new AspectsCallbackDAO());
    }

    public void setPropertiesCache(SimpleCache<Long, Map<QName, Serializable>> propertiesCache) {
        this.propertiesCache = new EntityLookupCache<Long, Map<QName, Serializable>, Serializable>(propertiesCache, CACHE_REGION_PROPERTIES, new PropertiesCallbackDAO());
    }

    public void setParentAssocsCache(SimpleCache<Long, ParentAssocsInfo> parentAssocsCache) {
        this.parentAssocsCache = new EntityLookupCache<Long, ParentAssocsInfo, Serializable>(parentAssocsCache, CACHE_REGION_PARENT_ASSOCS, new ParentAssocsCallbackDAO());
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"aclDAO", (Object)this.aclDAO);
        PropertyCheck.mandatory((Object)this, (String)"accessControlListDAO", (Object)this.accessControlListDAO);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)this, (String)"contentDataDAO", (Object)this.contentDataDAO);
        PropertyCheck.mandatory((Object)this, (String)"localeDAO", (Object)this.localeDAO);
        PropertyCheck.mandatory((Object)this, (String)"usageDAO", (Object)this.usageDAO);
        this.nodePropertyHelper = new NodePropertyHelper(this.dictionaryService, this.qnameDAO, this.localeDAO, this.contentDataDAO);
    }

    private Long getServerId() {
        return (Long)this.serverIdCallback.execute();
    }

    private void invalidateCachesByNodeId(Long parentNodeId, Long childNodeId, EntityLookupCache<Long, ? extends Object, ? extends Serializable> cache) {
        this.invalidateCachesByNodeId(parentNodeId, childNodeId, Collections.singletonList(cache));
    }

    private void invalidateCachesByNodeId(Long parentNodeId, Long childNodeId, final List<EntityLookupCache<Long, ? extends Object, ? extends Serializable>> caches) {
        if (childNodeId != null) {
            for (EntityLookupCache<Long, ? extends Object, ? extends Serializable> cache : caches) {
                cache.removeByKey(childNodeId);
            }
        }
        if (parentNodeId != null) {
            NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){
                private int count = 0;
                private boolean isClearOn = false;

                @Override
                public boolean preLoadNodes() {
                    return false;
                }

                @Override
                public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                    if (this.isClearOn) {
                        return false;
                    }
                    if (this.count >= 1000) {
                        for (EntityLookupCache cache : caches) {
                            cache.clear();
                        }
                        this.isClearOn = true;
                        return false;
                    }
                    ++this.count;
                    for (EntityLookupCache cache : caches) {
                        cache.removeByKey((Serializable)childNodePair.getFirst());
                    }
                    return true;
                }

                @Override
                public void done() {
                }
            };
            this.selectChildAssocs(parentNodeId, null, null, null, null, null, callback);
        }
    }

    private TransactionEntity getCurrentTransaction() {
        TransactionEntity txn = (TransactionEntity)AlfrescoTransactionSupport.getResource(KEY_TRANSACTION);
        if (txn != null) {
            return txn;
        }
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            throw new ReadOnlyServerException();
        }
        Long serverId = this.getServerId();
        Long now = System.currentTimeMillis();
        String changeTxnId = AlfrescoTransactionSupport.getTransactionId();
        Long txnId = this.insertTransaction(serverId, changeTxnId, now);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Create txn: " + txnId));
        }
        txn = new TransactionEntity();
        txn.setId(txnId);
        txn.setChangeTxnId(changeTxnId);
        txn.setCommitTimeMs(now);
        ServerEntity server = new ServerEntity();
        server.setId(serverId);
        txn.setServer(server);
        AlfrescoTransactionSupport.bindResource(KEY_TRANSACTION, txn);
        AlfrescoTransactionSupport.bindListener(this.updateTransactionListener);
        return txn;
    }

    @Override
    public Long getCurrentTransactionId() {
        TransactionEntity txn = this.getCurrentTransaction();
        return txn.getId();
    }

    @Override
    public List<Pair<Long, StoreRef>> getStores() {
        List<StoreEntity> storeEntities = this.selectAllStores();
        ArrayList<Pair<Long, StoreRef>> storeRefs = new ArrayList<Pair<Long, StoreRef>>(storeEntities.size());
        for (StoreEntity storeEntity : storeEntities) {
            storeRefs.add((Pair<Long, StoreRef>)new Pair((Object)storeEntity.getId(), (Object)storeEntity.getStoreRef()));
        }
        return storeRefs;
    }

    private StoreEntity getStoreNotNull(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException(storeRef);
        }
        return ((Node)rootNodePair.getSecond()).getStore();
    }

    @Override
    public boolean exists(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        return rootNodePair != null;
    }

    @Override
    public Pair<Long, NodeRef> getRootNode(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException(storeRef);
        }
        return ((Node)rootNodePair.getSecond()).getNodePair();
    }

    @Override
    public Pair<Long, NodeRef> newStore(StoreRef storeRef) {
        StoreEntity store = new StoreEntity();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        Long storeId = this.insertStore(store);
        store.setId(storeId);
        Long aclId = this.aclDAO.createAccessControlList();
        NodeEntity rootNode = this.newNodeImpl(store, null, ContentModel.TYPE_STOREROOT, aclId, false, null);
        Long rootNodeId = rootNode.getId();
        this.addNodeAspects(rootNodeId, Collections.singleton(ContentModel.ASPECT_ROOT));
        store.setRootNode(rootNode);
        this.updateStoreRoot(store);
        this.rootNodesCache.setValue(storeRef, rootNode);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created store: \n   " + store));
        }
        return new Pair((Object)rootNode.getId(), (Object)rootNode.getNodeRef());
    }

    @Override
    public void moveStore(StoreRef oldStoreRef, StoreRef newStoreRef) {
        StoreEntity store = this.getStoreNotNull(oldStoreRef);
        store.setProtocol(newStoreRef.getProtocol());
        store.setIdentifier(newStoreRef.getIdentifier());
        int count = this.updateStore(store);
        if (count != 1) {
            throw new ConcurrencyFailureException("Store not updated: " + oldStoreRef);
        }
        this.rootNodesCache.removeByKey(oldStoreRef);
        this.nodesCache.clear();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Moved store: " + oldStoreRef + " --> " + newStoreRef));
        }
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> pair = this.nodesCache.getByValue(node);
        return pair != null && ((Node)pair.getSecond()).getDeleted() == false;
    }

    @Override
    public NodeRef.Status getNodeRefStatus(NodeRef nodeRef) {
        Node node = new NodeEntity(nodeRef);
        Pair<Long, Node> pair = this.nodesCache.getByValue(node);
        node = pair == null ? this.selectNodeByNodeRef(nodeRef, null) : (Node)pair.getSecond();
        if (node == null) {
            return null;
        }
        TransactionEntity txn = node.getTransaction();
        return new NodeRef.Status(nodeRef, txn.getChangeTxnId(), txn.getId(), node.getDeleted().booleanValue());
    }

    @Override
    public Pair<Long, NodeRef> getNodePair(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> pair = this.nodesCache.getByValue(node);
        return pair == null || ((Node)pair.getSecond()).getDeleted() != false ? null : ((Node)pair.getSecond()).getNodePair();
    }

    @Override
    public Pair<Long, NodeRef> getNodePair(Long nodeId) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        return pair == null || ((Node)pair.getSecond()).getDeleted() != false ? null : ((Node)pair.getSecond()).getNodePair();
    }

    private Node getNodeNotNull(Long nodeId) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        if (pair == null || ((Node)pair.getSecond()).getDeleted().booleanValue()) {
            throw new DataIntegrityViolationException("No live node exists for ID " + nodeId);
        }
        return (Node)pair.getSecond();
    }

    @Override
    public QName getNodeType(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId);
        Long nodeTypeQNameId = node.getTypeQNameId();
        return (QName)this.qnameDAO.getQName(nodeTypeQNameId).getSecond();
    }

    @Override
    public Long getNodeAclId(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId);
        return node.getAclId();
    }

    @Override
    public ChildAssocEntity newNode(Long parentNodeId, QName assocTypeQName, QName assocQName, StoreRef storeRef, String uuid, QName nodeTypeQName, String childNodeName, Map<QName, Serializable> auditableProperties) throws InvalidTypeException {
        AuditablePropertiesEntity auditableProps;
        boolean setAuditProps;
        AccessControlListProperties inheritedAcl;
        Assert.notNull((Object)parentNodeId, (String)"parentNodeId");
        Assert.notNull((Object)assocTypeQName, (String)"assocTypeQName");
        Assert.notNull((Object)assocQName, (String)"assocQName");
        Assert.notNull((Object)storeRef, (String)"storeRef");
        if (auditableProperties == null) {
            auditableProperties = Collections.emptyMap();
        }
        Node parentNode = this.getNodeNotNull(parentNodeId);
        Long parentAclId = parentNode.getAclId();
        Long childAclId = null;
        if (parentAclId != null && (inheritedAcl = this.aclDAO.getAccessControlListProperties(this.aclDAO.getInheritedAccessControlList(parentAclId))) != null) {
            childAclId = inheritedAcl.getId();
        }
        if (!(setAuditProps = (auditableProps = new AuditablePropertiesEntity()).setAuditValues(null, null, auditableProperties))) {
            auditableProps = null;
        }
        StoreEntity store = this.getStoreNotNull(storeRef);
        NodeEntity node = this.newNodeImpl(store, uuid, nodeTypeQName, childAclId, false, auditableProps);
        Long nodeId = node.getId();
        if (setAuditProps) {
            NodeRef nodeRef = node.getNodeRef();
            this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        }
        if (childNodeName == null) {
            childNodeName = node.getUuid();
        }
        ChildAssocEntity assoc = this.newChildAssocImpl(parentNodeId, nodeId, true, assocTypeQName, assocQName, childNodeName);
        boolean isRoot = false;
        boolean isStoreRoot = nodeTypeQName.equals((Object)ContentModel.TYPE_STOREROOT);
        ParentAssocsInfo parentAssocsInfo = new ParentAssocsInfo(isRoot, isStoreRoot, assoc);
        this.parentAssocsCache.setValue(nodeId, parentAssocsInfo);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created new node: \n   Node: " + node + "\n" + "   Assoc: " + assoc));
        }
        return assoc;
    }

    private NodeEntity newNodeImpl(StoreEntity store, String uuid, QName nodeTypeQName, Long aclId, boolean deleted, AuditablePropertiesEntity auditableProps) throws InvalidTypeException {
        NodeEntity node = new NodeEntity();
        node.setStore(store);
        if (uuid == null) {
            node.setUuid(GUID.generate());
        } else {
            node.setUuid(uuid);
        }
        Long typeQNameId = (Long)this.qnameDAO.getOrCreateQName(nodeTypeQName).getFirst();
        node.setTypeQNameId(typeQNameId);
        node.setAclId(aclId);
        node.setDeleted(deleted);
        TransactionEntity txn = this.getCurrentTransaction();
        node.setTransaction(txn);
        boolean addAuditableAspect = false;
        if (auditableProps != null) {
            node.setAuditableProperties(auditableProps);
            addAuditableAspect = true;
        } else if (AuditablePropertiesEntity.hasAuditableAspect(nodeTypeQName, this.dictionaryService)) {
            auditableProps = new AuditablePropertiesEntity();
            auditableProps.setAuditValues(null, null, true, 0L);
            node.setAuditableProperties(auditableProps);
            addAuditableAspect = true;
        }
        Long id = null;
        Savepoint savepoint = this.controlDAO.createSavepoint("newNodeImpl");
        try {
            id = this.insertNode(node);
            this.controlDAO.releaseSavepoint(savepoint);
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            NodeRef targetNodeRef = node.getNodeRef();
            NodeEntity deletedNode = this.selectNodeByNodeRef(targetNodeRef, true);
            if (deletedNode != null) {
                Long deletedNodeId = deletedNode.getId();
                this.deleteNodeById(deletedNodeId, true);
                id = this.insertNode(node);
            }
            throw new AlfrescoRuntimeException("Failed to insert new node: " + node, e);
        }
        node.setId(id);
        Set<QName> nodeAspects = null;
        if (addAuditableAspect && !deleted) {
            Long auditableAspectQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.ASPECT_AUDITABLE).getFirst();
            this.insertNodeAspect(id, auditableAspectQNameId);
            nodeAspects = Collections.singleton(ContentModel.ASPECT_AUDITABLE);
        } else {
            nodeAspects = Collections.emptySet();
        }
        node.lock();
        this.nodesCache.setValue(id, node);
        this.setNodeAspectsCached(id, nodeAspects);
        this.setNodePropertiesCached(id, Collections.<QName, Serializable>emptyMap());
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created new node: \n   " + node));
        }
        return node;
    }

    @Override
    public Pair<Long, ChildAssociationRef> moveNode(final Long childNodeId, final Long newParentNodeId, final QName assocTypeQName, final QName assocQName) {
        final Node newParentNode = this.getNodeNotNull(newParentNodeId);
        StoreEntity newParentStore = newParentNode.getStore();
        final Node childNode = this.getNodeNotNull(childNodeId);
        StoreEntity childStore = childNode.getStore();
        ChildAssocEntity primaryParentAssoc = this.getPrimaryParentAssocImpl(childNodeId);
        Long oldParentNodeId = primaryParentAssoc == null ? null : (primaryParentAssoc.getParentNode() == null ? null : primaryParentAssoc.getParentNode().getId());
        RetryingCallbackHelper.RetryingCallback<Integer> callback = new RetryingCallbackHelper.RetryingCallback<Integer>(){

            public Integer execute() throws Throwable {
                Savepoint savepoint = AbstractNodeDAOImpl.this.controlDAO.createSavepoint("DuplicateChildNodeNameException");
                String childNodeName = (String)((Object)AbstractNodeDAOImpl.this.getNodeProperty(childNodeId, ContentModel.PROP_NAME));
                if (childNodeName == null) {
                    childNodeName = childNode.getUuid();
                }
                try {
                    int updated = AbstractNodeDAOImpl.this.updatePrimaryParentAssocs(childNodeId, newParentNodeId, assocTypeQName, assocQName, childNodeName);
                    AbstractNodeDAOImpl.this.controlDAO.releaseSavepoint(savepoint);
                    return updated;
                }
                catch (Throwable e) {
                    AbstractNodeDAOImpl.this.controlDAO.rollbackToSavepoint(savepoint);
                    throw new DuplicateChildNodeNameException(newParentNode.getNodeRef(), assocTypeQName, childNodeName);
                }
            }
        };
        Integer updateCount = (Integer)this.childAssocRetryingHelper.doWithRetry((RetryingCallbackHelper.RetryingCallback)callback);
        if (updateCount > 0) {
            NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
            nodeUpdate.setId(childNodeId);
            if (!childStore.getId().equals(newParentStore.getId())) {
                nodeUpdate.setStore(newParentNode.getStore());
                nodeUpdate.setUpdateStore(true);
            }
            this.updateNodeImpl(childNode, nodeUpdate);
            this.invalidateCachesByNodeId(null, childNodeId, this.parentAssocsCache);
            this.getPaths(nodeUpdate.getNodePair(), false);
            this.accessControlListDAO.updateInheritance(childNodeId, oldParentNodeId, newParentNodeId);
        } else {
            this.invalidateCachesByNodeId(null, childNodeId, this.parentAssocsCache);
        }
        Pair<Long, ChildAssociationRef> assocPair = this.getPrimaryParentAssoc(childNodeId);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Moved node: " + assocPair));
        }
        return assocPair;
    }

    @Override
    public void updateNode(Long nodeId, StoreRef storeRef, String uuid, QName nodeTypeQName) {
        Node oldNode = this.getNodeNotNull(nodeId);
        if (storeRef == null) {
            storeRef = oldNode.getStore().getStoreRef();
        }
        if (uuid == null) {
            uuid = oldNode.getUuid();
        }
        if (nodeTypeQName == null) {
            Long nodeTypeQNameId = oldNode.getTypeQNameId();
            nodeTypeQName = (QName)this.qnameDAO.getQName(nodeTypeQNameId).getSecond();
        }
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        if (!storeRef.equals((Object)oldNode.getStore().getStoreRef())) {
            StoreEntity store = this.getStoreNotNull(storeRef);
            nodeUpdate.setStore(store);
            nodeUpdate.setUpdateStore(true);
        } else {
            nodeUpdate.setStore(oldNode.getStore());
        }
        if (!uuid.equals(oldNode.getUuid())) {
            nodeUpdate.setUuid(uuid);
            nodeUpdate.setUpdateUuid(true);
        } else {
            nodeUpdate.setUuid(oldNode.getUuid());
        }
        Long nodeTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(nodeTypeQName).getFirst();
        if (!nodeTypeQNameId.equals(oldNode.getTypeQNameId())) {
            nodeUpdate.setTypeQNameId(nodeTypeQNameId);
            nodeUpdate.setUpdateTypeQNameId(true);
        }
        this.updateNodeImpl(oldNode, nodeUpdate);
    }

    private void touchNodeImpl(Long nodeId) {
        this.touchNodeImpl(nodeId, null);
    }

    private void touchNodeImpl(Long nodeId, AuditablePropertiesEntity auditableProps) {
        Node node = null;
        try {
            node = this.getNodeNotNull(nodeId);
        }
        catch (DataIntegrityViolationException e) {
            return;
        }
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        if (auditableProps != null) {
            nodeUpdate.setAuditableProperties(auditableProps);
        }
        this.updateNodeImpl(node, nodeUpdate);
    }

    private void updateNodeImpl(Node oldNode, NodeUpdateEntity nodeUpdate) {
        Set<QName> nodeAspects;
        Long nodeId = oldNode.getId();
        if (!EqualsHelper.nullSafeEquals((Object)nodeId, (Object)nodeUpdate.getId())) {
            throw new IllegalArgumentException("NodeUpdateEntity node ID is not correct: " + nodeUpdate);
        }
        if (!nodeUpdate.isUpdateStore()) {
            nodeUpdate.setStore(oldNode.getStore());
        }
        if (!nodeUpdate.isUpdateUuid()) {
            nodeUpdate.setUuid(oldNode.getUuid());
        }
        if (!nodeUpdate.isUpdateTypeQNameId()) {
            nodeUpdate.setTypeQNameId(oldNode.getTypeQNameId());
        }
        if (!nodeUpdate.isUpdateAclId()) {
            nodeUpdate.setAclId(oldNode.getAclId());
        }
        if (!nodeUpdate.isUpdateDeleted()) {
            nodeUpdate.setDeleted(oldNode.getDeleted());
        }
        boolean updateReference = nodeUpdate.isUpdateStore() || nodeUpdate.isUpdateUuid();
        nodeUpdate.setVersion(oldNode.getVersion());
        TransactionEntity txn = this.getCurrentTransaction();
        nodeUpdate.setTransaction(txn);
        if (!txn.getId().equals(oldNode.getTransaction().getId())) {
            nodeUpdate.setUpdateTransaction(true);
        }
        if ((nodeAspects = this.getNodeAspects(nodeId)).contains(ContentModel.ASPECT_AUDITABLE)) {
            AuditablePropertiesEntity auditableProps;
            NodeRef oldNodeRef = oldNode.getNodeRef();
            if (this.policyBehaviourFilter.isEnabled(oldNodeRef, ContentModel.ASPECT_AUDITABLE)) {
                auditableProps = oldNode.getAuditableProperties();
                if (auditableProps == null) {
                    auditableProps = new AuditablePropertiesEntity();
                }
                boolean updateAuditableProperties = auditableProps.setAuditValues(null, null, false, 1000L);
                nodeUpdate.setAuditableProperties(auditableProps);
                nodeUpdate.setUpdateAuditableProperties(updateAuditableProperties);
            } else if (nodeUpdate.getAuditableProperties() == null) {
                auditableProps = oldNode.getAuditableProperties();
                if (auditableProps != null) {
                    nodeUpdate.setAuditableProperties(auditableProps);
                    nodeUpdate.setUpdateAuditableProperties(true);
                }
            } else {
                nodeUpdate.setUpdateAuditableProperties(true);
            }
        } else {
            AuditablePropertiesEntity auditableProps = oldNode.getAuditableProperties();
            if (auditableProps != null) {
                nodeUpdate.setAuditableProperties(null);
                nodeUpdate.setUpdateAuditableProperties(true);
            }
        }
        if (!nodeUpdate.isUpdateAnything()) {
            return;
        }
        int count = 0;
        Savepoint savepoint = this.controlDAO.createSavepoint("updateNode");
        try {
            count = this.updateNode(nodeUpdate);
            this.controlDAO.releaseSavepoint(savepoint);
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            NodeRef targetNodeRef = nodeUpdate.getNodeRef();
            this.nodesCache.removeByKey(nodeId);
            this.nodesCache.removeByValue(nodeUpdate);
            if (updateReference) {
                try {
                    NodeEntity deletedNode;
                    NodeEntity liveNode = this.selectNodeByNodeRef(targetNodeRef, false);
                    if (liveNode != null) {
                        Long liveNodeId = liveNode.getId();
                        String liveNodeUuid = GUID.generate();
                        this.updateNode(liveNodeId, null, liveNodeUuid, null);
                    }
                    if ((deletedNode = this.selectNodeByNodeRef(targetNodeRef, true)) != null) {
                        Long deletedNodeId = deletedNode.getId();
                        this.deleteNodeById(deletedNodeId, true);
                    }
                    if (this.isDebugEnabled) {
                        this.logger.debug((Object)("Cleaned up target references for reference update: " + targetNodeRef));
                    }
                }
                catch (Throwable ee) {
                    this.logger.error((Object)("Failed to clean up target nodes for new reference: " + targetNodeRef), ee);
                    throw new RuntimeException("Failed to update node:" + nodeUpdate, e);
                }
                try {
                    nodeUpdate.setVersion(nodeUpdate.getVersion() - 1L);
                    count = this.updateNode(nodeUpdate);
                }
                catch (Throwable ee) {
                    throw new RuntimeException("Failed to update Node: " + nodeUpdate, e);
                }
            }
            throw new RuntimeException("Failed to update Node: " + nodeUpdate, e);
        }
        if (count != 1) {
            this.nodesCache.removeByKey(nodeId);
            this.nodesCache.removeByValue(nodeUpdate);
            throw new ConcurrencyFailureException("Failed to update node " + nodeId);
        }
        if (updateReference) {
            StoreEntity oldStore = oldNode.getStore();
            String oldUuid = oldNode.getUuid();
            this.newNodeImpl(oldStore, oldUuid, ContentModel.TYPE_CMOBJECT, null, true, null);
        }
        nodeUpdate.lock();
        this.nodesCache.setValue(nodeId, nodeUpdate);
        if (updateReference || nodeUpdate.isUpdateTypeQNameId()) {
            this.invalidateCachesByNodeId(nodeId, nodeId, this.parentAssocsCache);
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Updated Node: \n   OLD: " + oldNode + "\n" + "   NEW: " + nodeUpdate));
        }
    }

    @Override
    public void setNodeAclId(Long nodeId, Long aclId) {
        Node oldNode = this.getNodeNotNull(nodeId);
        NodeUpdateEntity nodeUpdateEntity = new NodeUpdateEntity();
        nodeUpdateEntity.setId(nodeId);
        nodeUpdateEntity.setAclId(aclId);
        nodeUpdateEntity.setUpdateAclId(true);
        this.updateNodeImpl(oldNode, nodeUpdateEntity);
    }

    @Override
    public void setPrimaryChildrenSharedAclId(Long primaryParentNodeId, Long optionalOldSharedAlcIdInAdditionToNull, Long newSharedAclId) {
        this.updatePrimaryChildrenSharedAclId(primaryParentNodeId, optionalOldSharedAlcIdInAdditionToNull, newSharedAclId);
        this.invalidateCachesByNodeId(primaryParentNodeId, null, this.nodesCache);
    }

    @Override
    public void setNodeDefiningAclId(Long nodeId, long aclId) {
        NodeUpdateEntity nodeUpdateEntity = new NodeUpdateEntity();
        nodeUpdateEntity.setId(nodeId);
        nodeUpdateEntity.setAclId(aclId);
        nodeUpdateEntity.setUpdateAclId(true);
        this.updateNodePatchAcl(nodeUpdateEntity);
        this.invalidateCachesByNodeId(null, nodeId, this.nodesCache);
    }

    @Override
    public void deleteNode(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId);
        Long aclId = node.getAclId();
        HashSet<QName> contentQNames = new HashSet<QName>(this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT));
        Set<Long> contentQNamesToRemoveIds = this.qnameDAO.convertQNamesToIds(contentQNames, false);
        this.contentDataDAO.deleteContentDataForNode(nodeId, contentQNamesToRemoveIds);
        this.usageDAO.deleteDeltas(nodeId);
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        nodeUpdate.setVersion(node.getVersion());
        TransactionEntity txn = this.getCurrentTransaction();
        nodeUpdate.setTransaction(txn);
        nodeUpdate.setUpdateTransaction(true);
        nodeUpdate.setAclId(null);
        nodeUpdate.setUpdateAclId(true);
        nodeUpdate.setDeleted(true);
        nodeUpdate.setUpdateDeleted(true);
        Set<QName> nodeAspects = this.getNodeAspects(nodeId);
        if (nodeAspects.contains(ContentModel.ASPECT_AUDITABLE)) {
            AuditablePropertiesEntity auditableProps = node.getAuditableProperties();
            if (auditableProps == null) {
                auditableProps = new AuditablePropertiesEntity();
            }
            auditableProps.setAuditValues(null, null, false, 1000L);
            nodeUpdate.setAuditableProperties(auditableProps);
            nodeUpdate.setUpdateAuditableProperties(true);
        }
        this.nodesCache.removeByKey(nodeId);
        this.deleteNodeAspects(nodeId, null);
        this.aspectsCache.removeByKey(nodeId);
        this.deleteNodeProperties(nodeId, (Set<Long>)null);
        this.propertiesCache.removeByKey(nodeId);
        this.invalidateCachesByNodeId(nodeId, nodeId, this.parentAssocsCache);
        this.deleteNodeAssocsToAndFrom(nodeId);
        this.deleteChildAssocsToAndFrom(nodeId);
        int count = this.updateNode(nodeUpdate);
        if (count != 1) {
            this.nodesCache.removeByValue(node);
            throw new ConcurrencyFailureException("Failed to update node: " + nodeUpdate);
        }
        if (aclId != null) {
            this.aclDAO.deleteAclForNode(aclId, false);
        }
    }

    @Override
    public int purgeNodes(long maxTxnCommitTimeMs) {
        return this.deleteNodesByCommitTime(true, maxTxnCommitTimeMs);
    }

    @Override
    public Map<QName, Serializable> getNodeProperties(Long nodeId) {
        Map<QName, Serializable> props = this.getNodePropertiesCached(nodeId);
        Node node = this.getNodeNotNull(nodeId);
        ReferenceablePropertiesEntity.addReferenceableProperties(node, props);
        if (this.hasNodeAspect(nodeId, ContentModel.ASPECT_AUDITABLE)) {
            AuditablePropertiesEntity auditableProperties = node.getAuditableProperties();
            if (auditableProperties == null) {
                auditableProperties = new AuditablePropertiesEntity();
            }
            props.putAll(auditableProperties.getAuditableProperties());
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Fetched properties for Node: \n   Node:  " + nodeId + "\n" + "   Props: " + props));
        }
        return props;
    }

    @Override
    public Serializable getNodeProperty(Long nodeId, QName propertyQName) {
        Serializable value = null;
        if (AuditablePropertiesEntity.isAuditableProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId);
            AuditablePropertiesEntity auditableProperties = node.getAuditableProperties();
            if (auditableProperties != null) {
                value = auditableProperties.getAuditableProperty(propertyQName);
            }
        } else if (ReferenceablePropertiesEntity.isReferenceableProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId);
            value = ReferenceablePropertiesEntity.getReferenceableProperty(node, propertyQName);
        } else {
            Map<QName, Serializable> props = this.getNodePropertiesCached(nodeId);
            value = props.get(propertyQName);
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Fetched property for Node: \n   Node:  " + nodeId + "\n" + "   QName: " + propertyQName + "\n" + "   Value: " + value));
        }
        return value;
    }

    private boolean setNodePropertiesImpl(Long nodeId, Map<QName, Serializable> newProps, boolean isAddOnly) {
        boolean updated;
        if (isAddOnly && newProps.size() == 0) {
            return false;
        }
        Node node = this.getNodeNotNull(nodeId);
        newProps = new HashMap<QName, Serializable>(newProps);
        AuditablePropertiesEntity auditableProps = null;
        if (!this.policyBehaviourFilter.isEnabled(node.getNodeRef(), ContentModel.ASPECT_AUDITABLE)) {
            boolean containedAuditProperties;
            auditableProps = node.getAuditableProperties();
            if (auditableProps == null) {
                auditableProps = new AuditablePropertiesEntity();
            }
            if (!(containedAuditProperties = auditableProps.setAuditValues(null, null, newProps))) {
                auditableProps = null;
            }
        }
        newProps.keySet().removeAll(AuditablePropertiesEntity.getAuditablePropertyQNames());
        ReferenceablePropertiesEntity.removeReferenceableProperties(node, newProps);
        Map<QName, Serializable> oldPropsCached = this.getNodePropertiesCached(nodeId);
        HashMap<QName, Serializable> oldProps = new HashMap<QName, Serializable>(oldPropsCached);
        if (isAddOnly) {
            oldProps.keySet().retainAll(newProps.keySet());
        }
        Map<NodePropertyKey, NodePropertyValue> newPropsRaw = this.nodePropertyHelper.convertToPersistentProperties(newProps);
        newProps = this.nodePropertyHelper.convertToPublicProperties(newPropsRaw);
        Map diff = EqualsHelper.getMapComparison(oldProps, newProps);
        HashSet<QName> propsToDelete = new HashSet<QName>(oldProps.size() * 2);
        HashMap<QName, Serializable> propsToAdd = new HashMap<QName, Serializable>(newProps.size() * 2);
        HashSet<QName> contentQNamesToDelete = new HashSet<QName>(5);
        block10: for (Map.Entry entry : diff.entrySet()) {
            QName qname = (QName)entry.getKey();
            PropertyDefinition removePropDef = this.dictionaryService.getProperty(qname);
            boolean isContent = removePropDef != null && removePropDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT);
            switch ((EqualsHelper.MapValueComparison)entry.getValue()) {
                case EQUAL: {
                    continue block10;
                }
                case LEFT_ONLY: {
                    propsToDelete.add(qname);
                    if (!isContent) continue block10;
                    contentQNamesToDelete.add(qname);
                    continue block10;
                }
                case NOT_EQUAL: {
                    propsToDelete.add(qname);
                    if (isContent) {
                        contentQNamesToDelete.add(qname);
                    }
                }
                case RIGHT_ONLY: {
                    Object value = newProps.get(qname);
                    if (isContent && value != null) {
                        ContentData newContentData = (ContentData)value;
                        Long newContentDataId = (Long)this.contentDataDAO.createContentData(newContentData).getFirst();
                        value = new ContentDataWithId(newContentData, newContentDataId);
                    }
                    propsToAdd.put(qname, (Serializable)value);
                    continue block10;
                }
            }
            throw new IllegalStateException("Unknown MapValueComparison: " + entry.getValue());
        }
        boolean bl = updated = propsToDelete.size() > 0 || propsToAdd.size() > 0;
        if (updated) {
            try {
                if (contentQNamesToDelete.size() > 0) {
                    Set<Long> contentQNameIdsToDelete = this.qnameDAO.convertQNamesToIds(contentQNamesToDelete, false);
                    this.contentDataDAO.deleteContentDataForNode(nodeId, contentQNameIdsToDelete);
                }
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to delete content properties: \n  Node:          " + nodeId + "\n" + "  Delete Tried:  " + contentQNamesToDelete, e);
            }
            try {
                Set<Long> propQNameIdsToDelete = this.qnameDAO.convertQNamesToIds(propsToDelete, true);
                this.deleteNodeProperties(nodeId, propQNameIdsToDelete);
                newPropsRaw = this.nodePropertyHelper.convertToPersistentProperties(propsToAdd);
                this.insertNodeProperties(nodeId, newPropsRaw);
            }
            catch (Throwable e) {
                this.propertiesCache.removeByKey(nodeId);
                throw new AlfrescoRuntimeException("Failed to write property deltas: \n  Node:          " + nodeId + "\n" + "  Old:           " + oldProps + "\n" + "  New:           " + newProps + "\n" + "  Diff:          " + diff + "\n" + "  Delete Tried:  " + propsToDelete + "\n" + "  Add Tried:     " + propsToAdd, e);
            }
            Map<QName, Serializable> propsToCache = null;
            if (isAddOnly) {
                propsToCache = oldPropsCached;
                propsToCache.putAll(propsToAdd);
            } else {
                propsToCache = newProps;
                propsToCache.putAll(propsToAdd);
            }
            this.setNodePropertiesCached(nodeId, propsToCache);
        }
        if (updated || auditableProps != null) {
            this.touchNodeImpl(nodeId, auditableProps);
        }
        if (this.isDebugEnabled && updated) {
            this.logger.debug((Object)("Modified node properties: " + nodeId + "\n" + "   Removed: " + propsToDelete + "\n" + "   Added:   " + propsToAdd));
        }
        return updated;
    }

    @Override
    public boolean setNodeProperties(Long nodeId, Map<QName, Serializable> properties) {
        boolean modified = this.setNodePropertiesImpl(nodeId, properties, false);
        return modified;
    }

    @Override
    public boolean addNodeProperty(Long nodeId, QName qname, Serializable value) {
        HashMap<QName, Serializable> newProps = new HashMap<QName, Serializable>(3);
        newProps.put(qname, value);
        boolean modified = this.setNodePropertiesImpl(nodeId, newProps, true);
        return modified;
    }

    @Override
    public boolean addNodeProperties(Long nodeId, Map<QName, Serializable> properties) {
        boolean modified = this.setNodePropertiesImpl(nodeId, properties, true);
        return modified;
    }

    @Override
    public boolean removeNodeProperties(Long nodeId, Set<QName> propertyQNames) {
        propertyQNames = new HashSet<QName>(propertyQNames);
        ReferenceablePropertiesEntity.removeReferenceableProperties(propertyQNames);
        if (propertyQNames.size() == 0) {
            return false;
        }
        Set<Long> qnameIds = this.qnameDAO.convertQNamesToIds(propertyQNames, false);
        int deleteCount = this.deleteNodeProperties(nodeId, qnameIds);
        if (deleteCount > 0) {
            Map<QName, Serializable> cachedProps = this.getNodePropertiesCached(nodeId);
            cachedProps.keySet().removeAll(propertyQNames);
            this.setNodePropertiesCached(nodeId, cachedProps);
            this.touchNodeImpl(nodeId);
        }
        return deleteCount > 0;
    }

    private Map<QName, Serializable> getNodePropertiesCached(Long nodeId) {
        Pair<Long, Map<QName, Serializable>> cacheEntry = this.propertiesCache.getByKey(nodeId);
        if (cacheEntry == null) {
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        Map cachedProperties = (Map)cacheEntry.getSecond();
        Map<QName, Serializable> properties = this.copyPropertiesAgainstModification(cachedProperties);
        return properties;
    }

    private void setNodePropertiesCached(Long nodeId, Map<QName, Serializable> properties) {
        properties = this.copyPropertiesAgainstModification(properties);
        this.propertiesCache.setValue(nodeId, Collections.unmodifiableMap(properties));
    }

    private Map<QName, Serializable> copyPropertiesAgainstModification(Map<QName, Serializable> original) {
        HashMap<QName, Serializable> copy = new HashMap<QName, Serializable>((int)((double)original.size() * 1.3));
        for (Map.Entry<QName, Serializable> element : original.entrySet()) {
            QName key = element.getKey();
            Serializable value = element.getValue();
            if (value instanceof Collection || value instanceof Map) {
                value = (Serializable)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)value));
            }
            copy.put(key, value);
        }
        return copy;
    }

    @Override
    public Set<QName> getNodeAspects(Long nodeId) {
        Set<QName> nodeAspects = this.getNodeAspectsCached(nodeId);
        nodeAspects.add(ContentModel.ASPECT_REFERENCEABLE);
        return nodeAspects;
    }

    @Override
    public boolean hasNodeAspect(Long nodeId, QName aspectQName) {
        if (aspectQName.equals((Object)ContentModel.ASPECT_REFERENCEABLE)) {
            return true;
        }
        Set<QName> nodeAspects = this.getNodeAspectsCached(nodeId);
        return nodeAspects.contains(aspectQName);
    }

    @Override
    public boolean addNodeAspects(Long nodeId, Set<QName> aspectQNames) {
        if (aspectQNames.size() == 0) {
            return false;
        }
        HashSet<QName> aspectQNamesToAdd = new HashSet<QName>(aspectQNames);
        Set<QName> existingAspectQNames = this.getNodeAspectsCached(nodeId);
        aspectQNamesToAdd.removeAll(existingAspectQNames);
        aspectQNamesToAdd.remove(ContentModel.ASPECT_REFERENCEABLE);
        if (aspectQNamesToAdd.isEmpty()) {
            return false;
        }
        Set<Long> aspectQNameIds = this.qnameDAO.convertQNamesToIds(aspectQNamesToAdd, true);
        this.startBatch();
        try {
            try {
                for (Long aspectQNameId : aspectQNameIds) {
                    this.insertNodeAspect(nodeId, aspectQNameId);
                }
                Object var9_9 = null;
            }
            catch (RuntimeException e) {
                this.aspectsCache.deleteByKey(nodeId);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.executeBatch();
            throw throwable;
        }
        this.executeBatch();
        HashSet<QName> newAspectQNames = new HashSet<QName>(existingAspectQNames);
        newAspectQNames.addAll(aspectQNamesToAdd);
        this.setNodeAspectsCached(nodeId, newAspectQNames);
        if (newAspectQNames.contains(ContentModel.ASPECT_ROOT)) {
            this.invalidateCachesByNodeId(null, nodeId, this.parentAssocsCache);
        }
        this.touchNodeImpl(nodeId);
        return true;
    }

    @Override
    public boolean removeNodeAspects(Long nodeId) {
        Set<QName> existingAspectQNames = this.getNodeAspectsCached(nodeId);
        if (existingAspectQNames.contains(ContentModel.ASPECT_ROOT)) {
            this.invalidateCachesByNodeId(null, nodeId, this.parentAssocsCache);
        }
        int deleteCount = this.deleteNodeAspects(nodeId, null);
        this.aspectsCache.setValue(nodeId, Collections.emptySet());
        this.touchNodeImpl(nodeId);
        return deleteCount > 0;
    }

    @Override
    public boolean removeNodeAspects(Long nodeId, Set<QName> aspectQNames) {
        Set<QName> existingAspectQNames = this.getNodeAspects(nodeId);
        Set<Long> aspectQNameIdsToRemove = this.qnameDAO.convertQNamesToIds(aspectQNames, false);
        int deleteCount = this.deleteNodeAspects(nodeId, aspectQNameIdsToRemove);
        HashSet<QName> newAspectQNames = new HashSet<QName>(existingAspectQNames);
        newAspectQNames.removeAll(aspectQNames);
        this.aspectsCache.setValue(nodeId, newAspectQNames);
        if (aspectQNames.contains(ContentModel.ASPECT_ROOT)) {
            this.invalidateCachesByNodeId(null, nodeId, this.parentAssocsCache);
        }
        this.touchNodeImpl(nodeId);
        return deleteCount > 0;
    }

    @Override
    public void getNodesWithAspect(QName aspectQName, Long minNodeId, int count, NodeDAO.NodeRefQueryCallback resultsCallback) {
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(aspectQName);
        if (qnamePair == null) {
            return;
        }
        Long qnameId = (Long)qnamePair.getFirst();
        this.selectNodesWithAspect(qnameId, minNodeId, resultsCallback);
    }

    private Set<QName> getNodeAspectsCached(Long nodeId) {
        Pair<Long, Set<QName>> cacheEntry = this.aspectsCache.getByKey(nodeId);
        if (cacheEntry == null) {
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        return new HashSet<QName>((Collection)cacheEntry.getSecond());
    }

    private void setNodeAspectsCached(Long nodeId, Set<QName> aspects) {
        this.aspectsCache.setValue(nodeId, Collections.unmodifiableSet(aspects));
    }

    @Override
    public Long newNodeAssoc(Long sourceNodeId, Long targetNodeId, QName assocTypeQName) {
        Long assocTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(assocTypeQName).getFirst();
        try {
            this.touchNodeImpl(sourceNodeId);
            return this.insertNodeAssoc(sourceNodeId, targetNodeId, assocTypeQNameId);
        }
        catch (Throwable e) {
            throw new AssociationExistsException(sourceNodeId, targetNodeId, assocTypeQName, e);
        }
    }

    @Override
    public int removeNodeAssoc(Long sourceNodeId, Long targetNodeId, QName assocTypeQName) {
        Pair<Long, QName> assocTypeQNamePair = this.qnameDAO.getQName(assocTypeQName);
        if (assocTypeQNamePair == null) {
            return 0;
        }
        this.touchNodeImpl(sourceNodeId);
        Long assocTypeQNameId = (Long)assocTypeQNamePair.getFirst();
        return this.deleteNodeAssoc(sourceNodeId, targetNodeId, assocTypeQNameId);
    }

    @Override
    public int removeNodeAssocsToAndFrom(Long nodeId) {
        this.touchNodeImpl(nodeId);
        return this.deleteNodeAssocsToAndFrom(nodeId);
    }

    @Override
    public int removeNodeAssocsToAndFrom(Long nodeId, Set<QName> assocTypeQNames) {
        Set<Long> assocTypeQNameIds = this.qnameDAO.convertQNamesToIds(assocTypeQNames, false);
        if (assocTypeQNameIds.size() == 0) {
            return 0;
        }
        this.touchNodeImpl(nodeId);
        return this.deleteNodeAssocsToAndFrom(nodeId, assocTypeQNameIds);
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getSourceNodeAssocs(Long targetNodeId) {
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocsByTarget(targetNodeId);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getTargetNodeAssocs(Long sourceNodeId) {
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocsBySource(sourceNodeId);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Pair<Long, AssociationRef> getNodeAssoc(Long assocId) {
        NodeAssocEntity nodeAssocEntity = this.selectNodeAssocById(assocId);
        if (nodeAssocEntity == null) {
            throw new ConcurrencyFailureException("Assoc ID does not point to a valid association: " + assocId);
        }
        AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
        return new Pair((Object)assocId, (Object)assocRef);
    }

    private ChildAssocEntity newChildAssocImpl(Long parentNodeId, Long childNodeId, boolean isPrimary, final QName assocTypeQName, QName assocQName, final String childNodeName) {
        Assert.notNull((Object)parentNodeId, (String)"parentNodeId");
        Assert.notNull((Object)childNodeId, (String)"childNodeId");
        Assert.notNull((Object)assocTypeQName, (String)"assocTypeQName");
        Assert.notNull((Object)assocQName, (String)"assocQName");
        Assert.notNull((Object)childNodeName, (String)"childNodeName");
        final Node parentNode = this.getNodeNotNull(parentNodeId);
        Node childNode = this.getNodeNotNull(childNodeId);
        final ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setParentNode(new NodeEntity(parentNode));
        assoc.setChildNode(new NodeEntity(childNode));
        assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, true);
        assoc.setChildNodeNameAll(this.dictionaryService, assocTypeQName, childNodeName);
        assoc.setQNameAll(this.qnameDAO, assocQName, true);
        assoc.setPrimary(isPrimary);
        assoc.setAssocIndex(-1);
        RetryingCallbackHelper.RetryingCallback<Long> callback = new RetryingCallbackHelper.RetryingCallback<Long>(){

            public Long execute() throws Throwable {
                try {
                    return AbstractNodeDAOImpl.this.insertChildAssoc(assoc);
                }
                catch (Throwable e) {
                    throw new DuplicateChildNodeNameException(parentNode.getNodeRef(), assocTypeQName, childNodeName);
                }
            }
        };
        Long assocId = (Long)this.childAssocRetryingHelper.doWithRetry((RetryingCallbackHelper.RetryingCallback)callback);
        assoc.setId(assocId);
        if (!isPrimary) {
            this.updateNode(childNodeId, null, null, null);
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created child association: " + assoc));
        }
        return assoc;
    }

    @Override
    public Pair<Long, ChildAssociationRef> newChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, String childNodeName) {
        ChildAssocEntity assoc = this.newChildAssocImpl(parentNodeId, childNodeId, false, assocTypeQName, assocQName, childNodeName);
        Long assocId = assoc.getId();
        ParentAssocsInfo parentAssocInfo = this.getParentAssocsCached(childNodeId);
        parentAssocInfo = parentAssocInfo.addAssoc(assocId, assoc);
        this.setParentAssocsCached(childNodeId, parentAssocInfo);
        return assoc.getPair(this.qnameDAO);
    }

    @Override
    public void deleteChildAssoc(Long assocId) {
        ChildAssocEntity assoc = this.selectChildAssoc(assocId);
        if (assoc == null) {
            throw new ConcurrencyFailureException("Child association not found: " + assocId);
        }
        Long childNodeId = assoc.getChildNode().getId();
        ParentAssocsInfo parentAssocInfo = this.getParentAssocsCached(childNodeId);
        parentAssocInfo = parentAssocInfo.removeAssoc(assocId);
        this.setParentAssocsCached(childNodeId, parentAssocInfo);
        int count = this.deleteChildAssocById(assocId);
        if (count != 1) {
            throw new ConcurrencyFailureException("Child association not deleted: " + assocId);
        }
    }

    @Override
    public int setChildAssocIndex(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, int index) {
        int count = this.updateChildAssocIndex(parentNodeId, childNodeId, assocTypeQName, assocQName, index);
        if (count > 0) {
            this.invalidateCachesByNodeId(null, childNodeId, this.parentAssocsCache);
        }
        return count;
    }

    @Override
    public void setChildAssocsUniqueName(final Long childNodeId, final String childName) {
        RetryingCallbackHelper.RetryingCallback<Integer> callback = new RetryingCallbackHelper.RetryingCallback<Integer>(){

            public Integer execute() throws Throwable {
                try {
                    return AbstractNodeDAOImpl.this.updateChildAssocsUniqueName(childNodeId, childName);
                }
                catch (Throwable e) {
                    throw new DuplicateChildNodeNameException(null, null, childName);
                }
            }
        };
        Integer count = (Integer)this.childAssocRetryingHelper.doWithRetry((RetryingCallbackHelper.RetryingCallback)callback);
        if (count > 0) {
            this.invalidateCachesByNodeId(null, childNodeId, this.parentAssocsCache);
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Updated cm:name to parent assocs: \n   Node:    " + childNodeId + "\n" + "   Name:    " + childName + "\n" + "   Updated: " + count));
        }
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long assocId) {
        ChildAssocEntity assoc = this.selectChildAssoc(assocId);
        if (assoc == null) {
            throw new ConcurrencyFailureException("Child association not found: " + assocId);
        }
        return assoc.getPair(this.qnameDAO);
    }

    @Override
    public List<NodeIdAndAclId> getPrimaryChildrenAcls(Long nodeId) {
        return this.selectPrimaryChildAcls(nodeId);
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName) {
        List<ChildAssocEntity> assocs = this.selectChildAssoc(parentNodeId, childNodeId, assocTypeQName, assocQName);
        if (assocs.size() == 0) {
            return null;
        }
        if (assocs.size() == 1) {
            return assocs.get(0).getPair(this.qnameDAO);
        }
        HashMap<Long, ChildAssocEntity> assocsToDeleteById = new HashMap<Long, ChildAssocEntity>(assocs.size() * 2);
        Long minId = null;
        Long primaryId = null;
        for (ChildAssocEntity assoc : assocs) {
            Long assocId = assoc.getId();
            assocsToDeleteById.put(assocId, assoc);
            if (minId == null || minId.compareTo(assocId) > 0) {
                minId = assocId;
            }
            if (!assoc.isPrimary().booleanValue()) continue;
            primaryId = assocId;
        }
        Long assocToKeepId = primaryId == null ? minId : primaryId;
        ChildAssocEntity assocToKeep = (ChildAssocEntity)assocsToDeleteById.remove(assocToKeepId);
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            for (Long assocIdToDelete : assocsToDeleteById.keySet()) {
                this.deleteChildAssoc(assocIdToDelete);
            }
        }
        return assocToKeep.getPair(this.qnameDAO);
    }

    @Override
    public void getChildAssocs(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, Boolean sameStore, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, childNodeId, assocTypeQName, assocQName, isPrimary, sameStore, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocs(Long parentNodeId, Set<QName> assocTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        switch (assocTypeQNames.size()) {
            case 0: {
                return;
            }
            case 1: {
                QName assocTypeQName = assocTypeQNames.iterator().next();
                this.selectChildAssocs(parentNodeId, null, assocTypeQName, null, null, null, new ChildAssocRefBatchingQueryCallback(resultsCallback));
                break;
            }
            default: {
                this.selectChildAssocs(parentNodeId, assocTypeQNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
            }
        }
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long parentNodeId, QName assocTypeQName, String childName) {
        ChildAssocEntity assoc = this.selectChildAssoc(parentNodeId, assocTypeQName, childName);
        return assoc == null ? null : assoc.getPair(this.qnameDAO);
    }

    @Override
    public void getChildAssocs(Long parentNodeId, QName assocTypeQName, Collection<String> childNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, assocTypeQName, childNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocsByPropertyValue(Long parentNodeId, QName propertyQName, Serializable value, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
        NodePropertyValue nodeValue = this.nodePropertyHelper.makeNodePropertyValue(propertyDef, value);
        if (nodeValue != null) {
            switch (nodeValue.getPersistedType()) {
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("method not supported for persisted value type " + nodeValue.getPersistedType());
                }
            }
            this.selectChildAssocsByPropertyValue(parentNodeId, propertyQName, nodeValue, new ChildAssocRefBatchingQueryCallback(resultsCallback));
        }
    }

    @Override
    public void getChildAssocsByChildTypes(Long parentNodeId, Set<QName> childNodeTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocsByChildTypes(parentNodeId, childNodeTypeQNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocsWithoutParentAssocsOfType(Long parentNodeId, QName assocTypeQName, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocsWithoutParentAssocsOfType(parentNodeId, assocTypeQName, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public Pair<Long, ChildAssociationRef> getPrimaryParentAssoc(Long childNodeId) {
        ChildAssocEntity childAssocEntity = this.getPrimaryParentAssocImpl(childNodeId);
        if (childAssocEntity == null) {
            return null;
        }
        return childAssocEntity.getPair(this.qnameDAO);
    }

    private ChildAssocEntity getPrimaryParentAssocImpl(Long childNodeId) {
        ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
        return parentAssocs.getPrimaryParentAssoc();
    }

    @Override
    public void getParentAssocs(Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        if (assocTypeQName == null && assocQName == null && isPrimary == null) {
            ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
            for (ChildAssocEntity assoc : parentAssocs.getParentAssocs().values()) {
                resultsCallback.handle(assoc.getPair(this.qnameDAO), assoc.getParentNode().getNodePair(), assoc.getChildNode().getNodePair());
            }
        } else {
            this.selectParentAssocs(childNodeId, assocTypeQName, assocQName, isPrimary, resultsCallback);
        }
    }

    @Override
    public List<Path> getPaths(Pair<Long, NodeRef> nodePair, boolean primaryOnly) throws InvalidNodeRefException {
        ArrayList<Path> paths = new ArrayList<Path>(primaryOnly ? 1 : 10);
        Path currentPath = new Path();
        Stack<Long> assocIdStack = new Stack<Long>();
        this.prependPaths(nodePair, null, currentPath, paths, assocIdStack, primaryOnly);
        if (primaryOnly && paths.size() != 1) {
            throw new RuntimeException("Node has " + paths.size() + " primary paths: " + nodePair);
        }
        if (this.loggerPaths.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(256);
            if (primaryOnly) {
                sb.append("Primary paths");
            } else {
                sb.append("Paths");
            }
            sb.append(" for node ").append(nodePair);
            for (Path path : paths) {
                sb.append("\n").append("   ").append(path);
            }
            this.loggerPaths.debug((Object)sb);
        }
        return paths;
    }

    private void prependPaths(Pair<Long, NodeRef> currentNodePair, Pair<StoreRef, NodeRef> currentRootNodePair, Path currentPath, Collection<Path> completedPaths, Stack<Long> assocIdStack, boolean primaryOnly) throws CyclicChildRelationshipException {
        ParentAssocsInfo parentAssocInfo;
        boolean hasParents;
        Long currentNodeId = (Long)currentNodePair.getFirst();
        NodeRef currentNodeRef = (NodeRef)currentNodePair.getSecond();
        StoreRef currentStoreRef = currentNodeRef.getStoreRef();
        if (currentRootNodePair == null || !currentStoreRef.equals(currentRootNodePair.getFirst())) {
            Pair<Long, NodeRef> rootNodePair = this.getRootNode(currentStoreRef);
            currentRootNodePair = new Pair((Object)currentStoreRef, rootNodePair.getSecond());
        }
        boolean bl = hasParents = (parentAssocInfo = this.getParentAssocsCached(currentNodeId)).getParentAssocs().size() > 0;
        if (!(primaryOnly && hasParents || !parentAssocInfo.isRoot())) {
            ChildAssociationRef assocRef = new ChildAssociationRef(null, null, null, (NodeRef)currentRootNodePair.getSecond());
            Path pathToSave = new Path();
            Path.ChildAssocElement first = null;
            for (Path.Element element : currentPath) {
                if (first == null) {
                    first = (Path.ChildAssocElement)element;
                    continue;
                }
                pathToSave.append(element);
            }
            if (first != null) {
                ChildAssociationRef updateAssocRef = new ChildAssociationRef(parentAssocInfo.isStoreRoot() ? ContentModel.ASSOC_CHILDREN : first.getRef().getTypeQName(), (NodeRef)currentRootNodePair.getSecond(), first.getRef().getQName(), first.getRef().getChildRef());
                Path.ChildAssocElement newFirst = new Path.ChildAssocElement(updateAssocRef);
                pathToSave.prepend((Path.Element)newFirst);
            }
            Path.ChildAssocElement element = new Path.ChildAssocElement(assocRef);
            pathToSave.prepend((Path.Element)element);
            completedPaths.add(pathToSave);
        }
        if (!hasParents && !parentAssocInfo.isRoot()) {
            throw new RuntimeException("Node without parents does not have root aspect: " + currentNodeRef);
        }
        for (Map.Entry<Long, ChildAssocEntity> entry : parentAssocInfo.getParentAssocs().entrySet()) {
            Long assocId = entry.getKey();
            ChildAssocEntity assoc = entry.getValue();
            ChildAssociationRef assocRef = assoc.getRef(this.qnameDAO);
            if (primaryOnly && !assocRef.isPrimary()) continue;
            assocRef.setNthSibling(-1);
            Path.ChildAssocElement element = new Path.ChildAssocElement(assocRef);
            Path path = new Path();
            path.append(currentPath);
            path.prepend((Path.Element)element);
            Pair parentNodePair = new Pair((Object)assoc.getParentNode().getId(), (Object)assocRef.getParentRef());
            if (assocIdStack.contains(assocId)) {
                this.logger.error((Object)("Cyclic parent-child relationship detected: \n   current node: " + currentNodeId + "\n" + "   current path: " + currentPath + "\n" + "   next assoc: " + assocId));
                throw new CyclicChildRelationshipException("Node has been pasted into its own tree.", assocRef);
            }
            assocIdStack.push(assocId);
            this.prependPaths((Pair<Long, NodeRef>)parentNodePair, (Pair<StoreRef, NodeRef>)currentRootNodePair, path, completedPaths, assocIdStack, primaryOnly);
            assocIdStack.pop();
        }
    }

    private ParentAssocsInfo getParentAssocsCached(Long nodeId) {
        Pair<Long, ParentAssocsInfo> cacheEntry = this.parentAssocsCache.getByKey(nodeId);
        if (cacheEntry == null) {
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        return (ParentAssocsInfo)cacheEntry.getSecond();
    }

    private void setParentAssocsCached(Long nodeId, ParentAssocsInfo parentAssocs) {
        this.parentAssocsCache.setValue(nodeId, parentAssocs);
    }

    @Override
    public void cacheNodes(List<NodeRef> nodeRefs) {
        if (nodeRefs.size() < 10) {
            return;
        }
        int foundCacheEntryCount = 0;
        int missingCacheEntryCount = 0;
        boolean forceBatch = false;
        HashMap<StoreRef, ArrayList<String>> uuidsByStore = new HashMap<StoreRef, ArrayList<String>>(3);
        for (NodeRef nodeRef : nodeRefs) {
            StoreRef storeRef;
            ArrayList<String> uuids;
            if (!forceBatch) {
                if (this.nodesCache.getKey(nodeRef) != null) {
                    ++foundCacheEntryCount;
                    continue;
                }
                if (foundCacheEntryCount + ++missingCacheEntryCount % 100 == 0) {
                    boolean bl = forceBatch = foundCacheEntryCount < missingCacheEntryCount;
                }
            }
            if ((uuids = (ArrayList<String>)uuidsByStore.get(storeRef = nodeRef.getStoreRef())) == null) {
                uuids = new ArrayList<String>(nodeRefs.size());
                uuidsByStore.put(storeRef, uuids);
            }
            uuids.add(nodeRef.getId());
        }
        int size = nodeRefs.size();
        nodeRefs = null;
        for (Map.Entry entry : uuidsByStore.entrySet()) {
            StoreRef storeRef = (StoreRef)entry.getKey();
            List uuids = (List)entry.getValue();
            this.cacheNodes(storeRef, uuids);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-loaded " + size + " nodes."));
        }
    }

    private void cacheNodes(StoreRef storeRef, List<String> uuids) {
        StoreEntity store = this.getStoreNotNull(storeRef);
        Long storeId = store.getId();
        int batchSize = 256;
        TreeSet<String> batch = new TreeSet<String>();
        for (String uuid : uuids) {
            batch.add(uuid);
            if (batch.size() < batchSize) continue;
            this.cacheNodesNoBatch(storeId, batch);
            batch.clear();
        }
        if (batch.size() > 0) {
            this.cacheNodesNoBatch(storeId, batch);
        }
    }

    private void cacheNodesNoBatch(Long storeId, SortedSet<String> uuids) {
        List<NodeEntity> nodes = this.selectNodesByUuids(storeId, uuids);
        TreeSet<Long> aspectNodeIds = new TreeSet<Long>();
        TreeSet<Long> propertiesNodeIds = new TreeSet<Long>();
        for (NodeEntity node : nodes) {
            Long nodeId = node.getId();
            this.nodesCache.setValue(nodeId, node);
            if (this.propertiesCache.getValue(nodeId) == null) {
                propertiesNodeIds.add(nodeId);
            }
            if (this.aspectsCache.getValue(nodeId) != null) continue;
            aspectNodeIds.add(nodeId);
        }
        List<NodeAspectsEntity> nodeAspects = this.selectNodeAspects(aspectNodeIds);
        for (NodeAspectsEntity nodeAspect : nodeAspects) {
            Long nodeId = nodeAspect.getNodeId();
            List<Long> qnameIds = nodeAspect.getAspectQNameIds();
            HashSet<Long> qnameIdsSet = new HashSet<Long>(qnameIds);
            Set<QName> qnames = this.qnameDAO.convertIdsToQNames(qnameIdsSet);
            this.aspectsCache.setValue(nodeId, qnames);
        }
        Map<Long, Map<NodePropertyKey, NodePropertyValue>> propsByNodeId = this.selectNodeProperties(propertiesNodeIds);
        for (Map.Entry<Long, Map<NodePropertyKey, NodePropertyValue>> entry : propsByNodeId.entrySet()) {
            Long nodeId = entry.getKey();
            Map<NodePropertyKey, NodePropertyValue> propertyValues = entry.getValue();
            Map<QName, Serializable> props = this.nodePropertyHelper.convertToPublicProperties(propertyValues);
            this.propertiesCache.setValue(nodeId, props);
        }
    }

    @Override
    public void clear() {
        this.nodesCache.clear();
        this.aspectsCache.clear();
        this.propertiesCache.clear();
        this.parentAssocsCache.clear();
    }

    @Override
    public Long getMaxTxnIdByCommitTime(long maxCommitTime) {
        Transaction txn = this.selectLastTxnBeforeCommitTime(maxCommitTime);
        return txn == null ? null : txn.getId();
    }

    @Override
    public int getTransactionCount() {
        return this.selectTransactionCount();
    }

    @Override
    public Transaction getTxnById(Long txnId) {
        return this.selectTxnById(txnId);
    }

    @Override
    public List<NodeRef.Status> getTxnChanges(Long txnId) {
        return this.getTxnChangesForStore(null, txnId);
    }

    @Override
    public List<NodeRef.Status> getTxnChangesForStore(StoreRef storeRef, Long txnId) {
        Long storeId = storeRef == null ? null : this.getStoreNotNull(storeRef).getId();
        List<NodeEntity> nodes = this.selectTxnChanges(txnId, storeId);
        ArrayList<NodeRef.Status> nodeStatuses = new ArrayList<NodeRef.Status>(nodes.size());
        for (NodeEntity node : nodes) {
            nodeStatuses.add(node.getNodeStatus());
        }
        return nodeStatuses;
    }

    @Override
    public int getTxnUpdateCount(Long txnId) {
        return this.selectTxnNodeChangeCount(txnId, Boolean.TRUE);
    }

    @Override
    public int getTxnDeleteCount(Long txnId) {
        return this.selectTxnNodeChangeCount(txnId, Boolean.FALSE);
    }

    @Override
    public List<Transaction> getTxnsByCommitTimeAscending(Long fromTimeInclusive, Long toTimeExclusive, int count, List<Long> excludeTxnIds, boolean remoteOnly) {
        Long serverId;
        serverId = remoteOnly ? (serverId = this.getServerId()) : null;
        return this.selectTxns(fromTimeInclusive, toTimeExclusive, count, null, excludeTxnIds, serverId, Boolean.TRUE);
    }

    @Override
    public List<Transaction> getTxnsByCommitTimeDescending(Long fromTimeInclusive, Long toTimeExclusive, int count, List<Long> excludeTxnIds, boolean remoteOnly) {
        Long serverId;
        serverId = remoteOnly ? (serverId = this.getServerId()) : null;
        return this.selectTxns(fromTimeInclusive, toTimeExclusive, count, null, excludeTxnIds, serverId, Boolean.FALSE);
    }

    @Override
    public List<Transaction> getTxnsByCommitTimeAscending(List<Long> includeTxnIds) {
        return this.selectTxns(null, null, null, includeTxnIds, null, null, Boolean.TRUE);
    }

    @Override
    public List<Long> getTxnsUnused(Long minTxnId, long maxCommitTime, int count) {
        return this.selectTxnsUnused(minTxnId, maxCommitTime, count);
    }

    @Override
    public void purgeTxn(Long txnId) {
        this.deleteTransaction(txnId);
    }

    @Override
    public Long getMinTxnCommitTime() {
        Long time = this.selectMinTxnCommitTime();
        return time == null ? LONG_ZERO : time;
    }

    @Override
    public Long getMaxTxnCommitTime() {
        Long time = this.selectMaxTxnCommitTime();
        return time == null ? LONG_ZERO : time;
    }

    protected abstract ServerEntity selectServer(String var1);

    protected abstract Long insertServer(String var1);

    protected abstract Long insertTransaction(Long var1, String var2, Long var3);

    protected abstract int updateTransaction(Long var1, Long var2);

    protected abstract int deleteTransaction(Long var1);

    protected abstract List<StoreEntity> selectAllStores();

    protected abstract NodeEntity selectStoreRootNode(Long var1);

    protected abstract NodeEntity selectStoreRootNode(StoreRef var1);

    protected abstract Long insertStore(StoreEntity var1);

    protected abstract int updateStoreRoot(StoreEntity var1);

    protected abstract int updateStore(StoreEntity var1);

    protected abstract Long insertNode(NodeEntity var1);

    protected abstract int updateNode(NodeUpdateEntity var1);

    protected abstract int updateNodePatchAcl(NodeUpdateEntity var1);

    protected abstract void updatePrimaryChildrenSharedAclId(Long var1, Long var2, Long var3);

    protected abstract int deleteNodeById(Long var1, boolean var2);

    protected abstract int deleteNodesByCommitTime(boolean var1, long var2);

    protected abstract NodeEntity selectNodeById(Long var1, Boolean var2);

    protected abstract NodeEntity selectNodeByNodeRef(NodeRef var1, Boolean var2);

    protected abstract List<NodeEntity> selectNodesByUuids(Long var1, SortedSet<String> var2);

    protected abstract Map<Long, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Set<Long> var1);

    protected abstract List<NodeAspectsEntity> selectNodeAspects(Set<Long> var1);

    protected abstract Map<NodePropertyKey, NodePropertyValue> selectNodeProperties(Long var1);

    protected abstract Map<NodePropertyKey, NodePropertyValue> selectNodeProperties(Long var1, Set<Long> var2);

    protected abstract int deleteNodeProperties(Long var1, Set<Long> var2);

    protected abstract int deleteNodeProperties(Long var1, List<NodePropertyKey> var2);

    protected abstract void insertNodeProperties(Long var1, Map<NodePropertyKey, NodePropertyValue> var2);

    protected abstract Set<Long> selectNodeAspectIds(Long var1);

    protected abstract void insertNodeAspect(Long var1, Long var2);

    protected abstract int deleteNodeAspects(Long var1, Set<Long> var2);

    protected abstract void selectNodesWithAspect(Long var1, Long var2, NodeDAO.NodeRefQueryCallback var3);

    protected abstract Long insertNodeAssoc(Long var1, Long var2, Long var3);

    protected abstract int deleteNodeAssoc(Long var1, Long var2, Long var3);

    protected abstract int deleteNodeAssocsToAndFrom(Long var1);

    protected abstract int deleteNodeAssocsToAndFrom(Long var1, Set<Long> var2);

    protected abstract List<NodeAssocEntity> selectNodeAssocsBySource(Long var1);

    protected abstract List<NodeAssocEntity> selectNodeAssocsByTarget(Long var1);

    protected abstract NodeAssocEntity selectNodeAssocById(Long var1);

    protected abstract Long insertChildAssoc(ChildAssocEntity var1);

    protected abstract int deleteChildAssocById(Long var1);

    protected abstract int updateChildAssocIndex(Long var1, Long var2, QName var3, QName var4, int var5);

    protected abstract int updateChildAssocsUniqueName(Long var1, String var2);

    protected abstract int deleteChildAssocsToAndFrom(Long var1);

    protected abstract ChildAssocEntity selectChildAssoc(Long var1);

    protected abstract List<NodeIdAndAclId> selectPrimaryChildAcls(Long var1);

    protected abstract List<ChildAssocEntity> selectChildAssoc(Long var1, Long var2, QName var3, QName var4);

    protected abstract void selectChildAssocs(Long var1, Long var2, QName var3, QName var4, Boolean var5, Boolean var6, NodeDAO.ChildAssocRefQueryCallback var7);

    protected abstract void selectChildAssocs(Long var1, Set<QName> var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract ChildAssocEntity selectChildAssoc(Long var1, QName var2, String var3);

    protected abstract void selectChildAssocs(Long var1, QName var2, Collection<String> var3, NodeDAO.ChildAssocRefQueryCallback var4);

    protected abstract void selectChildAssocsByPropertyValue(Long var1, QName var2, NodePropertyValue var3, NodeDAO.ChildAssocRefQueryCallback var4);

    protected abstract void selectChildAssocsByChildTypes(Long var1, Set<QName> var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract void selectChildAssocsWithoutParentAssocsOfType(Long var1, QName var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract void selectParentAssocs(Long var1, QName var2, QName var3, Boolean var4, NodeDAO.ChildAssocRefQueryCallback var5);

    protected abstract List<ChildAssocEntity> selectParentAssocs(Long var1);

    protected abstract List<ChildAssocEntity> selectPrimaryParentAssocs(Long var1);

    protected abstract int updatePrimaryParentAssocs(Long var1, Long var2, QName var3, QName var4, String var5);

    protected abstract Transaction selectLastTxnBeforeCommitTime(Long var1);

    protected abstract int selectTransactionCount();

    protected abstract Transaction selectTxnById(Long var1);

    protected abstract List<NodeEntity> selectTxnChanges(Long var1, Long var2);

    protected abstract int selectTxnNodeChangeCount(Long var1, Boolean var2);

    protected abstract List<Transaction> selectTxns(Long var1, Long var2, Integer var3, List<Long> var4, List<Long> var5, Long var6, Boolean var7);

    protected abstract List<Long> selectTxnsUnused(Long var1, Long var2, Integer var3);

    protected abstract Long selectMinTxnCommitTime();

    protected abstract Long selectMaxTxnCommitTime();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentAssocsCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, ParentAssocsInfo, Serializable> {
        private ParentAssocsCallbackDAO() {
        }

        @Override
        public Pair<Long, ParentAssocsInfo> createValue(ParentAssocsInfo value) {
            throw new UnsupportedOperationException("Nodes are created independently.");
        }

        @Override
        public Pair<Long, ParentAssocsInfo> findByKey(Long nodeId) {
            boolean isRoot = AbstractNodeDAOImpl.this.hasNodeAspect(nodeId, ContentModel.ASPECT_ROOT);
            boolean isStoreRoot = AbstractNodeDAOImpl.this.getNodeType(nodeId).equals((Object)ContentModel.TYPE_STOREROOT);
            List<ChildAssocEntity> assocs = AbstractNodeDAOImpl.this.selectParentAssocs(nodeId);
            ParentAssocsInfo value = new ParentAssocsInfo(isRoot, isStoreRoot, assocs);
            return new Pair((Object)nodeId, (Object)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildAssocRefBatchingQueryCallback
    implements NodeDAO.ChildAssocRefQueryCallback {
        private static final int BATCH_SIZE = 1024;
        private final NodeDAO.ChildAssocRefQueryCallback callback;
        private final boolean preload;
        private final List<NodeRef> nodeRefs;

        private ChildAssocRefBatchingQueryCallback(NodeDAO.ChildAssocRefQueryCallback callback) {
            this.callback = callback;
            this.preload = callback.preLoadNodes();
            this.nodeRefs = this.preload ? new LinkedList<NodeRef>() : null;
        }

        @Override
        public boolean preLoadNodes() {
            return false;
        }

        @Override
        public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
            if (!this.preload) {
                return this.callback.handle(childAssocPair, parentNodePair, childNodePair);
            }
            if (this.nodeRefs.size() >= 1024) {
                AbstractNodeDAOImpl.this.cacheNodes(this.nodeRefs);
                this.nodeRefs.clear();
            }
            this.nodeRefs.add((NodeRef)childNodePair.getSecond());
            return this.callback.handle(childAssocPair, parentNodePair, childNodePair);
        }

        @Override
        public void done() {
            if (this.preload && this.nodeRefs.size() > 0) {
                AbstractNodeDAOImpl.this.cacheNodes(this.nodeRefs);
                this.nodeRefs.clear();
            }
            this.callback.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AspectsCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Set<QName>, Serializable> {
        private AspectsCallbackDAO() {
        }

        @Override
        public Pair<Long, Set<QName>> createValue(Set<QName> value) {
            throw new UnsupportedOperationException("A node always has a 'set' of aspects.");
        }

        @Override
        public Pair<Long, Set<QName>> findByKey(Long nodeId) {
            Set<Long> nodeAspectQNameIds = AbstractNodeDAOImpl.this.selectNodeAspectIds(nodeId);
            Set<QName> nodeAspectQNames = AbstractNodeDAOImpl.this.qnameDAO.convertIdsToQNames(nodeAspectQNameIds);
            return new Pair((Object)nodeId, Collections.unmodifiableSet(nodeAspectQNames));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Map<QName, Serializable>, Serializable> {
        private PropertiesCallbackDAO() {
        }

        @Override
        public Pair<Long, Map<QName, Serializable>> createValue(Map<QName, Serializable> value) {
            throw new UnsupportedOperationException("A node always has a 'map' of properties.");
        }

        @Override
        public Pair<Long, Map<QName, Serializable>> findByKey(Long nodeId) {
            Map<NodePropertyKey, NodePropertyValue> propsRaw = AbstractNodeDAOImpl.this.selectNodeProperties(nodeId);
            Map<QName, Serializable> props = AbstractNodeDAOImpl.this.nodePropertyHelper.convertToPublicProperties(propsRaw);
            return new Pair((Object)nodeId, Collections.unmodifiableMap(props));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodesCacheCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Node, NodeRef> {
        private NodesCacheCallbackDAO() {
        }

        @Override
        public Pair<Long, Node> createValue(Node value) {
            throw new UnsupportedOperationException("Node creation is done externally: " + value);
        }

        @Override
        public Pair<Long, Node> findByKey(Long nodeId) {
            NodeEntity node = AbstractNodeDAOImpl.this.selectNodeById(nodeId, Boolean.FALSE);
            return node == null ? null : new Pair((Object)nodeId, (Object)node);
        }

        @Override
        public NodeRef getValueKey(Node value) {
            return value.getNodeRef();
        }

        @Override
        public Pair<Long, Node> findByValue(Node node) {
            NodeRef nodeRef = node.getNodeRef();
            return (node = AbstractNodeDAOImpl.this.selectNodeByNodeRef(nodeRef, Boolean.FALSE)) == null ? null : new Pair((Object)node.getId(), (Object)node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RootNodesCacheCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<StoreRef, Node, Serializable> {
        private RootNodesCacheCallbackDAO() {
        }

        @Override
        public Pair<StoreRef, Node> createValue(Node value) {
            throw new UnsupportedOperationException("Root node creation is done externally: " + value);
        }

        @Override
        public Pair<StoreRef, Node> findByKey(StoreRef storeRef) {
            NodeEntity node = AbstractNodeDAOImpl.this.selectStoreRootNode(storeRef);
            return node == null ? null : new Pair((Object)storeRef, (Object)node);
        }
    }

    private class UpdateTransactionListener
    extends TransactionListenerAdapter {
        private UpdateTransactionListener() {
        }

        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            TransactionEntity txn = (TransactionEntity)AlfrescoTransactionSupport.getResource(AbstractNodeDAOImpl.KEY_TRANSACTION);
            Long txnId = txn.getId();
            Long now = System.currentTimeMillis();
            AbstractNodeDAOImpl.this.updateTransaction(txnId, now);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerIdCallback
    extends ReadWriteLockExecuter<Long> {
        private TransactionAwareSingleton<Long> serverIdStorage = new TransactionAwareSingleton();

        private ServerIdCallback() {
        }

        public Long getWithReadLock() throws Throwable {
            return this.serverIdStorage.get();
        }

        public Long getWithWriteLock() throws Throwable {
            if (this.serverIdStorage.get() != null) {
                return this.serverIdStorage.get();
            }
            String ipAddress = null;
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new AlfrescoRuntimeException("Failed to get server IP address", (Throwable)e);
            }
            ServerEntity serverEntity = AbstractNodeDAOImpl.this.selectServer(ipAddress);
            if (serverEntity != null) {
                this.serverIdStorage.put(serverEntity.getId());
                return serverEntity.getId();
            }
            Long serverId = AbstractNodeDAOImpl.this.insertServer(ipAddress);
            this.serverIdStorage.put(serverId);
            if (AbstractNodeDAOImpl.this.isDebugEnabled) {
                AbstractNodeDAOImpl.this.logger.debug((Object)("Created server entity: " + serverEntity));
            }
            return serverId;
        }
    }
}

