/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.patch;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.domain.patch.AppliedPatchDAO;
import org.alfresco.repo.domain.patch.AppliedPatchEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppliedPatchDAOImpl
implements AppliedPatchDAO {
    @Override
    public void createAppliedPatch(AppliedPatch appliedPatch) {
        AppliedPatchEntity entity = new AppliedPatchEntity(appliedPatch);
        this.createAppliedPatchEntity(entity);
    }

    @Override
    public void updateAppliedPatch(AppliedPatch appliedPatch) {
        AppliedPatchEntity entity = new AppliedPatchEntity(appliedPatch);
        this.updateAppliedPatchEntity(entity);
    }

    @Override
    public AppliedPatch getAppliedPatch(String id) {
        return this.getAppliedPatchEntity(id);
    }

    @Override
    public List<AppliedPatch> getAppliedPatches() {
        List<AppliedPatchEntity> entities = this.getAppliedPatchEntities();
        ArrayList<AppliedPatch> results = new ArrayList<AppliedPatch>();
        results.addAll(entities);
        return results;
    }

    @Override
    public List<AppliedPatch> getAppliedPatches(Date from, Date to) {
        List<AppliedPatch> results = this.getAppliedPatches();
        Iterator<AppliedPatch> iterator = results.iterator();
        while (iterator.hasNext()) {
            AppliedPatch next = iterator.next();
            Date appliedOn = next.getAppliedOnDate();
            if (from != null && appliedOn != null && from.compareTo(appliedOn) >= 0) {
                iterator.remove();
                continue;
            }
            if (to == null || appliedOn == null || to.compareTo(appliedOn) > 0) continue;
            iterator.remove();
        }
        return results;
    }

    @Override
    public void setAppliedOnDate(String id, Date appliedOnDate) {
        throw new UnsupportedOperationException();
    }

    protected abstract void createAppliedPatchEntity(AppliedPatchEntity var1);

    protected abstract void updateAppliedPatchEntity(AppliedPatchEntity var1);

    protected abstract AppliedPatchEntity getAppliedPatchEntity(String var1);

    protected abstract List<AppliedPatchEntity> getAppliedPatchEntities();
}

