/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.node.ContentModelFormProcessor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFormProcessor
extends ContentModelFormProcessor<TypeDefinition, NodeRef> {
    private static Log logger = LogFactory.getLog(TypeFormProcessor.class);
    private static QName ASPECT_FILE_PLAN_COMPONENT = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"filePlanComponent");
    protected static final String NAME_PROP_DATA = "prop_cm_name";
    public static final String DESTINATION = "alf_destination";

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected TypeDefinition getTypedItem(Item item) {
        TypeDefinition typeDef = null;
        try {
            QName type = null;
            String itemId = item.getId();
            if (itemId.startsWith("{")) {
                type = QName.createQName((String)itemId);
            } else if (itemId.indexOf("_") != -1) {
                int idx = itemId.indexOf("_");
                String parsedItemId = itemId.substring(0, idx) + ":" + itemId.substring(idx + 1);
                type = QName.createQName((String)parsedItemId, (NamespacePrefixResolver)this.namespaceService);
            } else {
                type = QName.createQName((String)itemId, (NamespacePrefixResolver)this.namespaceService);
            }
            typeDef = this.dictionaryService.getType(type);
            if (typeDef == null) {
                throw new FormNotFoundException(item, new IllegalArgumentException("Type does not exist: " + item.getId()));
            }
        }
        catch (InvalidQNameException iqne) {
            throw new FormNotFoundException(item, iqne);
        }
        return typeDef;
    }

    @Override
    protected NodeRef internalPersist(TypeDefinition item, final FormData data) {
        NodeRef nodeRef;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Persisting form for: " + item));
        }
        if (this.nodeService.hasAspect(nodeRef = this.createNode(item, data), ASPECT_FILE_PLAN_COMPONENT)) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    TypeFormProcessor.this.persistNode(nodeRef, data);
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
        } else {
            this.persistNode(nodeRef, data);
        }
        return nodeRef;
    }

    protected NodeRef createNode(TypeDefinition typeDef, FormData data) {
        NodeRef nodeRef = null;
        if (data != null) {
            NodeRef parentRef = null;
            FormData.FieldData destination = data.getFieldData(DESTINATION);
            if (destination == null) {
                throw new FormException("Failed to persist form for '" + typeDef.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService) + "' as '" + DESTINATION + "' data was not provided.");
            }
            parentRef = new NodeRef((String)destination.getValue());
            data.removeFieldData(DESTINATION);
            String nodeName = null;
            FormData.FieldData nameData = data.getFieldData(NAME_PROP_DATA);
            if (nameData != null) {
                nodeName = (String)nameData.getValue();
                data.removeFieldData(NAME_PROP_DATA);
            }
            if (nodeName == null || nodeName.length() == 0) {
                nodeName = GUID.generate();
            }
            HashMap<QName, String> nodeProps = new HashMap<QName, String>(1);
            nodeProps.put(ContentModel.PROP_NAME, nodeName);
            nodeRef = this.nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)nodeName)), typeDef.getName(), nodeProps).getChildRef();
        }
        return nodeRef;
    }

    @Override
    protected String getItemType(TypeDefinition item) {
        return item.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService);
    }

    @Override
    protected String getItemURI(TypeDefinition item) {
        return "/api/classes/" + this.getItemType(item).replace(":", "_");
    }

    @Override
    protected TypeDefinition getBaseType(TypeDefinition type) {
        return type;
    }

    @Override
    protected Map<QName, Serializable> getAssociationValues(TypeDefinition item) {
        return null;
    }

    @Override
    protected Map<QName, Serializable> getPropertyValues(TypeDefinition item) {
        return null;
    }

    @Override
    protected Map<String, Object> getTransientValues(TypeDefinition item) {
        return null;
    }

    @Override
    protected List<String> getDefaultIgnoredFields() {
        return null;
    }
}

