/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.node.ContentModelFormProcessor;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.workflow.ContentModelFormPersister;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWorkflowFormProcessor<ItemType, PersistType>
extends ContentModelFormProcessor<ItemType, PersistType> {
    protected WorkflowService workflowService;

    @Override
    protected void populateForm(Form form, List<String> fields, FormCreationData data) {
        super.populateForm(form, fields, data);
        ContentModelItemData itemData = (ContentModelItemData)data.getItemData();
        this.addPropertyDataIfRequired(WorkflowModel.PROP_PACKAGE_ACTION_GROUP, form, itemData);
        this.addPropertyDataIfRequired(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP, form, itemData);
    }

    @Override
    protected PersistType internalPersist(ItemType item, FormData data) {
        ContentModelFormPersister<PersistType> persister = this.makeFormPersister(item);
        for (FormData.FieldData fieldData : data) {
            persister.addField(fieldData);
        }
        return persister.persist();
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    protected ItemType getTypedItem(Item item) {
        try {
            ParameterCheck.mandatory((String)"item", (Object)item);
            String itemId = this.decodeId(item.getId());
            return this.getTypedItemForDecodedId(itemId);
        }
        catch (Exception e) {
            throw new FormNotFoundException(item, e);
        }
    }

    private String decodeId(String itemId) {
        String decodedId = itemId;
        if (!itemId.contains("$")) {
            decodedId = itemId.replaceFirst("_", Matcher.quoteReplacement("$"));
        }
        return decodedId;
    }

    @Override
    protected List<String> getDefaultIgnoredFields() {
        ArrayList<String> fields = new ArrayList<String>(5);
        fields.add("cm:name");
        fields.add("cm:owner");
        fields.add("bpm:package");
        fields.add("bpm:pooledActors");
        fields.add("bpm:completedItems");
        fields.add("sys:node-dbid");
        fields.add("sys:store-identifier");
        fields.add("bpm:completionDate");
        fields.add("bpm:context");
        fields.add("sys:node-uuid");
        fields.add("bpm:hiddenTransitions");
        fields.add("bpm:reassignable");
        fields.add("cm:creator");
        fields.add("cm:modifier");
        fields.add("bpm:packageActionGroup");
        fields.add("bpm:packageItemActionGroup");
        fields.add("bpm:outcome");
        fields.add("cm:content");
        fields.add("cm:accessed");
        fields.add("bpm:startDate");
        fields.add("cm:modified");
        fields.add("cm:created");
        fields.add("sys:store-protocol");
        return fields;
    }

    protected abstract ContentModelFormPersister<PersistType> makeFormPersister(ItemType var1);

    protected abstract ItemType getTypedItemForDecodedId(String var1);
}

