/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.user.GreenMailUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoImapHostManager
implements ImapHostManager {
    private ImapService imapService;
    private TransactionService transactionService;
    private static Log logger = LogFactory.getLog(AlfrescoImapHostManager.class);

    public char getHierarchyDelimiter() {
        return '/';
    }

    public Collection<MailFolder> listMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        try {
            return new ArrayList<MailFolder>(this.imapService.listMailboxes(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailboxPattern));
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public Collection<MailFolder> listSubscribedMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        try {
            return new ArrayList<MailFolder>(this.imapService.listSubscribedMailboxes(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailboxPattern));
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public void renameMailbox(GreenMailUser user, String oldMailboxName, String newMailboxName) throws FolderException, AuthorizationException {
        try {
            this.imapService.renameMailbox(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), oldMailboxName, newMailboxName);
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public MailFolder createMailbox(GreenMailUser user, String mailboxName) throws AuthorizationException, FolderException {
        try {
            return this.imapService.createMailbox(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailboxName);
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public void deleteMailbox(GreenMailUser user, String mailboxName) throws FolderException, AuthorizationException {
        try {
            this.imapService.deleteMailbox(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailboxName);
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public MailFolder getFolder(GreenMailUser user, String mailboxName) {
        return this.imapService.getFolder(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailboxName);
    }

    public MailFolder getFolder(GreenMailUser user, String mailboxName, boolean mustExist) throws FolderException {
        try {
            return this.getFolder(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailboxName);
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public MailFolder getInbox(GreenMailUser user) throws FolderException {
        try {
            return this.getFolder(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), "INBOX");
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public void createPrivateMailAccount(GreenMailUser user) throws FolderException {
        throw new UnsupportedOperationException();
    }

    public void subscribe(GreenMailUser user, String mailbox) throws FolderException {
        try {
            this.imapService.subscribe(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailbox);
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public void unsubscribe(GreenMailUser user, String mailbox) throws FolderException {
        try {
            this.imapService.unsubscribe(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), mailbox);
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public List<?> getAllMessages() {
        throw new UnsupportedOperationException();
    }

    public ImapService getImapService() {
        return this.imapService;
    }

    public void setImapService(ImapService imapService) {
        this.imapService = imapService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

